/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.tools.pushapps;

import java.time.Duration;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.cloudfoundry.client.CloudFoundryClient;
import org.cloudfoundry.doppler.DopplerClient;
import org.cloudfoundry.operations.CloudFoundryOperations;
import org.cloudfoundry.operations.DefaultCloudFoundryOperations;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.DefaultConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.client.ReactorCloudFoundryClient;
import org.cloudfoundry.reactor.doppler.ReactorDopplerClient;
import org.cloudfoundry.reactor.tokenprovider.PasswordGrantTokenProvider;
import org.cloudfoundry.reactor.uaa.ReactorUaaClient;
import org.cloudfoundry.uaa.UaaClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010(\u001a\u00020\u0011J\u0018\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u0010/\u001a\u00020*2\u0006\u00100\u001a\u00020\u0011H\u0002J\b\u0010+\u001a\u00020,H\u0002J\u000e\u00101\u001a\u00020\u00002\u0006\u00102\u001a\u00020\u0011J\b\u0010-\u001a\u00020.H\u0002R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0006\"\u0004\b\u0018\u0010\bR\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0006\"\u0004\b\u001b\u0010\bR\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001c\u0010\"\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0006\"\u0004\b$\u0010\bR\u001c\u0010%\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0006\"\u0004\b'\u0010\b\u00a8\u00063"}, d2={"Lorg/cloudfoundry/tools/pushapps/CloudFoundryOperationsBuilder;", "", "()V", "apiHost", "", "getApiHost", "()Ljava/lang/String;", "setApiHost", "(Ljava/lang/String;)V", "dialTimeoutInMillis", "", "getDialTimeoutInMillis", "()Ljava/lang/Long;", "setDialTimeoutInMillis", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "existingCloudFoundryOperations", "Lorg/cloudfoundry/operations/CloudFoundryOperations;", "getExistingCloudFoundryOperations", "()Lorg/cloudfoundry/operations/CloudFoundryOperations;", "setExistingCloudFoundryOperations", "(Lorg/cloudfoundry/operations/CloudFoundryOperations;)V", "organization", "getOrganization", "setOrganization", "password", "getPassword", "setPassword", "skipSslValidation", "", "getSkipSslValidation", "()Z", "setSkipSslValidation", "(Z)V", "space", "getSpace", "setSpace", "username", "getUsername", "setUsername", "build", "buildCfOperations", "Lorg/cloudfoundry/operations/DefaultCloudFoundryOperations;", "connectionContext", "Lorg/cloudfoundry/reactor/ConnectionContext;", "tokenProvider", "Lorg/cloudfoundry/reactor/TokenProvider;", "buildCfOperationsFromExisting", "cloudFoundryOperations", "fromExistingOperations", "operations", "push-apps"})
public final class CloudFoundryOperationsBuilder {
    @Nullable
    private String apiHost;
    @Nullable
    private String username;
    @Nullable
    private String password;
    @Nullable
    private String organization;
    @Nullable
    private String space;
    private boolean skipSslValidation;
    @Nullable
    private CloudFoundryOperations existingCloudFoundryOperations;
    @Nullable
    private Long dialTimeoutInMillis;

    @Nullable
    public final String getApiHost() {
        return this.apiHost;
    }

    public final void setApiHost(@Nullable String string) {
        this.apiHost = string;
    }

    @Nullable
    public final String getUsername() {
        return this.username;
    }

    public final void setUsername(@Nullable String string) {
        this.username = string;
    }

    @Nullable
    public final String getPassword() {
        return this.password;
    }

    public final void setPassword(@Nullable String string) {
        this.password = string;
    }

    @Nullable
    public final String getOrganization() {
        return this.organization;
    }

    public final void setOrganization(@Nullable String string) {
        this.organization = string;
    }

    @Nullable
    public final String getSpace() {
        return this.space;
    }

    public final void setSpace(@Nullable String string) {
        this.space = string;
    }

    public final boolean getSkipSslValidation() {
        return this.skipSslValidation;
    }

    public final void setSkipSslValidation(boolean bl) {
        this.skipSslValidation = bl;
    }

    @Nullable
    public final CloudFoundryOperations getExistingCloudFoundryOperations() {
        return this.existingCloudFoundryOperations;
    }

    public final void setExistingCloudFoundryOperations(@Nullable CloudFoundryOperations cloudFoundryOperations) {
        this.existingCloudFoundryOperations = cloudFoundryOperations;
    }

    @Nullable
    public final Long getDialTimeoutInMillis() {
        return this.dialTimeoutInMillis;
    }

    public final void setDialTimeoutInMillis(@Nullable Long l) {
        this.dialTimeoutInMillis = l;
    }

    @NotNull
    public final CloudFoundryOperations build() {
        if (this.existingCloudFoundryOperations != null) {
            CloudFoundryOperations cloudFoundryOperations = this.existingCloudFoundryOperations;
            if (cloudFoundryOperations == null) {
                Intrinsics.throwNpe();
            }
            return (CloudFoundryOperations)this.buildCfOperationsFromExisting(cloudFoundryOperations);
        }
        ConnectionContext connectionContext = this.connectionContext();
        TokenProvider tokenProvider = this.tokenProvider();
        return (CloudFoundryOperations)this.buildCfOperations(connectionContext, tokenProvider);
    }

    @NotNull
    public final CloudFoundryOperationsBuilder fromExistingOperations(@NotNull CloudFoundryOperations operations) {
        Intrinsics.checkParameterIsNotNull((Object)operations, (String)"operations");
        this.existingCloudFoundryOperations = operations;
        return this;
    }

    private final DefaultCloudFoundryOperations buildCfOperationsFromExisting(CloudFoundryOperations cloudFoundryOperations) {
        CloudFoundryOperations cloudFoundryOperations2 = cloudFoundryOperations;
        if (cloudFoundryOperations2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.cloudfoundry.operations.DefaultCloudFoundryOperations");
        }
        DefaultCloudFoundryOperations.Builder cfOperationsBuilder = DefaultCloudFoundryOperations.builder().from((DefaultCloudFoundryOperations)cloudFoundryOperations2);
        if (this.organization != null) {
            cfOperationsBuilder.organization(this.organization);
        }
        if (this.space != null) {
            cfOperationsBuilder.space(this.space);
        }
        DefaultCloudFoundryOperations defaultCloudFoundryOperations = cfOperationsBuilder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)defaultCloudFoundryOperations, (String)"cfOperationsBuilder.build()");
        return defaultCloudFoundryOperations;
    }

    private final DefaultCloudFoundryOperations buildCfOperations(ConnectionContext connectionContext, TokenProvider tokenProvider) {
        ReactorCloudFoundryClient cfClient = ReactorCloudFoundryClient.builder().connectionContext(connectionContext).tokenProvider(tokenProvider).build();
        ReactorDopplerClient dopplerClient = ReactorDopplerClient.builder().connectionContext(connectionContext).tokenProvider(tokenProvider).build();
        ReactorUaaClient uaaClient = ReactorUaaClient.builder().connectionContext(connectionContext).tokenProvider(tokenProvider).build();
        DefaultCloudFoundryOperations.Builder cfOperationsBuilder = DefaultCloudFoundryOperations.builder().cloudFoundryClient((CloudFoundryClient)cfClient).dopplerClient((DopplerClient)dopplerClient).uaaClient((UaaClient)uaaClient);
        if (this.organization != null) {
            cfOperationsBuilder.organization(this.organization);
        }
        if (this.space != null) {
            cfOperationsBuilder.space(this.space);
        }
        DefaultCloudFoundryOperations defaultCloudFoundryOperations = cfOperationsBuilder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)defaultCloudFoundryOperations, (String)"cfOperationsBuilder.build()");
        return defaultCloudFoundryOperations;
    }

    private final ConnectionContext connectionContext() {
        DefaultConnectionContext.Builder connectionContextBuilder = DefaultConnectionContext.builder();
        if (this.apiHost != null) {
            connectionContextBuilder.apiHost(this.apiHost);
        }
        if (this.dialTimeoutInMillis != null) {
            Long l = this.dialTimeoutInMillis;
            if (l == null) {
                Intrinsics.throwNpe();
            }
            connectionContextBuilder.connectTimeout(Duration.ofMillis(l));
        }
        DefaultConnectionContext defaultConnectionContext = connectionContextBuilder.skipSslValidation(this.skipSslValidation).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)defaultConnectionContext, (String)"connectionContextBuilder\u2026ion)\n            .build()");
        return (ConnectionContext)defaultConnectionContext;
    }

    private final TokenProvider tokenProvider() {
        PasswordGrantTokenProvider.Builder tokenProviderBuilder = PasswordGrantTokenProvider.builder();
        if (this.password != null) {
            tokenProviderBuilder.password(this.password);
        }
        if (this.username != null) {
            tokenProviderBuilder.username(this.username);
        }
        PasswordGrantTokenProvider passwordGrantTokenProvider = tokenProviderBuilder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)passwordGrantTokenProvider, (String)"tokenProviderBuilder.build()");
        return (TokenProvider)passwordGrantTokenProvider;
    }
}

