/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.tools.pushapps;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cloudfoundry.tools.pushapps.AsyncLoggerKt;
import org.cloudfoundry.tools.pushapps.CloudFoundryClient;
import org.cloudfoundry.tools.pushapps.OperationResult;
import org.cloudfoundry.tools.pushapps.ScheduleOperationsKt;
import org.cloudfoundry.tools.pushapps.SecurityGroupCreator;
import org.cloudfoundry.tools.pushapps.SecurityGroupCreator$createSecurityGroups$2;
import org.cloudfoundry.tools.pushapps.SecurityGroupCreatorKt$sam$Function$5c03fc99;
import org.cloudfoundry.tools.pushapps.config.OperationConfig;
import org.cloudfoundry.tools.pushapps.config.SecurityGroup;
import org.jetbrains.annotations.NotNull;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004H\u0002J\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00142\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/cloudfoundry/tools/pushapps/SecurityGroupCreator;", "", "securityGroups", "", "Lorg/cloudfoundry/tools/pushapps/config/SecurityGroup;", "cloudFoundryClient", "Lorg/cloudfoundry/tools/pushapps/CloudFoundryClient;", "maxInFlight", "", "(Ljava/util/List;Lorg/cloudfoundry/tools/pushapps/CloudFoundryClient;I)V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "createSecurityGroup", "Lreactor/core/publisher/Mono;", "Lorg/cloudfoundry/tools/pushapps/OperationResult;", "spaceId", "", "group", "createSecurityGroups", "Lreactor/core/publisher/Flux;", "push-apps"})
public final class SecurityGroupCreator {
    private final Logger logger;
    private final List<SecurityGroup> securityGroups;
    private final CloudFoundryClient cloudFoundryClient;
    private final int maxInFlight;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Flux<OperationResult> createSecurityGroups(@NotNull String spaceId) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)spaceId, (String)"spaceId");
        Iterable iterable = $receiver$iv = (Iterable)this.securityGroups;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            void receiver;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            String string = ((SecurityGroup)receiver).getName();
            collection.add(string);
        }
        List securityGroupNames = (List)destination$iv$iv;
        this.logger.info("Creating security groups: " + CollectionsKt.joinToString$default((Iterable)securityGroupNames, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + '.');
        return ScheduleOperationsKt.scheduleOperations$default(this.securityGroups, this.maxInFlight, (Function1)new Function1<SecurityGroup, Mono<OperationResult>>(this, spaceId){
            final /* synthetic */ SecurityGroupCreator this$0;
            final /* synthetic */ String $spaceId;

            @NotNull
            public final Mono<OperationResult> invoke(@NotNull SecurityGroup group) {
                Intrinsics.checkParameterIsNotNull((Object)group, (String)"group");
                return SecurityGroupCreator.access$createSecurityGroup(this.this$0, this.$spaceId, group);
            }
            {
                this.this$0 = securityGroupCreator;
                this.$spaceId = string;
                super(1);
            }
        }, (Function1)SecurityGroupCreator$createSecurityGroups$2.INSTANCE, createSecurityGroups.3.INSTANCE, null, 32, null);
    }

    private final Mono<OperationResult> createSecurityGroup(String spaceId, SecurityGroup group) {
        String description = "Create security group " + group.getName();
        Function1 function1 = null;
        Throwable throwable = null;
        OperationConfig operationConfig = group;
        boolean bl = true;
        OperationResult operationResult = new OperationResult(description, operationConfig, bl, throwable, (Flux)function1, 24, null);
        Mono mono = this.cloudFoundryClient.createSecurityGroup(group, spaceId).onErrorResume((Function)createSecurityGroup.1.INSTANCE);
        Logger logger = this.logger;
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"logger");
        Object object = AsyncLoggerKt.logAsyncOperation(logger, description);
        if (object != null) {
            function1 = object;
            object = new SecurityGroupCreatorKt$sam$Function$5c03fc99(function1);
        }
        Mono mono2 = mono.transform((Function)object).then(Mono.just((Object)operationResult));
        Intrinsics.checkExpressionValueIsNotNull((Object)mono2, (String)"cloudFoundryClient\n     \u2026no.just(operationResult))");
        return mono2;
    }

    public SecurityGroupCreator(@NotNull List<SecurityGroup> securityGroups, @NotNull CloudFoundryClient cloudFoundryClient, int maxInFlight) {
        Intrinsics.checkParameterIsNotNull(securityGroups, (String)"securityGroups");
        Intrinsics.checkParameterIsNotNull((Object)cloudFoundryClient, (String)"cloudFoundryClient");
        this.securityGroups = securityGroups;
        this.cloudFoundryClient = cloudFoundryClient;
        this.maxInFlight = maxInFlight;
        this.logger = LogManager.getLogger(SecurityGroupCreator.class);
    }

    @NotNull
    public static final /* synthetic */ Mono access$createSecurityGroup(SecurityGroupCreator $this, @NotNull String spaceId, @NotNull SecurityGroup group) {
        return $this.createSecurityGroup(spaceId, group);
    }
}

