/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.tools.pushapps;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cloudfoundry.tools.pushapps.AsyncLoggerKt;
import org.cloudfoundry.tools.pushapps.CloudFoundryClient;
import org.cloudfoundry.tools.pushapps.OperationResult;
import org.cloudfoundry.tools.pushapps.ScheduleOperationsKt;
import org.cloudfoundry.tools.pushapps.ServiceCreator$createServices$2;
import org.cloudfoundry.tools.pushapps.ServiceCreatorKt$sam$Function$3ff5eb23;
import org.cloudfoundry.tools.pushapps.config.ServiceConfig;
import org.jetbrains.annotations.NotNull;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0004H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u0004H\u0002J\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0014J\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/cloudfoundry/tools/pushapps/ServiceCreator;", "", "serviceConfigs", "", "Lorg/cloudfoundry/tools/pushapps/config/ServiceConfig;", "cloudFoundryClient", "Lorg/cloudfoundry/tools/pushapps/CloudFoundryClient;", "maxInFlight", "", "(Ljava/util/List;Lorg/cloudfoundry/tools/pushapps/CloudFoundryClient;I)V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "createService", "Lreactor/core/publisher/Mono;", "Lorg/cloudfoundry/tools/pushapps/OperationResult;", "serviceConfig", "createServiceDescription", "", "createServices", "Lreactor/core/publisher/Flux;", "filterExistingServices", "configs", "push-apps"})
public final class ServiceCreator {
    private final Logger logger;
    private final List<ServiceConfig> serviceConfigs;
    private final CloudFoundryClient cloudFoundryClient;
    private final int maxInFlight;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Flux<OperationResult> createServices() {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        List<ServiceConfig> servicesToCreate = this.filterExistingServices(this.serviceConfigs);
        Iterable iterable = $receiver$iv = (Iterable)servicesToCreate;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            void receiver;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            String string = ((ServiceConfig)receiver).getName();
            collection.add(string);
        }
        List serviceNames = (List)destination$iv$iv;
        this.logger.info("Creating services: " + CollectionsKt.joinToString$default((Iterable)serviceNames, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + '.');
        return ScheduleOperationsKt.scheduleOperations$default(servicesToCreate, this.maxInFlight, (Function1)new Function1<ServiceConfig, Mono<OperationResult>>(this){

            @NotNull
            public final Mono<OperationResult> invoke(@NotNull ServiceConfig p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                return ServiceCreator.access$createService((ServiceCreator)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(ServiceCreator.class);
            }

            public final String getName() {
                return "createService";
            }

            public final String getSignature() {
                return "createService(Lorg/cloudfoundry/tools/pushapps/config/ServiceConfig;)Lreactor/core/publisher/Mono;";
            }
        }, (Function1)ServiceCreator$createServices$2.INSTANCE, (Function1)new Function1<ServiceConfig, String>(this){

            @NotNull
            public final String invoke(@NotNull ServiceConfig p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                return ServiceCreator.access$createServiceDescription((ServiceCreator)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(ServiceCreator.class);
            }

            public final String getName() {
                return "createServiceDescription";
            }

            public final String getSignature() {
                return "createServiceDescription(Lorg/cloudfoundry/tools/pushapps/config/ServiceConfig;)Ljava/lang/String;";
            }
        }, null, 32, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<ServiceConfig> filterExistingServices(List<ServiceConfig> configs) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = this.cloudFoundryClient.listServices().toIterable();
        Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"cloudFoundryClient\n     \u2026            .toIterable()");
        List existingServiceNames = CollectionsKt.toList((Iterable)iterable);
        Iterable iterable2 = $receiver$iv = (Iterable)configs;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            ServiceConfig serviceConfig = (ServiceConfig)element$iv$iv;
            if (!(!existingServiceNames.contains(serviceConfig.getName()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final String createServiceDescription(ServiceConfig serviceConfig) {
        return "Create service " + serviceConfig.getName();
    }

    private final Mono<OperationResult> createService(ServiceConfig serviceConfig) {
        String description = this.createServiceDescription(serviceConfig);
        OperationResult operationResult = new OperationResult(description, serviceConfig, true, null, null, 24, null);
        Mono<Void> mono = this.cloudFoundryClient.createService(serviceConfig);
        Logger logger = this.logger;
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"logger");
        Object object = AsyncLoggerKt.logAsyncOperation(logger, description);
        if (object != null) {
            Function1 function1 = object;
            object = new ServiceCreatorKt$sam$Function$3ff5eb23(function1);
        }
        Mono mono2 = mono.transform((Function)object).then(Mono.just((Object)operationResult));
        Intrinsics.checkExpressionValueIsNotNull((Object)mono2, (String)"cloudFoundryClient\n     \u2026no.just(operationResult))");
        return mono2;
    }

    public ServiceCreator(@NotNull List<ServiceConfig> serviceConfigs, @NotNull CloudFoundryClient cloudFoundryClient, int maxInFlight) {
        Intrinsics.checkParameterIsNotNull(serviceConfigs, (String)"serviceConfigs");
        Intrinsics.checkParameterIsNotNull((Object)cloudFoundryClient, (String)"cloudFoundryClient");
        this.serviceConfigs = serviceConfigs;
        this.cloudFoundryClient = cloudFoundryClient;
        this.maxInFlight = maxInFlight;
        this.logger = LogManager.getLogger(ServiceCreator.class);
    }

    @NotNull
    public static final /* synthetic */ Mono access$createService(ServiceCreator $this, @NotNull ServiceConfig serviceConfig) {
        return $this.createService(serviceConfig);
    }

    @NotNull
    public static final /* synthetic */ String access$createServiceDescription(ServiceCreator $this, @NotNull ServiceConfig serviceConfig) {
        return $this.createServiceDescription(serviceConfig);
    }
}

