/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.tools.pushapps.config;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.cloudfoundry.tools.pushapps.config.AppConfig;
import org.cloudfoundry.tools.pushapps.config.Route;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002J\u0019\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/cloudfoundry/tools/pushapps/config/ApplicationDeserializer;", "Lcom/fasterxml/jackson/databind/deser/std/StdDeserializer;", "Lorg/cloudfoundry/tools/pushapps/config/AppConfig;", "()V", "blueGreenRequirementsMet", "", "blueGreenDeploy", "noRoute", "route", "Lorg/cloudfoundry/tools/pushapps/config/Route;", "convertToMegabytes", "", "memoryText", "", "(Ljava/lang/String;)Ljava/lang/Integer;", "deserialize", "p", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "push-apps"})
public final class ApplicationDeserializer
extends StdDeserializer<AppConfig> {
    @NotNull
    public AppConfig deserialize(@NotNull JsonParser p, @NotNull DeserializationContext ctxt) {
        List list;
        Map environment;
        Map map2;
        Route route;
        Intrinsics.checkParameterIsNotNull((Object)p, (String)"p");
        Intrinsics.checkParameterIsNotNull((Object)ctxt, (String)"ctxt");
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        ObjectMapper mapper = new ObjectMapper().registerModule((Module)new KotlinModule(0, 1, null));
        JsonNode jsonNode = node.get("blueGreenDeploy");
        boolean blueGreenDeploy = jsonNode != null ? jsonNode.asBoolean() : false;
        JsonNode jsonNode2 = node.get("noRoute");
        boolean noRoute = jsonNode2 != null ? jsonNode2.asBoolean() : false;
        Route route2 = route = node.has("route") ? (Route)mapper.convertValue((Object)node.get("route"), Route.class) : null;
        if (!this.blueGreenRequirementsMet(blueGreenDeploy, noRoute, route)) {
            throw (Throwable)new IOException("When doing a blue green deployment, either a route must be provided, or noRoute must be set to true.");
        }
        if (node.has("environment")) {
            TypeReference typeReference = (TypeReference)new TypeReference<Map<String, ? extends String>>(){};
            map2 = (Map)mapper.convertValue((Object)node.get("environment"), typeReference);
        } else {
            map2 = environment = null;
        }
        if (node.has("serviceNames")) {
            TypeReference typeReference = (TypeReference)new TypeReference<List<? extends String>>(){};
            list = (List)mapper.convertValue((Object)node.get("serviceNames"), typeReference);
        } else {
            list = CollectionsKt.emptyList();
        }
        List serviceNames = list;
        JsonNode jsonNode3 = node.get("memory");
        String memoryText = jsonNode3 != null ? jsonNode3.asText() : null;
        Integer memory = this.convertToMegabytes(memoryText);
        JsonNode jsonNode4 = node.get("diskQuota");
        String diskQuotaText = jsonNode4 != null ? jsonNode4.asText() : null;
        Integer diskQuota = this.convertToMegabytes(diskQuotaText);
        String name = node.get("name").asText();
        String path = node.get("path").asText();
        JsonNode jsonNode5 = node.get("buildpack");
        String buildpack = jsonNode5 != null ? jsonNode5.asText() : null;
        JsonNode jsonNode6 = node.get("command");
        String command = jsonNode6 != null ? jsonNode6.asText() : null;
        JsonNode jsonNode7 = node.get("instances");
        Integer instances = jsonNode7 != null ? Integer.valueOf(jsonNode7.asInt()) : null;
        JsonNode jsonNode8 = node.get("noHostname");
        Boolean noHostname = jsonNode8 != null ? Boolean.valueOf(jsonNode8.asBoolean()) : null;
        JsonNode jsonNode9 = node.get("timeout");
        Integer timeout = jsonNode9 != null ? Integer.valueOf(jsonNode9.asInt()) : null;
        JsonNode jsonNode10 = node.get("domain");
        String domain = jsonNode10 != null ? jsonNode10.asText() : null;
        JsonNode jsonNode11 = node.get("healthCheckType");
        String healthCheckType = jsonNode11 != null ? jsonNode11.asText() : null;
        JsonNode jsonNode12 = node.get("optional");
        boolean optional = jsonNode12 != null ? jsonNode12.asBoolean() : false;
        String string = name;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
        String string2 = path;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"path");
        List list2 = serviceNames;
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"serviceNames");
        return new AppConfig(string, string2, buildpack, command, environment, instances, diskQuota, memory, noHostname, noRoute, route, timeout, blueGreenDeploy, domain, healthCheckType, list2, optional);
    }

    private final boolean blueGreenRequirementsMet(boolean blueGreenDeploy, boolean noRoute, Route route) {
        return blueGreenDeploy ? noRoute || route != null : true;
    }

    private final Integer convertToMegabytes(String memoryText) {
        String memoryTextWithoutSuffix = memoryText;
        if (memoryTextWithoutSuffix == null) {
            return null;
        }
        int multiplier = 1;
        if (StringsKt.endsWith((String)memoryTextWithoutSuffix, (String)"M", (boolean)true)) {
            memoryTextWithoutSuffix = StringsKt.dropLast((String)memoryTextWithoutSuffix, (int)1);
        } else if (StringsKt.endsWith((String)memoryTextWithoutSuffix, (String)"G", (boolean)true)) {
            memoryTextWithoutSuffix = StringsKt.dropLast((String)memoryTextWithoutSuffix, (int)1);
            multiplier = 1024;
        }
        String string = memoryTextWithoutSuffix;
        return Integer.parseInt(string) * multiplier;
    }

    public ApplicationDeserializer() {
        super(AppConfig.class);
    }
}

