/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.tools.pushapps.config;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.cloudfoundry.tools.pushapps.config.DatabaseDriver;
import org.cloudfoundry.tools.pushapps.config.Migration;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/cloudfoundry/tools/pushapps/config/MigrationSerializer;", "Lcom/fasterxml/jackson/databind/ser/std/StdSerializer;", "Lorg/cloudfoundry/tools/pushapps/config/Migration;", "()V", "serialize", "", "value", "gen", "Lcom/fasterxml/jackson/core/JsonGenerator;", "provider", "Lcom/fasterxml/jackson/databind/SerializerProvider;", "push-apps"})
public final class MigrationSerializer
extends StdSerializer<Migration> {
    public void serialize(@NotNull Migration value, @NotNull JsonGenerator gen, @NotNull SerializerProvider provider) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)gen, (String)"gen");
        Intrinsics.checkParameterIsNotNull((Object)provider, (String)"provider");
        gen.writeStartObject();
        gen.writeStringField("user", value.getUser());
        gen.writeStringField("password", value.getPassword());
        gen.writeStringField("host", value.getHost());
        gen.writeStringField("port", value.getPort());
        gen.writeStringField("schema", value.getSchema());
        gen.writeStringField("migrationDir", value.getMigrationDir());
        gen.writeBooleanField("repair", value.getRepair());
        DatabaseDriver databaseDriver = value.getDriver();
        if (databaseDriver instanceof DatabaseDriver.MySql) {
            string = "mysql";
        } else if (databaseDriver instanceof DatabaseDriver.Postgres) {
            string = "postgres";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String driver = string;
        gen.writeStringField("driver", driver);
        gen.writeEndObject();
    }

    public MigrationSerializer() {
        super(Migration.class);
    }
}

