/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.control;

import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.control.SourceUnit;

public class GenericsVisitor
extends ClassCodeVisitorSupport {
    private SourceUnit source;

    public GenericsVisitor(SourceUnit source) {
        this.source = source;
    }

    @Override
    protected SourceUnit getSourceUnit() {
        return this.source;
    }

    @Override
    public void visitClass(ClassNode node) {
        boolean error = this.checkWildcard(node);
        if (error) {
            return;
        }
        this.checkGenericsUsage(node.getUnresolvedSuperClass(false), node.getSuperClass());
        ClassNode[] interfaces = node.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            this.checkGenericsUsage(interfaces[i], interfaces[i].redirect());
            ++i;
        }
        node.visitContents(this);
    }

    @Override
    public void visitField(FieldNode node) {
        ClassNode type = node.getType();
        this.checkGenericsUsage(type, type.redirect());
    }

    @Override
    public void visitMethod(MethodNode node) {
        Parameter[] parameters;
        Parameter[] parameterArray = parameters = node.getParameters();
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter param = parameterArray[n2];
            ClassNode paramType = param.getType();
            this.checkGenericsUsage(paramType, paramType.redirect());
            ++n2;
        }
        ClassNode returnType = node.getReturnType();
        this.checkGenericsUsage(returnType, returnType.redirect());
    }

    private boolean checkWildcard(ClassNode cn) {
        ClassNode sn = cn.getUnresolvedSuperClass(false);
        if (sn == null) {
            return false;
        }
        GenericsType[] generics = sn.getGenericsTypes();
        if (generics == null) {
            return false;
        }
        boolean error = false;
        int i = 0;
        while (i < generics.length) {
            if (generics[i].isWildcard()) {
                this.addError("A supertype may not specify a wildcard type", sn);
                error = true;
            }
            ++i;
        }
        return error;
    }

    private void checkGenericsUsage(ClassNode n, ClassNode cn) {
        if (n.isGenericsPlaceHolder()) {
            return;
        }
        GenericsType[] nTypes = n.getGenericsTypes();
        GenericsType[] cnTypes = cn.getGenericsTypes();
        if (nTypes == null) {
            return;
        }
        if (cnTypes == null) {
            this.addError("The class " + n.getName() + " refers to the class " + cn.getName() + " and uses " + nTypes.length + " parameters, but the referred class takes no parameters", n);
            return;
        }
        if (nTypes.length != cnTypes.length) {
            this.addError("The class " + n.getName() + " refers to the class " + cn.getName() + " and uses " + nTypes.length + " parameters, but the referred class needs " + cnTypes.length, n);
            return;
        }
        int i = 0;
        while (i < nTypes.length) {
            ClassNode nType = nTypes[i].getType();
            ClassNode cnType = cnTypes[i].getType();
            if (!(nTypes[i].isWildcard() || nType.isDerivedFrom(cnType) || cnType.isInterface() && nType.implementsInterface(cnType))) {
                this.addError("The type " + nTypes[i].getName() + " is not a valid substitute for the bounded parameter <" + GenericsVisitor.getPrintName(cnTypes[i]) + ">", n);
            }
            ++i;
        }
    }

    private static String getPrintName(GenericsType gt) {
        String ret = gt.getName();
        ClassNode[] upperBounds = gt.getUpperBounds();
        ClassNode lowerBound = gt.getLowerBound();
        if (upperBounds != null) {
            ret = String.valueOf(ret) + " extends ";
            int i = 0;
            while (i < upperBounds.length) {
                ret = String.valueOf(ret) + GenericsVisitor.getPrintName(upperBounds[i]);
                if (i + 1 < upperBounds.length) {
                    ret = String.valueOf(ret) + " & ";
                }
                ++i;
            }
        } else if (lowerBound != null) {
            ret = String.valueOf(ret) + " super " + GenericsVisitor.getPrintName(lowerBound);
        }
        return ret;
    }

    private static String getPrintName(ClassNode cn) {
        String ret = cn.getName();
        GenericsType[] gts = cn.getGenericsTypes();
        if (gts != null) {
            ret = String.valueOf(ret) + "<";
            int i = 0;
            while (i < gts.length) {
                if (i != 0) {
                    ret = String.valueOf(ret) + ",";
                }
                ret = String.valueOf(ret) + GenericsVisitor.getPrintName(gts[i]);
                ++i;
            }
            ret = String.valueOf(ret) + ">";
        }
        return ret;
    }
}

