/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.nd.java.model;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.core.nd.db.IndexException;
import org.eclipse.jdt.internal.core.nd.indexer.Indexer;
import org.eclipse.jdt.internal.core.nd.java.JavaIndex;
import org.eclipse.jdt.internal.core.nd.java.JavaNames;
import org.eclipse.jdt.internal.core.nd.java.TypeRef;
import org.eclipse.jdt.internal.core.nd.java.model.BinaryTypeDescriptor;
import org.eclipse.jdt.internal.core.nd.java.model.IndexBinaryType;
import org.eclipse.jdt.internal.core.nd.java.model.Package;
import org.eclipse.jdt.internal.core.nd.util.CharArrayUtils;

public class BinaryTypeFactory {
    private static BinaryTypeDescriptor createDescriptor(PackageFragment pkg, ClassFile classFile) {
        String indexPath;
        String name = classFile.getName();
        PackageFragmentRoot root = (PackageFragmentRoot)pkg.getParent();
        IPath location = JavaIndex.getLocationForElement(root);
        if (location == null) {
            return null;
        }
        name = root.getClassFilePath(org.eclipse.jdt.internal.core.util.Util.concatWith(pkg.names, name, '/'));
        String entryName = org.eclipse.jdt.internal.core.util.Util.concatWith(pkg.names, classFile.getElementName(), '/');
        char[] fieldDescriptor = CharArrayUtils.concat(new char[]{'L'}, name.toCharArray(), new char[]{';'});
        IPath workspacePath = root.getPath();
        if (root instanceof JarPackageFragmentRoot) {
            entryName = ((JarPackageFragmentRoot)root).getClassFilePath(entryName);
            indexPath = String.valueOf(root.getHandleIdentifier()) + '|' + entryName;
        } else {
            location = location.append(entryName);
            indexPath = workspacePath.append(entryName).toString();
            workspacePath = classFile.resource().getFullPath();
        }
        return new BinaryTypeDescriptor(location.toString().toCharArray(), fieldDescriptor, workspacePath.toString().toCharArray(), indexPath.toCharArray());
    }

    public static BinaryTypeDescriptor createDescriptor(IClassFile classFile) {
        ClassFile concreteClass = (ClassFile)classFile;
        PackageFragment parent = (PackageFragment)classFile.getParent();
        return BinaryTypeFactory.createDescriptor(parent, concreteClass);
    }

    public static BinaryTypeDescriptor createDescriptor(IType type) {
        return BinaryTypeFactory.createDescriptor(type.getClassFile());
    }

    public static IBinaryType create(IClassFile classFile, IProgressMonitor monitor) throws JavaModelException, ClassFormatException {
        BinaryTypeDescriptor descriptor = BinaryTypeFactory.createDescriptor(classFile);
        return BinaryTypeFactory.readType(descriptor, monitor);
    }

    public static IBinaryType readType(BinaryTypeDescriptor descriptor, IProgressMonitor monitor) throws JavaModelException, ClassFormatException {
        if (JavaIndex.isEnabled()) {
            try {
                return BinaryTypeFactory.readFromIndex(JavaIndex.getIndex(), descriptor, monitor);
            }
            catch (NotInIndexException notInIndexException) {
                // empty catch block
            }
        }
        return BinaryTypeFactory.rawReadType(descriptor, true);
    }

    public static ClassFileReader rawReadType(BinaryTypeDescriptor descriptor, boolean fullyInitialize) throws JavaModelException, ClassFormatException {
        try {
            return BinaryTypeFactory.rawReadTypeTestForExists(descriptor, fullyInitialize, true);
        }
        catch (FileNotFoundException e) {
            throw new JavaModelException(e, 985);
        }
    }

    public static ClassFileReader rawReadTypeTestForExists(BinaryTypeDescriptor descriptor, boolean fullyInitialize, boolean useInvalidArchiveCache) throws JavaModelException, ClassFormatException, FileNotFoundException {
        ZipFile zip;
        block21: {
            byte[] contents;
            if (descriptor == null) {
                return null;
            }
            if (descriptor.isInJarFile()) {
                zip = null;
                try {
                    byte[] contents2;
                    zip = JavaModelManager.getJavaModelManager().getZipFile(new Path(new String(descriptor.workspacePath)), useInvalidArchiveCache);
                    char[] entryNameCharArray = CharArrayUtils.concat(JavaNames.fieldDescriptorToBinaryName(descriptor.fieldDescriptor), SuffixConstants.SUFFIX_class);
                    String entryName = new String(entryNameCharArray);
                    ZipEntry ze22 = zip.getEntry(entryName);
                    if (ze22 == null) break block21;
                    try {
                        contents2 = Util.getZipEntryByteContent(ze22, zip);
                    }
                    catch (IOException ioe) {
                        throw new JavaModelException(ioe, 985);
                    }
                    ClassFileReader classFileReader = new ClassFileReader(contents2, descriptor.indexPath, fullyInitialize);
                    JavaModelManager.getJavaModelManager().closeZipFile(zip);
                    return classFileReader;
                }
                catch (CoreException e) {
                    try {
                        throw new JavaModelException(e);
                    }
                    catch (Throwable throwable) {
                        JavaModelManager.getJavaModelManager().closeZipFile(zip);
                        throw throwable;
                    }
                }
            }
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(new Path(new String(descriptor.workspacePath)));
            try {
                Throwable entryName = null;
                Object ze22 = null;
                try (InputStream stream = file.getContents(true);){
                    contents = Util.getInputStreamAsByteArray(stream, -1);
                }
                catch (Throwable ze22) {
                    if (entryName == null) {
                        entryName = ze22;
                    } else if (entryName != ze22) {
                        entryName.addSuppressed(ze22);
                    }
                    throw entryName;
                }
            }
            catch (CoreException e) {
                IStatus status = e.getStatus();
                if (status.getCode() == 368) {
                    throw new FileNotFoundException();
                }
                throw new JavaModelException(e);
            }
            catch (IOException e) {
                throw new JavaModelException(e, 985);
            }
            return new ClassFileReader(contents, file.getFullPath().toString().toCharArray(), fullyInitialize);
        }
        JavaModelManager.getJavaModelManager().closeZipFile(zip);
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IBinaryType readFromIndex(JavaIndex index, BinaryTypeDescriptor descriptor, IProgressMonitor monitor) throws JavaModelException, NotInIndexException {
        fieldDescriptor = descriptor.fieldDescriptor;
        nd = index.getNd();
        if (descriptor.location == null) throw new NotInIndexException();
        try {
            var5_5 = null;
            var6_8 = null;
            try {
                lock = nd.acquireReadLock();
                try {
                    typeRef = TypeRef.create(nd, descriptor.location, fieldDescriptor);
                    type = typeRef.get();
                    if (type != null) ** GOTO lbl18
                    resourceFile = index.getResourceFile(descriptor.location);
                    if (index.isUpToDate(resourceFile)) {
                        return null;
                    }
                    throw new NotInIndexException();
lbl18:
                    // 1 sources

                    resourceFile = type.getResourceFile();
                    if (!index.isUpToDate(resourceFile)) throw new NotInIndexException();
                    result = new IndexBinaryType(typeRef, descriptor.indexPath);
                    result.initSimpleAttributes();
                    v0 = result;
                    return v0;
                }
                catch (CoreException e) {
                    throw new JavaModelException(e);
                }
                finally {
                    if (lock == null) return null;
                    lock.close();
                }
            }
            catch (Throwable var6_9) {
                if (var5_5 == null) {
                    var5_5 = var6_9;
                    throw var5_5;
                }
                if (var5_5 == var6_9) throw var5_5;
                var5_5.addSuppressed(var6_9);
                throw var5_5;
            }
        }
        catch (IndexException e) {
            Package.log("Index corruption detected. Rebuilding index.", e);
            Indexer.getInstance().requestRebuildIndex();
        }
        throw new NotInIndexException();
    }

    public static final class NotInIndexException
    extends Exception {
        private static final long serialVersionUID = 2859848007651528256L;
    }
}

