/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.internal.compiler.ast;

import groovy.lang.GroovyRuntimeException;
import groovy.transform.PackageScopeTarget;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.CodeVisitorSupport;
import org.codehaus.groovy.ast.Comment;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.PackageNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.TaskEntry;
import org.codehaus.groovy.ast.expr.AnnotationConstantExpression;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MethodCall;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.control.ErrorCollector;
import org.codehaus.groovy.control.Janitor;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.io.ReaderSource;
import org.codehaus.groovy.control.messages.ExceptionMessage;
import org.codehaus.groovy.control.messages.LocatedMessage;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SimpleMessage;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.control.messages.WarningMessage;
import org.codehaus.groovy.eclipse.GroovyLogManager;
import org.codehaus.groovy.eclipse.TraceCategory;
import org.codehaus.groovy.syntax.CSTNode;
import org.codehaus.groovy.syntax.PreciseSyntaxException;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.tools.GroovyClass;
import org.codehaus.jdt.groovy.control.EclipseSourceUnit;
import org.codehaus.jdt.groovy.core.dom.GroovyCompilationUnit;
import org.codehaus.jdt.groovy.internal.compiler.ast.AliasImportReference;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyClassFile;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyCompilationUnitScope;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyEclipseBug;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyTypeDeclaration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.groovy.core.util.ArrayUtils;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.AnnotationMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.CharLiteral;
import org.eclipse.jdt.internal.compiler.ast.ClassLiteralAccess;
import org.eclipse.jdt.internal.compiler.ast.Clinit;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.DoubleLiteral;
import org.eclipse.jdt.internal.compiler.ast.FalseLiteral;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FloatLiteral;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.Initializer;
import org.eclipse.jdt.internal.compiler.ast.IntLiteral;
import org.eclipse.jdt.internal.compiler.ast.Javadoc;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.LongLiteral;
import org.eclipse.jdt.internal.compiler.ast.MarkerAnnotation;
import org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.NormalAnnotation;
import org.eclipse.jdt.internal.compiler.ast.NullLiteral;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedSingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.SingleMemberAnnotation;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.StringLiteral;
import org.eclipse.jdt.internal.compiler.ast.TrueLiteral;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.ast.UnaryExpression;
import org.eclipse.jdt.internal.compiler.ast.Wildcard;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObjectToInt;
import org.eclipse.jdt.internal.core.util.Util;

public class GroovyCompilationUnitDeclaration
extends CompilationUnitDeclaration {
    private static final boolean DEBUG_CODE_GENERATION = Boolean.parseBoolean(Platform.getDebugOption("org.codehaus.groovy.eclipse.core/debug/codegen"));
    private static final boolean DEBUG_TASK_TAGS = Boolean.parseBoolean(Platform.getDebugOption("org.codehaus.groovy.eclipse.core/debug/tasktags"));
    public static boolean defaultCheckGenerics = Boolean.parseBoolean(Platform.getDebugOption("org.codehaus.groovy.eclipse.core/debug/generics"));
    private final org.codehaus.groovy.control.CompilationUnit compilationUnit;
    private final CompilerOptions compilerOptions;
    private final SourceUnit groovySourceUnit;
    private final TraitHelper traitHelper = new TraitHelper();
    private boolean isScript;

    public GroovyCompilationUnitDeclaration(ProblemReporter problemReporter, CompilationResult compilationResult, int sourceLength, org.codehaus.groovy.control.CompilationUnit compilationUnit, SourceUnit groovySourceUnit, CompilerOptions compilerOptions) {
        super(problemReporter, compilationResult, sourceLength);
        this.compilationUnit = compilationUnit;
        this.groovySourceUnit = groovySourceUnit;
        this.compilerOptions = compilerOptions;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean processToPhase(int phase) {
        if (phase == 5 && this.groovySourceUnit instanceof EclipseSourceUnit) {
            IFile iFile = ((EclipseSourceUnit)this.groovySourceUnit).getEclipseFile();
        }
        boolean alreadyHasErrors = this.compilationResult.hasErrors();
        ReferenceContext referenceContext = this.problemReporter.referenceContext;
        try {
            this.problemReporter.referenceContext = this;
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.compilationUnit.getTransformLoader());
                this.compilationUnit.compile(phase);
            }
            finally {
                Thread.currentThread().setContextClassLoader(cl);
            }
            ErrorCollector collector = this.groovySourceUnit.getErrorCollector();
            if (collector.hasErrors() || collector.hasWarnings()) {
                this.recordProblems(collector.getErrors(), collector.getWarnings());
            }
            if (collector.hasErrors()) return false;
            return true;
        }
        catch (MultipleCompilationErrorsException e) {
            Exception cause;
            ErrorCollector collector;
            if (GroovyLogManager.manager.hasLoggers()) {
                GroovyLogManager.manager.log(TraceCategory.COMPILER, e.getMessage());
            }
            if ((collector = e.getErrorCollector()).getErrorCount() == 1 && collector.getError(0) instanceof ExceptionMessage && (cause = ((ExceptionMessage)collector.getError(0)).getCause()) instanceof AbortCompilation) {
                throw (AbortCompilation)cause;
            }
            this.recordProblems(collector.getErrors(), collector.getWarnings());
            return false;
        }
        catch (GroovyBugError e) {
            if (GroovyLogManager.manager.hasLoggers()) {
                GroovyLogManager.manager.log(TraceCategory.COMPILER, e.getBugText());
            }
            if (e.getCause() instanceof AbortCompilation) {
                AbortCompilation abort = (AbortCompilation)e.getCause();
                if (abort.isSilent) return false;
                if (abort.problem == null) throw abort;
                this.problemReporter.record(abort.problem, this.compilationResult, this, true);
                return false;
            } else {
                if (alreadyHasErrors) return false;
                Util.log(new Status(4, "org.eclipse.jdt.groovy.core", "Groovy compiler error", (Throwable)((Object)e)));
                ErrorCollector collector = this.groovySourceUnit.getErrorCollector();
                collector.addError(new SyntaxErrorMessage(new SyntaxException(" compiler error: " + e.getBugText(), (Throwable)((Object)e), 1, 1), this.groovySourceUnit));
                this.recordProblems(collector.getErrors(), collector.getWarnings());
            }
            return false;
        }
        catch (AssertionError | LinkageError e) {
            if (GroovyLogManager.manager.hasLoggers()) {
                GroovyLogManager.manager.log(TraceCategory.COMPILER, ((Throwable)e).getMessage());
            }
            if (!alreadyHasErrors) {
                Util.log(new Status(4, "org.eclipse.jdt.groovy.core", "Groovy compiler error", (Throwable)e));
            }
            ErrorCollector collector = this.groovySourceUnit.getErrorCollector();
            collector.addError(new SyntaxErrorMessage(new SyntaxException(" compiler error: " + ((Throwable)e).getMessage(), (Throwable)e, 1, 1), this.groovySourceUnit));
            this.recordProblems(collector.getErrors(), collector.getWarnings());
            return false;
        }
        finally {
            this.problemReporter.referenceContext = referenceContext;
        }
    }

    public org.codehaus.groovy.control.CompilationUnit getCompilationUnit() {
        return this.compilationUnit;
    }

    public void populateCompilationUnitDeclaration() {
        UnitPopulator populator = new UnitPopulator();
        populator.populate(this);
    }

    @Override
    public void generateCode() {
        block13: {
            block12: {
                boolean successful = this.processToPhase(9);
                if (!successful) break block12;
                List classes = this.compilationUnit.getClasses();
                if (DEBUG_CODE_GENERATION) {
                    System.out.println("Processing sourceUnit " + this.groovySourceUnit.getName());
                }
                for (GroovyClass groovyClass : classes) {
                    ClassNode classNode = groovyClass.getClassNode();
                    if (DEBUG_CODE_GENERATION) {
                        System.out.println("Looking at class " + groovyClass.getName());
                        System.out.println("ClassNode where it came from " + classNode);
                    }
                    if (groovyClass.getSourceUnit() != this.groovySourceUnit) continue;
                    if (DEBUG_CODE_GENERATION) {
                        System.out.println("It is from this source unit");
                    }
                    SourceTypeBinding binding = null;
                    if (this.types != null && this.types.length != 0) {
                        binding = GroovyCompilationUnitDeclaration.findBinding(this.types, groovyClass.getClassNode());
                    }
                    if (DEBUG_CODE_GENERATION) {
                        System.out.println("Binding located? " + (binding != null));
                    }
                    if (binding == null) {
                        ClassNode current = classNode;
                        while ((current = current.getOuterClass()) != null && binding == null) {
                            binding = GroovyCompilationUnitDeclaration.findBinding(this.types, current);
                            if (!DEBUG_CODE_GENERATION) continue;
                            System.out.println("Had another look within enclosing class; found binding? " + (binding != null));
                        }
                    }
                    boolean isScript = false;
                    if (binding != null && binding.scope != null && binding.scope.parent instanceof GroovyCompilationUnitScope) {
                        GroovyCompilationUnitScope gcuScope = (GroovyCompilationUnitScope)binding.scope.parent;
                        isScript = gcuScope.isScript();
                    }
                    if (isScript) continue;
                    GroovyClassFile groovyClassFile = new GroovyClassFile(groovyClass.getName(), groovyClass.getBytes(), binding, groovyClass.getName().replace('.', '/'));
                    if (binding == null) {
                        Map compiledTypes = (Map)Map.class.cast(this.compilationResult.compiledTypes);
                        compiledTypes.put(groovyClass.getName().toCharArray(), groovyClassFile);
                        continue;
                    }
                    this.compilationResult.record(groovyClass.getName().toCharArray(), groovyClassFile);
                }
                break block13;
            }
            if (this.isScript || this.types == null || this.types.length <= 0) break block13;
            TypeDeclaration[] typeDeclarationArray = this.types;
            int n = this.types.length;
            int n2 = 0;
            while (n2 < n) {
                TypeDeclaration type = typeDeclarationArray[n2];
                if (type.binding != null) {
                    ClassFile.createProblemType(type, this.compilationResult);
                }
                ++n2;
            }
        }
    }

    private static SourceTypeBinding findBinding(TypeDeclaration[] typedeclarations, ClassNode cnode) {
        TypeDeclaration[] typeDeclarationArray = typedeclarations;
        int n = typedeclarations.length;
        int n2 = 0;
        while (n2 < n) {
            SourceTypeBinding binding;
            TypeDeclaration typedeclaration = typeDeclarationArray[n2];
            GroovyTypeDeclaration groovyTypeDeclaration = (GroovyTypeDeclaration)typedeclaration;
            if (groovyTypeDeclaration.getClassNode().equals(cnode)) {
                return groovyTypeDeclaration.binding;
            }
            if (typedeclaration.memberTypes != null && (binding = GroovyCompilationUnitDeclaration.findBinding(typedeclaration.memberTypes, cnode)) != null) {
                return binding;
            }
            ++n2;
        }
        return null;
    }

    private static int getLine(int[] lineSeparatorPositions, int offset) {
        int line = 0;
        while (line < lineSeparatorPositions.length && lineSeparatorPositions[line] < offset) {
            ++line;
        }
        return ++line;
    }

    private static int getOffset(int[] lineSeparatorPositions, int line, int column) {
        if (column < 1) {
            column = 1;
        }
        if (lineSeparatorPositions.length > line - 2 && line > 1) {
            return lineSeparatorPositions[line - 2] + column;
        }
        return column - 1;
    }

    private static String prepareMessage(String message) {
        int i = 0;
        while (i < message.length() && Character.isWhitespace(message.charAt(i))) {
            ++i;
        }
        message = "Groovy:" + (i < 1 ? "" : " ") + message.substring(i).split("\n| (?:@|at) line\\b")[0];
        if (message.endsWith(" Possible causes:")) {
            message = message.substring(0, message.length() - 17);
        }
        return message;
    }

    private void recordProblems(List<? extends Message> errors, List<WarningMessage> warnings) {
        if (errors == null) {
            errors = Collections.emptyList();
        }
        if (warnings == null) {
            warnings = Collections.emptyList();
        }
        List accepted = Stream.concat(errors.stream(), warnings.stream()).filter(message -> {
            if (message instanceof SyntaxErrorMessage) {
                Object source = ReflectionUtils.getPrivateField(SyntaxErrorMessage.class, "source", message);
                if (source != null && source != this.groovySourceUnit) {
                    return false;
                }
            } else if (message instanceof SimpleMessage) {
                Object owner = ReflectionUtils.getPrivateField(SimpleMessage.class, "owner", message);
                if (owner != null && owner != this.compilationUnit && owner != this.groovySourceUnit) {
                    return false;
                }
            } else if (message instanceof ExceptionMessage) {
                GroovyRuntimeException gre;
                Object owner = ReflectionUtils.getPrivateField(ExceptionMessage.class, "owner", message);
                if (owner != null && owner != this.compilationUnit && owner != this.groovySourceUnit) {
                    return false;
                }
                if (((ExceptionMessage)message).getCause() instanceof GroovyRuntimeException && (gre = (GroovyRuntimeException)((ExceptionMessage)message).getCause()).getModule() != null && !gre.getModule().equals(this.getModuleNode())) {
                    return false;
                }
            }
            return true;
        }).collect(Collectors.toList());
        errors.removeAll(accepted);
        warnings.removeAll(accepted);
        for (Message message2 : accepted) {
            String description = null;
            int soffset = -1;
            int eoffset = -1;
            int line = 0;
            int scol = 0;
            int ecol = 0;
            if (message2 instanceof SyntaxErrorMessage) {
                SyntaxErrorMessage errorMessage = (SyntaxErrorMessage)message2;
                SyntaxException syntaxException = errorMessage.getCause();
                description = syntaxException.getMessage();
                line = syntaxException.getLine();
                scol = syntaxException.getStartColumn();
                ecol = syntaxException.getEndColumn() - 1;
                if (syntaxException instanceof PreciseSyntaxException) {
                    soffset = ((PreciseSyntaxException)syntaxException).getStartOffset();
                    eoffset = ((PreciseSyntaxException)syntaxException).getEndOffset();
                    line = GroovyCompilationUnitDeclaration.getLine(this.compilationResult.lineSeparatorPositions, soffset);
                }
            } else if (message2 instanceof SimpleMessage) {
                CSTNode context;
                SimpleMessage simpleMessage = (SimpleMessage)message2;
                description = simpleMessage.getMessage();
                if (message2 instanceof LocatedMessage && (context = ((LocatedMessage)message2).getContext()) != null) {
                    line = context.getStartLine();
                    scol = context.getStartColumn();
                    if (context instanceof Token) {
                        String text = ((Token)context).getText();
                        ecol = scol + (text == null ? 1 : text.length() - 1);
                    }
                }
            } else if (message2 instanceof ExceptionMessage && ((ExceptionMessage)message2).getCause() instanceof GroovyRuntimeException) {
                GroovyRuntimeException gre = (GroovyRuntimeException)((ExceptionMessage)message2).getCause();
                description = gre.getMessage();
                if (gre.getNode() != null) {
                    soffset = gre.getNode().getStart();
                    eoffset = gre.getNode().getEnd() - 1;
                    line = GroovyCompilationUnitDeclaration.getLine(this.compilationResult.lineSeparatorPositions, soffset);
                }
            }
            if (description == null) {
                StringWriter writer = new StringWriter();
                message2.write(new PrintWriter(writer));
                description = writer.toString();
            }
            String[] problemArguments = new String[]{GroovyCompilationUnitDeclaration.prepareMessage(description)};
            if (soffset == -1) {
                soffset = GroovyCompilationUnitDeclaration.getOffset(this.compilationResult.lineSeparatorPositions, line, scol);
            }
            if (eoffset == -1) {
                eoffset = GroovyCompilationUnitDeclaration.getOffset(this.compilationResult.lineSeparatorPositions, line, ecol);
            }
            if (soffset > eoffset) {
                eoffset = soffset;
            }
            if (soffset > this.sourceEnd) {
                soffset = this.sourceEnd;
                eoffset = this.sourceEnd;
            }
            CategorizedProblem problem = new DefaultProblemFactory().createProblem(this.getFileName(), 0, problemArguments, 0, problemArguments, message2 instanceof WarningMessage ? 0 : 1, soffset, eoffset, line, scol);
            this.problemReporter.record(problem, this.compilationResult, this, false);
        }
    }

    @Override
    public void finalizeProblems() {
        CategorizedProblem[] problems;
        boolean isReconcile;
        boolean bl = isReconcile = this.compilationUnit.allowTransforms && !this.compilerOptions.parseLiteralExpressionsAsConstants;
        if (this.isScript && !isReconcile && this.groovySourceUnit instanceof EclipseSourceUnit && ((EclipseSourceUnit)this.groovySourceUnit).getEclipseFile() != null && (problems = this.compilationResult.problems) != null && problems.length > 0) {
            CategorizedProblem[] categorizedProblemArray = problems;
            int n = problems.length;
            int n2 = 0;
            while (n2 < n) {
                CategorizedProblem problem = categorizedProblemArray[n2];
                if (problem != null && CharOperation.equals(problem.getOriginatingFileName(), ((EclipseSourceUnit)this.groovySourceUnit).getEclipseFile().getFullPath().toString().toCharArray())) {
                    this.compilationResult.removeProblem(problem);
                }
                ++n2;
            }
        }
        super.finalizeProblems();
    }

    @Override
    public CompilationUnitScope buildCompilationUnitScope(LookupEnvironment lookupEnvironment) {
        GroovyCompilationUnitScope gcus = new GroovyCompilationUnitScope(this, lookupEnvironment);
        gcus.setIsScript(this.isScript);
        return gcus;
    }

    public ModuleNode getModuleNode() {
        return Optional.ofNullable(this.getSourceUnit()).map(SourceUnit::getAST).orElse(null);
    }

    public SourceUnit getSourceUnit() {
        return this.groovySourceUnit;
    }

    @Override
    public CompilationUnit getSpecialDomCompilationUnit(AST ast) {
        return new GroovyCompilationUnit(ast);
    }

    public String print() {
        return this.toString();
    }

    @Override
    public void resolve() {
        this.processToPhase(4);
        this.checkForTags();
        this.setComments();
    }

    private void checkForTags() {
        if (this.compilerOptions == null) {
            return;
        }
        List<Comment> comments = this.groovySourceUnit.getComments();
        if (comments == null || comments.isEmpty()) {
            return;
        }
        char[][] taskTags = this.compilerOptions.taskTags;
        char[][] taskPriorities = this.compilerOptions.taskPriorities;
        boolean caseSensitiveTags = this.compilerOptions.isTaskCaseSensitive;
        try {
            if (taskTags != null) {
                for (Comment comment : comments) {
                    ArrayList<TaskEntry> allTasksInComment = new ArrayList<TaskEntry>();
                    int t = 0;
                    while (t < taskTags.length) {
                        String taskTag = String.valueOf(taskTags[t]);
                        String taskPriority = null;
                        if (taskPriorities != null) {
                            taskPriority = String.valueOf(taskPriorities[t]);
                        }
                        allTasksInComment.addAll(comment.getPositionsOf(taskTag, taskPriority, this.compilationResult.lineSeparatorPositions, caseSensitiveTags));
                        ++t;
                    }
                    if (allTasksInComment.isEmpty()) continue;
                    int t1 = 0;
                    while (t1 < allTasksInComment.size()) {
                        int t2 = 0;
                        while (t2 < allTasksInComment.size()) {
                            if (t1 != t2) {
                                TaskEntry taskOne = (TaskEntry)allTasksInComment.get(t1);
                                TaskEntry taskTwo = (TaskEntry)allTasksInComment.get(t2);
                                if (DEBUG_TASK_TAGS) {
                                    System.out.println("Comparing " + taskOne.toString() + " and " + taskTwo.toString());
                                }
                                if (taskOne.start + taskOne.taskTag.length() + 1 == taskTwo.start) {
                                    taskOne.isAdjacentTo = taskTwo;
                                } else if (taskOne.getEnd() > taskTwo.start && taskOne.start < taskTwo.start) {
                                    taskOne.setEnd(taskTwo.start - 1);
                                    if (DEBUG_TASK_TAGS) {
                                        System.out.println("trim " + taskOne.toString() + " and " + taskTwo.toString());
                                    }
                                } else if (taskTwo.getEnd() > taskOne.start && taskTwo.start < taskOne.start) {
                                    taskTwo.setEnd(taskOne.start - 1);
                                    if (DEBUG_TASK_TAGS) {
                                        System.out.println("trim " + taskOne.toString() + " and " + taskTwo.toString());
                                    }
                                }
                            }
                            ++t2;
                        }
                        ++t1;
                    }
                    for (TaskEntry taskEntry : allTasksInComment) {
                        this.problemReporter.referenceContext = this;
                        if (DEBUG_TASK_TAGS) {
                            System.out.println("Adding task " + taskEntry.toString());
                        }
                        this.problemReporter.task(taskEntry.taskTag, taskEntry.getText(), taskEntry.taskPriority, taskEntry.start, taskEntry.getEnd());
                    }
                }
            }
        }
        catch (AbortCompilation comment) {
        }
        catch (Throwable t) {
            Util.log(t, "Unexpected problem processing task tags in " + this.groovySourceUnit.getName());
            new RuntimeException("Unexpected problem processing task tags in " + this.groovySourceUnit.getName(), t).printStackTrace();
        }
    }

    private void setComments() {
        List<Comment> groovyComments = this.groovySourceUnit.getComments();
        if (groovyComments != null && !groovyComments.isEmpty()) {
            this.comments = (int[][])groovyComments.stream().map(groovyComment -> groovyComment.getPositions(this.compilationResult.lineSeparatorPositions)).toArray(n -> new int[n][]);
        }
    }

    @Override
    public void analyseCode() {
        this.processToPhase(5);
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        if (this.groovySourceUnit instanceof EclipseSourceUnit) {
            ((EclipseSourceUnit)this.groovySourceUnit).resolver.cleanUp();
        }
    }

    public void tagAsScript() {
        this.isScript = true;
    }

    public static class FieldDeclarationWithInitializer
    extends FieldDeclaration {
        private Expression initializer;

        public FieldDeclarationWithInitializer(char[] name, int sourceStart, int sourceEnd) {
            super(name, sourceStart, sourceEnd);
        }

        public Expression getGroovyInitializer() {
            return this.initializer;
        }
    }

    private class TraitHelper {
        private boolean lookForTraitAlias;
        private boolean toBeInitialized = true;

        private TraitHelper() {
        }

        private void initialize() {
            if (GroovyCompilationUnitDeclaration.this.imports != null) {
                ImportReference[] importReferenceArray = GroovyCompilationUnitDeclaration.this.imports;
                int n = GroovyCompilationUnitDeclaration.this.imports.length;
                int n2 = 0;
                while (n2 < n) {
                    ImportReference i = importReferenceArray[n2];
                    String importedType = i.toString();
                    if ("groovy.transform.Trait".equals(importedType)) {
                        this.lookForTraitAlias = true;
                        break;
                    }
                    if (importedType.endsWith(".Trait")) {
                        this.lookForTraitAlias = false;
                        break;
                    }
                    if ("groovy.transform.*".equals(importedType)) {
                        this.lookForTraitAlias = true;
                    }
                    ++n2;
                }
                this.toBeInitialized = true;
            }
        }

        private boolean isTrait(ClassNode classNode) {
            List<AnnotationNode> annotations;
            if (classNode == null) {
                return false;
            }
            if (this.toBeInitialized) {
                this.initialize();
            }
            if (!(annotations = classNode.getAnnotations()).isEmpty()) {
                for (AnnotationNode annotation : annotations) {
                    if ("groovy.transform.Trait".equals(annotation.getClassNode().getName())) {
                        return true;
                    }
                    if (!this.lookForTraitAlias || !"Trait".equals(annotation.getClassNode().getName())) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public static class UnitPopulator {
        private Janitor janitor;
        private SourceUnit sourceUnit;
        private GroovyCompilationUnitDeclaration unitDeclaration;
        private Map<ClassNode, Object> anonymousLocations;
        private boolean checkGenerics = defaultCheckGenerics;
        private static final char[] DOLLAR_SLASHY = "$/".toCharArray();
        private static final char[] TRIPLE_QUOTE1 = "'''".toCharArray();
        private static final char[] TRIPLE_QUOTE2 = "\"\"\"".toCharArray();
        private static final Pattern AND = Pattern.compile("^\\s*&\\s*");
        private static final Pattern EXTENDS = Pattern.compile("^\\s*extends\\s+");
        private static final Map<Character, Integer> charToTypeId = new HashMap<Character, Integer>();
        private static final Map<String, Integer> nameToPrimitiveTypeId = new HashMap<String, Integer>();
        private static final NumberFormat Prefix;
        private static long NON_EXISTENT_POSITION;

        static {
            charToTypeId.put(Character.valueOf('D'), 8);
            charToTypeId.put(Character.valueOf('I'), 10);
            charToTypeId.put(Character.valueOf('F'), 9);
            charToTypeId.put(Character.valueOf('J'), 7);
            charToTypeId.put(Character.valueOf('Z'), 5);
            charToTypeId.put(Character.valueOf('B'), 3);
            charToTypeId.put(Character.valueOf('C'), 2);
            charToTypeId.put(Character.valueOf('S'), 4);
            nameToPrimitiveTypeId.put("double", 8);
            nameToPrimitiveTypeId.put("int", 10);
            nameToPrimitiveTypeId.put("float", 9);
            nameToPrimitiveTypeId.put("long", 7);
            nameToPrimitiveTypeId.put("boolean", 5);
            nameToPrimitiveTypeId.put("byte", 3);
            nameToPrimitiveTypeId.put("char", 2);
            nameToPrimitiveTypeId.put("short", 4);
            nameToPrimitiveTypeId.put("void", 6);
            Prefix = NumberFormat.getInstance();
            Prefix.setMinimumIntegerDigits(5);
            Prefix.setGroupingUsed(false);
            NON_EXISTENT_POSITION = -2L;
        }

        void populate(GroovyCompilationUnitDeclaration unit) {
            this.sourceUnit = unit.getSourceUnit();
            this.unitDeclaration = unit;
            unit.sourceEnds = new HashtableOfObjectToInt();
            ModuleNode moduleNode = unit.getModuleNode();
            try {
                this.createPackageDeclaration(moduleNode);
                this.createImportDeclarations(moduleNode);
                this.createTypeDeclarations(moduleNode);
            }
            finally {
                if (this.janitor != null) {
                    this.janitor.cleanup();
                    this.janitor = null;
                }
            }
        }

        private void createPackageDeclaration(ModuleNode moduleNode) {
            if (moduleNode.hasPackageName()) {
                String packageName = moduleNode.getPackageName();
                if (packageName.endsWith(".")) {
                    packageName = packageName.substring(0, packageName.length() - 1);
                }
                PackageNode packageNode = moduleNode.getPackage();
                char[][] splits = CharOperation.splitOn('.', packageName.toCharArray());
                long[] positions = this.positionsFor(splits, this.startOffset(packageNode), this.endOffset(packageNode));
                ImportReference ref = new ImportReference(splits, positions, true, 0);
                ref.annotations = this.createAnnotations(packageNode.getAnnotations());
                ref.declarationEnd = ref.sourceEnd + this.trailerLength(packageNode);
                ref.declarationSourceStart = Math.max(0, ref.sourceStart - "package ".length());
                ref.declarationSourceEnd = ref.sourceEnd;
                this.unitDeclaration.currentPackage = ref;
            }
        }

        private void createImportDeclarations(ModuleNode moduleNode) {
            List<ImportNode> importNodes = moduleNode.getImports();
            List<ImportNode> importPackages = moduleNode.getStarImports();
            Map<String, ImportNode> importStatics = moduleNode.getStaticImports();
            Map<String, ImportNode> importStaticStars = moduleNode.getStaticStarImports();
            int importCount = importNodes.size() + importPackages.size() + importStatics.size() + importStaticStars.size();
            if (importCount > 0) {
                ImportReference ref;
                long[] positions;
                char[][] splits;
                int nameStartOffset;
                int nameEndOffset;
                int endOffset;
                TreeMap<String, ImportReference> importReferences = new TreeMap<String, ImportReference>();
                for (ImportNode importNode : importNodes) {
                    endOffset = this.endOffset(importNode);
                    nameEndOffset = -2;
                    nameStartOffset = -1;
                    if (endOffset > 0) {
                        nameEndOffset = importNode.getNameEnd() + 1;
                        nameStartOffset = importNode.getNameStart();
                        if (nameStartOffset < 1) continue;
                    }
                    splits = CharOperation.splitOn('.', importNode.getClassName().toCharArray());
                    if (importNode.getAlias() == null || importNode.getAlias().length() < 1 || importNode.getAlias().equals(String.valueOf(splits[splits.length - 1]))) {
                        endOffset = nameEndOffset;
                        positions = this.positionsFor(splits, nameStartOffset, endOffset);
                        ref = new ImportReference(splits, positions, false, 0);
                    } else {
                        positions = this.positionsFor(splits, nameStartOffset, endOffset);
                        ref = new AliasImportReference(importNode.getAlias().toCharArray(), splits, positions, false, 0);
                    }
                    ref.annotations = this.createAnnotations(importNode.getAnnotations());
                    ref.sourceEnd = Math.max(endOffset - 1, ref.sourceStart);
                    if (ref.sourceEnd < 0) {
                        ref.declarationSourceStart = -1;
                        ref.declarationSourceEnd = -2;
                        ref.declarationEnd = -2;
                        ref.sourceEnd = -2;
                    } else {
                        ref.declarationEnd = ref.sourceEnd + this.trailerLength(importNode);
                        ref.declarationSourceStart = this.startOffset(importNode);
                        ref.declarationSourceEnd = ref.sourceEnd;
                    }
                    importReferences.put(UnitPopulator.lexicalKey(ref), ref);
                }
                for (ImportNode importNode : importPackages) {
                    endOffset = this.endOffset(importNode);
                    nameEndOffset = -2;
                    nameStartOffset = -1;
                    if (endOffset > 0) {
                        nameEndOffset = importNode.getNameEnd() + 1;
                        nameStartOffset = importNode.getNameStart();
                    }
                    splits = CharOperation.splitOn('.', importNode.getPackageName().substring(0, importNode.getPackageName().length() - 1).toCharArray());
                    ref = new ImportReference(splits, this.positionsFor(splits, nameStartOffset, nameEndOffset), true, 0);
                    ref.annotations = this.createAnnotations(importNode.getAnnotations());
                    ref.sourceEnd = Math.max(endOffset - 1, ref.sourceStart);
                    if (ref.sourceEnd < 0) {
                        ref.declarationSourceStart = -1;
                        ref.declarationSourceEnd = -2;
                        ref.declarationEnd = -2;
                        ref.sourceEnd = -2;
                    } else {
                        ref.declarationEnd = ref.sourceEnd + this.trailerLength(importNode);
                        ref.declarationSourceStart = importNode.getStart();
                        ref.declarationSourceEnd = ref.sourceEnd;
                    }
                    importReferences.put(UnitPopulator.lexicalKey(ref), ref);
                }
                for (Map.Entry entry : importStatics.entrySet()) {
                    AliasImportReference ref2;
                    ImportNode importNode = (ImportNode)entry.getValue();
                    int endOffset2 = this.endOffset(importNode);
                    int nameEndOffset2 = -2;
                    int nameStartOffset2 = -1;
                    if (endOffset2 > 0) {
                        nameEndOffset2 = importNode.getNameEnd() + 1;
                        nameStartOffset2 = importNode.getNameStart();
                    }
                    char[][] splits2 = CharOperation.splitOn('.', (String.valueOf(importNode.getClassName()) + '.' + importNode.getFieldName()).toCharArray());
                    positions = this.positionsFor(splits2, nameStartOffset2, nameEndOffset2);
                    if (importNode.getAlias() == null || importNode.getAlias().length() < 1 || importNode.getAlias().equals(importNode.getFieldName())) {
                        ImportReference ref22 = new ImportReference(splits2, positions, false, 8);
                    } else {
                        ref2 = new AliasImportReference(importNode.getAlias().toCharArray(), splits2, positions, false, 8);
                    }
                    ref2.annotations = this.createAnnotations(importNode.getAnnotations());
                    ref2.sourceEnd = Math.max(endOffset2 - 1, ref2.sourceStart);
                    if (ref2.sourceEnd < 0) {
                        ref2.declarationSourceStart = -1;
                        ref2.declarationSourceEnd = -2;
                        ref2.declarationEnd = -2;
                        ref2.sourceEnd = -2;
                    } else {
                        ref2.declarationEnd = ref2.sourceEnd + this.trailerLength(importNode);
                        ref2.declarationSourceStart = this.startOffset(importNode);
                        ref2.declarationSourceEnd = ref2.sourceEnd;
                    }
                    importReferences.put(UnitPopulator.lexicalKey(ref2), ref2);
                }
                for (Map.Entry entry : importStaticStars.entrySet()) {
                    String classname = (String)entry.getKey();
                    ImportNode importNode = (ImportNode)entry.getValue();
                    int endOffset3 = this.endOffset(importNode);
                    int nameEndOffset3 = -2;
                    int nameStartOffset3 = -1;
                    if (endOffset3 > 0) {
                        nameEndOffset3 = importNode.getNameEnd() + 1;
                        nameStartOffset3 = importNode.getNameStart();
                    }
                    char[][] splits3 = CharOperation.splitOn('.', classname.toCharArray());
                    long[] positions2 = this.positionsFor(splits3, nameStartOffset3, nameEndOffset3);
                    ImportReference ref3 = new ImportReference(splits3, positions2, true, 8);
                    ref3.annotations = this.createAnnotations(importNode.getAnnotations());
                    ref3.sourceEnd = Math.max(endOffset3 - 1, ref3.sourceStart);
                    if (ref3.sourceEnd < 0) {
                        ref3.declarationSourceStart = -1;
                        ref3.declarationSourceEnd = -2;
                        ref3.declarationEnd = -2;
                        ref3.sourceEnd = -2;
                    } else {
                        ref3.declarationEnd = ref3.sourceEnd + this.trailerLength(importNode);
                        ref3.declarationSourceStart = importNode.getStart();
                        ref3.declarationSourceEnd = ref3.sourceEnd;
                    }
                    importReferences.put(UnitPopulator.lexicalKey(ref3), ref3);
                }
                if (!importReferences.isEmpty()) {
                    ImportReference[] importReferenceArray;
                    ImportReference[] importReferenceArray2 = importReferenceArray = importReferences.values().toArray(new ImportReference[0]);
                    int n = importReferenceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ImportReference ref4 = importReferenceArray2[n2];
                        if (ref4.declarationSourceStart > 0 && ref4.declarationEnd - ref4.declarationSourceStart + 1 < 0) {
                            throw new IllegalStateException(String.format("Import reference alongside class %s will trigger later failure: %s declSourceStart=%d declEnd=%d", moduleNode.getClasses().get(0), ref4.toString(), ref4.declarationSourceStart, ref4.declarationEnd));
                        }
                        ++n2;
                    }
                    this.unitDeclaration.imports = importReferenceArray;
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void createTypeDeclarations(ModuleNode moduleNode) {
            List<ClassNode> moduleClassNodes = moduleNode.getClasses();
            for (ClassNode classNode : moduleClassNodes) {
                if (!classNode.isPrimaryClassNode() || !GroovyUtils.isAnonymous(classNode)) continue;
                this.anonymousLocations = new HashMap<ClassNode, Object>();
                break;
            }
            ArrayList<GroovyTypeDeclaration> typeDeclarations = new ArrayList<GroovyTypeDeclaration>();
            HashMap<ClassNode, GroovyTypeDeclaration> fromClassNodeToDecl = new HashMap<ClassNode, GroovyTypeDeclaration>();
            char[] mainName = UnitPopulator.toMainName(this.unitDeclaration.compilationResult.getFileName());
            HashMap<ClassNode, List> innersToRecord = new HashMap<ClassNode, List>();
            for (ClassNode classNode : moduleClassNodes) {
                boolean isInner;
                if (!classNode.isPrimaryClassNode()) continue;
                GroovyTypeDeclaration typeDeclaration = new GroovyTypeDeclaration(this.unitDeclaration.compilationResult, classNode);
                typeDeclaration.annotations = this.createAnnotations(classNode.getAnnotations());
                if (classNode.getOuterClass() != null) {
                    isInner = true;
                } else {
                    isInner = false;
                    typeDeclaration.name = classNode.getNameWithoutPackage().toCharArray();
                    if (!CharOperation.equals(typeDeclaration.name, mainName)) {
                        typeDeclaration.bits |= 0x1000;
                    }
                }
                typeDeclaration.modifiers = this.getModifiers(classNode, isInner);
                this.fixupSourceLocationsForTypeDeclaration(typeDeclaration, classNode);
                GenericsType[] generics = classNode.getGenericsTypes();
                if (generics != null && generics.length > 0) {
                    typeDeclaration.typeParameters = this.createTypeParametersForGenerics(classNode.getGenericsTypes());
                }
                boolean isEnum = classNode.isEnum();
                this.configureSuperClass(typeDeclaration, classNode.getSuperClass(), isEnum, this.isTrait(classNode));
                this.configureSuperInterfaces(typeDeclaration, classNode);
                typeDeclaration.fields = this.createFieldDeclarations(classNode, isEnum);
                typeDeclaration.methods = this.createConstructorAndMethodDeclarations(classNode, isEnum, typeDeclaration);
                for (org.codehaus.groovy.ast.stmt.Statement statement : classNode.getObjectInitializerStatements()) {
                    if (statement.getEnd() <= 0) continue;
                    Initializer initializer = new Initializer(new Block(0), 0);
                    initializer.declarationSourceEnd = initializer.sourceEnd = statement.getEnd() - 1;
                    initializer.declarationSourceStart = initializer.sourceStart = statement.getStart();
                    typeDeclaration.fields = (FieldDeclaration[])ArrayUtils.add(typeDeclaration.fields, initializer);
                    if (this.anonymousLocations == null) continue;
                    statement.visit(new AnonInnerFinder(typeDeclaration.methods.length > 0 && typeDeclaration.methods[0].isConstructor() ? typeDeclaration.methods[0] : initializer));
                }
                if (isInner) {
                    InnerClassNode innerClassNode = (InnerClassNode)classNode;
                    ClassNode outerClassNode = innerClassNode.getOuterClass();
                    innersToRecord.computeIfAbsent(outerClassNode, x -> new ArrayList()).add(typeDeclaration);
                    if (innerClassNode.isAnonymous()) {
                        typeDeclaration.name = CharOperation.NO_CHAR;
                        typeDeclaration.bits |= 0x300;
                        QualifiedAllocationExpression allocation = new QualifiedAllocationExpression(typeDeclaration);
                        allocation.sourceStart = isEnum ? typeDeclaration.sourceStart : typeDeclaration.sourceStart - 4;
                        allocation.sourceEnd = typeDeclaration.bodyEnd;
                        if (!isEnum) {
                            allocation.type = typeDeclaration.superclass;
                        }
                    } else {
                        typeDeclaration.name = innerClassNode.getNameWithoutPackage().substring(outerClassNode.getNameWithoutPackage().length() + 1).toCharArray();
                    }
                } else {
                    typeDeclarations.add(typeDeclaration);
                }
                fromClassNodeToDecl.put(classNode, typeDeclaration);
                this.unitDeclaration.sourceEnds.put(typeDeclaration, typeDeclaration.sourceEnd);
            }
            for (Map.Entry entry : innersToRecord.entrySet()) {
                TypeDeclaration outerTypeDeclaration = (TypeDeclaration)fromClassNodeToDecl.get(entry.getKey());
                if (outerTypeDeclaration == null) {
                    throw new GroovyEclipseBug("Failed to find the type declaration for " + ((ClassNode)entry.getKey()).getText());
                }
                List memberTypes = (List)entry.getValue();
                Iterator iterator = memberTypes.iterator();
                while (iterator.hasNext()) {
                    GroovyTypeDeclaration innerTypeDeclaration = (GroovyTypeDeclaration)iterator.next();
                    if ((innerTypeDeclaration.bits & 0x200) == 0) continue;
                    iterator.remove();
                    Object location = this.anonymousLocations.get(innerTypeDeclaration.getClassNode());
                    if (location instanceof AbstractMethodDeclaration) {
                        AbstractMethodDeclaration methodDeclaration = (AbstractMethodDeclaration)location;
                        methodDeclaration.bits |= 2;
                        methodDeclaration.statements = (Statement[])ArrayUtils.add(methodDeclaration.statements != null ? methodDeclaration.statements : new Statement[]{}, innerTypeDeclaration.allocation);
                    } else if (location instanceof Initializer) {
                        Initializer initializer = (Initializer)location;
                        initializer.bits |= 2;
                        initializer.block.statements = (Statement[])ArrayUtils.add(initializer.block.statements != null ? initializer.block.statements : new Statement[]{}, innerTypeDeclaration.allocation);
                    } else {
                        if (!(location instanceof FieldDeclaration)) throw new GroovyEclipseBug("Enclosing scope not found for anon. inner class: " + innerTypeDeclaration.getClassNode().getName());
                        FieldDeclarationWithInitializer fieldDeclaration = (FieldDeclarationWithInitializer)location;
                        fieldDeclaration.bits |= 2;
                        if (innerTypeDeclaration.getClassNode().isEnum()) {
                            innerTypeDeclaration.allocation.enumConstant = fieldDeclaration;
                            fieldDeclaration.initialization = innerTypeDeclaration.allocation;
                        } else {
                            if (fieldDeclaration.initialization != null) throw new GroovyEclipseBug("Can't handle more than one anon. inner class in field initializer");
                            if (CharOperation.equals(fieldDeclaration.type.getLastToken(), TypeConstants.OBJECT) || GroovyUtils.isAnonymous(fieldDeclaration.initializer.getType())) {
                                fieldDeclaration.initialization = innerTypeDeclaration.allocation;
                            } else {
                                fieldDeclaration.initialization = new org.eclipse.jdt.internal.compiler.ast.CastExpression(innerTypeDeclaration.allocation, this.createTypeReferenceForClassNode(ClassHelper.OBJECT_TYPE));
                                fieldDeclaration.initialization.sourceStart = innerTypeDeclaration.sourceStart;
                                fieldDeclaration.initialization.sourceEnd = innerTypeDeclaration.sourceEnd;
                                fieldDeclaration.initialization = new org.eclipse.jdt.internal.compiler.ast.CastExpression(fieldDeclaration.initialization, fieldDeclaration.type);
                                fieldDeclaration.initialization.sourceStart = innerTypeDeclaration.sourceStart;
                                fieldDeclaration.initialization.sourceEnd = innerTypeDeclaration.sourceEnd;
                            }
                        }
                    }
                    ((GroovyTypeDeclaration)outerTypeDeclaration).addAnonymousType(innerTypeDeclaration);
                }
                outerTypeDeclaration.memberTypes = memberTypes.toArray(new TypeDeclaration[memberTypes.size()]);
            }
            this.anonymousLocations = null;
            this.unitDeclaration.types = typeDeclarations.toArray(new TypeDeclaration[typeDeclarations.size()]);
        }

        private FieldDeclaration[] createFieldDeclarations(ClassNode classNode, boolean isEnum) {
            ArrayList<FieldDeclarationWithInitializer> fieldDeclarations = new ArrayList<FieldDeclarationWithInitializer>();
            List<FieldNode> fieldNodes = classNode.getFields();
            if (fieldNodes != null && !fieldNodes.isEmpty()) {
                boolean isTrait = this.isTrait(classNode);
                for (final FieldNode fieldNode : fieldNodes) {
                    MethodNode clinit;
                    if (isTrait && (!fieldNode.isPublic() || !fieldNode.isStatic() || !fieldNode.isFinal()) || isEnum && (fieldNode.getName().equals("MAX_VALUE") || fieldNode.getName().equals("MIN_VALUE")) || fieldNode.getStart() == fieldNode.getNameStart() && fieldNode.getType().equals(ClassHelper.void_WRAPPER_TYPE)) continue;
                    boolean isEnumField = fieldNode.isEnum();
                    boolean isSynthetic = GroovyUtils.isSynthetic(fieldNode);
                    if (isSynthetic) continue;
                    final FieldDeclarationWithInitializer fieldDeclaration = new FieldDeclarationWithInitializer(fieldNode.getName().toCharArray(), fieldNode.getNameStart(), fieldNode.getNameEnd());
                    fieldDeclaration.annotations = this.createAnnotations(fieldNode.getAnnotations());
                    if (!isEnumField) {
                        fieldDeclaration.modifiers = this.getModifiers(fieldNode);
                        fieldDeclaration.initializer = fieldNode.getInitialExpression();
                        if (fieldNode.isStatic() && fieldNode.isFinal()) {
                            fieldDeclaration.initialization = this.createInitializationExpression(fieldNode.getInitialExpression(), fieldNode.getType());
                        }
                        fieldDeclaration.type = this.createTypeReferenceForClassNode(fieldNode.getType());
                        if (this.anonymousLocations != null && fieldNode.getInitialExpression() != null) {
                            fieldNode.getInitialExpression().visit(new AnonInnerFinder(fieldDeclaration));
                        }
                    } else if (this.anonymousLocations != null && (clinit = classNode.getMethod("<clinit>", Parameter.EMPTY_ARRAY)) != null && clinit.getCode() != null) {
                        clinit.getCode().visit(new CodeVisitorSupport(){

                            private void checkForEnumConstantInitialization(MethodCall call, ClassNode thisType) {
                                if (call.getMethodAsString().equals("$INIT") && GroovyUtils.isAnonymous(thisType) && fieldNode.getName().equals(((ArgumentListExpression)call.getArguments()).getExpression(0).getText())) {
                                    anonymousLocations.put(thisType, fieldDeclaration);
                                }
                            }

                            @Override
                            public void visitStaticMethodCallExpression(StaticMethodCallExpression call) {
                                this.checkForEnumConstantInitialization(call, call.getOwnerType());
                                super.visitStaticMethodCallExpression(call);
                            }

                            @Override
                            public void visitMethodCallExpression(MethodCallExpression call) {
                                this.checkForEnumConstantInitialization(call, call.getType());
                                super.visitMethodCallExpression(call);
                            }
                        });
                    }
                    fieldDeclarations.add(fieldDeclaration);
                    this.fixupSourceLocationsForFieldDeclaration(fieldDeclaration, fieldNode);
                    this.unitDeclaration.sourceEnds.put(fieldDeclaration, fieldDeclaration.sourceEnd);
                }
            }
            return fieldDeclarations.toArray(new FieldDeclaration[fieldDeclarations.size()]);
        }

        private AbstractMethodDeclaration[] createConstructorAndMethodDeclarations(ClassNode classNode, boolean isEnum, GroovyTypeDeclaration typeDeclaration) {
            ArrayList<AbstractMethodDeclaration> methodDeclarations = new ArrayList<AbstractMethodDeclaration>();
            this.createConstructorDeclarations(classNode, isEnum, methodDeclarations);
            this.createMethodDeclarations(classNode, isEnum, typeDeclaration, methodDeclarations);
            return methodDeclarations.toArray(new AbstractMethodDeclaration[methodDeclarations.size()]);
        }

        private void createConstructorDeclarations(ClassNode classNode, boolean isEnum, List<AbstractMethodDeclaration> methodDeclarations) {
            char[] ctorName;
            List<ConstructorNode> constructorNodes = classNode.getDeclaredConstructors();
            boolean isAnon = false;
            if (classNode instanceof InnerClassNode) {
                isAnon = ((InnerClassNode)classNode).isAnonymous();
                int qualLength = classNode.getOuterClass().getNameWithoutPackage().length() + 1;
                ctorName = classNode.getNameWithoutPackage().substring(qualLength).toCharArray();
            } else {
                ctorName = classNode.getNameWithoutPackage().toCharArray();
            }
            if (constructorNodes.isEmpty() && !isAnon && !classNode.isInterface() && !this.isTrait(classNode)) {
                ConstructorDeclaration constructorDecl = new ConstructorDeclaration(this.unitDeclaration.compilationResult);
                try {
                    constructorDecl.annotations = new Annotation[]{new MarkerAnnotation(this.createTypeReferenceForClassNode(ClassHelper.make(Class.forName("groovy.transform.Generated"))), -1)};
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                LinkedList initializerStatements = (LinkedList)classNode.getObjectInitializerStatements();
                if (initializerStatements.isEmpty()) {
                    constructorDecl.bits |= 0x80;
                } else {
                    constructorDecl.declarationSourceStart = ((org.codehaus.groovy.ast.stmt.Statement)initializerStatements.getFirst()).getStart();
                    constructorDecl.declarationSourceEnd = ((org.codehaus.groovy.ast.stmt.Statement)initializerStatements.getLast()).getEnd() - 1;
                    constructorDecl.sourceStart = constructorDecl.declarationSourceStart + 1;
                    constructorDecl.sourceEnd = constructorDecl.declarationSourceStart;
                    constructorDecl.bodyStart = constructorDecl.declarationSourceStart;
                    constructorDecl.bodyEnd = constructorDecl.declarationSourceEnd - 1;
                }
                if (isEnum) {
                    constructorDecl.modifiers = 2;
                } else {
                    int modifiers = this.getModifiers(classNode, classNode.getOuterClass() != null);
                    constructorDecl.modifiers = modifiers & 7;
                }
                constructorDecl.selector = ctorName;
                if (methodDeclarations.add(constructorDecl)) {
                    this.unitDeclaration.sourceEnds.put(constructorDecl, constructorDecl.sourceEnd);
                }
            }
            for (ConstructorNode constructorNode : constructorNodes) {
                ConstructorDeclaration constructorDecl = new ConstructorDeclaration(this.unitDeclaration.compilationResult);
                this.fixupSourceLocationsForConstructorDeclaration(constructorDecl, constructorNode);
                constructorDecl.annotations = this.createAnnotations(constructorNode.getAnnotations());
                constructorDecl.arguments = this.createArguments(constructorNode.getParameters());
                constructorDecl.modifiers = isEnum ? 2 : this.getModifiers(constructorNode);
                constructorDecl.selector = ctorName;
                constructorDecl.thrownExceptions = this.createTypeReferencesForClassNodes(constructorNode.getExceptions());
                if (methodDeclarations.add(constructorDecl)) {
                    this.unitDeclaration.sourceEnds.put(constructorDecl, constructorNode.getNameEnd());
                }
                if (constructorNode.getCode() != null) {
                    HashMap variables = new HashMap();
                    constructorNode.getCode().visit(new LocalVariableFinder(variables));
                    if (!variables.isEmpty()) {
                        constructorDecl.statements = this.createStatements(variables.values());
                    }
                }
                if (constructorNode.hasDefaultValue()) {
                    for (Argument[] variantArgs : this.getVariantsAllowingForDefaulting(constructorNode.getParameters(), constructorDecl.arguments)) {
                        ConstructorDeclaration variantDecl = new ConstructorDeclaration(this.unitDeclaration.compilationResult);
                        variantDecl.annotations = constructorDecl.annotations;
                        variantDecl.arguments = variantArgs;
                        variantDecl.javadoc = constructorDecl.javadoc;
                        variantDecl.modifiers = constructorDecl.modifiers;
                        variantDecl.selector = constructorDecl.selector;
                        variantDecl.sourceEnd = constructorDecl.sourceEnd;
                        variantDecl.sourceStart = constructorDecl.sourceStart;
                        variantDecl.thrownExceptions = constructorDecl.thrownExceptions;
                        variantDecl.declarationSourceStart = 0;
                        variantDecl.declarationSourceEnd = -1;
                        variantDecl.modifiersSourceStart = 0;
                        variantDecl.bodyStart = 0;
                        variantDecl.bodyEnd = -1;
                        if (!this.addUnlessDuplicate(methodDeclarations, variantDecl)) continue;
                        this.unitDeclaration.sourceEnds.put(variantDecl, constructorNode.getNameEnd());
                    }
                }
                if (this.anonymousLocations == null || constructorNode.getCode() == null) continue;
                new AnonInnerFinder(constructorDecl).visitMethodNode(constructorNode);
            }
        }

        private void createMethodDeclarations(ClassNode classNode, boolean isEnum, GroovyTypeDeclaration typeDeclaration, List<AbstractMethodDeclaration> methodDeclarations) {
            List<MethodNode> methodNodes = classNode.getMethods();
            if (methodNodes != null && !methodNodes.isEmpty()) {
                boolean isTrait = this.isTrait(classNode);
                for (MethodNode methodNode : methodNodes) {
                    if (isEnum && methodNode.isSynthetic() || isTrait && (!methodNode.isPublic() || methodNode.isDefault())) continue;
                    AbstractMethodDeclaration methodDecl = this.createMethodDeclaration(classNode, methodNode);
                    if (methodDeclarations.add(methodDecl)) {
                        this.unitDeclaration.sourceEnds.put(methodDecl, methodNode.isScriptBody() ? methodNode.getStart() : methodNode.getNameEnd());
                    }
                    if (methodNode.isAbstract()) {
                        typeDeclaration.bits |= 0x800;
                    } else if (methodNode.getCode() != null) {
                        HashMap variables = new HashMap();
                        methodNode.getCode().visit(new LocalVariableFinder(variables));
                        if (!variables.isEmpty()) {
                            methodDecl.statements = this.createStatements(variables.values());
                        }
                    }
                    if (isTrait && methodNode.isFinal()) {
                        methodDecl.modifiers ^= 0x4000010;
                    } else if (isTrait && methodNode.isStatic()) {
                        if (((GroovyCompilationUnitDeclaration)this.unitDeclaration).compilerOptions.targetJDK >= 0x350000L) {
                            methodDecl.modifiers ^= 3;
                        } else if (((GroovyCompilationUnitDeclaration)this.unitDeclaration).compilerOptions.targetJDK < 0x340000L) {
                            methodDecl.modifiers ^= 0x800008;
                        }
                    }
                    if (methodNode.hasDefaultValue()) {
                        for (Argument[] variantArgs : this.getVariantsAllowingForDefaulting(methodNode.getParameters(), methodDecl.arguments)) {
                            AbstractMethodDeclaration variantDecl = this.createMethodDeclaration(classNode, methodNode);
                            variantDecl.arguments = variantArgs;
                            variantDecl.declarationSourceStart = 0;
                            variantDecl.declarationSourceEnd = -1;
                            variantDecl.modifiersSourceStart = 0;
                            variantDecl.bodyStart = 0;
                            variantDecl.bodyEnd = -1;
                            if (!this.addUnlessDuplicate(methodDeclarations, variantDecl)) continue;
                            this.unitDeclaration.sourceEnds.put(variantDecl, methodNode.getNameEnd());
                        }
                    }
                    if (this.anonymousLocations == null || methodNode.getCode() == null) continue;
                    new AnonInnerFinder(methodDecl).visitMethodNode(methodNode);
                }
            }
        }

        private AbstractMethodDeclaration createMethodDeclaration(ClassNode classNode, MethodNode methodNode) {
            Parameter p;
            if (classNode.isAnnotationDefinition()) {
                AnnotationMethodDeclaration methodDeclaration = new AnnotationMethodDeclaration(this.unitDeclaration.compilationResult);
                methodDeclaration.annotations = this.createAnnotations(methodNode.getAnnotations());
                methodDeclaration.selector = methodNode.getName().toCharArray();
                methodDeclaration.modifiers = this.getModifiers(methodNode);
                if (methodNode.hasAnnotationDefault()) {
                    methodDeclaration.modifiers |= 0x20000;
                    methodDeclaration.defaultValue = this.createAnnotationMemberExpression(((ExpressionStatement)methodNode.getCode()).getExpression(), GroovyUtils.getBaseType(methodNode.getReturnType()));
                }
                methodDeclaration.returnType = this.createTypeReferenceForClassNode(methodNode.getReturnType());
                this.fixupSourceLocationsForMethodDeclaration(methodDeclaration, methodNode);
                return methodDeclaration;
            }
            AbstractMethodDeclaration methodDeclaration = methodNode.isStaticConstructor() ? new Clinit(this.unitDeclaration.compilationResult) : new MethodDeclaration(this.unitDeclaration.compilationResult);
            methodDeclaration.annotations = this.createAnnotations(methodNode.getAnnotations());
            methodDeclaration.selector = methodNode.getName().toCharArray();
            int modifiers = this.getModifiers(methodNode);
            Parameter[] params = methodNode.getParameters();
            ClassNode returnType = methodNode.getReturnType();
            if (Flags.isStatic(modifiers) && "main".equals(methodNode.getName()) && params != null && params.length == 1 && ((p = params[0]).getType() == null || p.getType().getName().equals("java.lang.Object"))) {
                params = new Parameter[]{new Parameter(ClassHelper.STRING_TYPE.makeArray(), p.getName())};
                params[0].setSourcePosition(p);
                if (returnType.getName().equals("java.lang.Object")) {
                    returnType = ClassHelper.VOID_TYPE;
                }
            }
            methodDeclaration.modifiers = modifiers;
            methodDeclaration.arguments = this.createArguments(params);
            if (methodDeclaration instanceof MethodDeclaration) {
                GenericsType[] generics = methodNode.getGenericsTypes();
                if (generics != null && generics.length > 0) {
                    ((MethodDeclaration)methodDeclaration).typeParameters = this.createTypeParametersForGenerics(generics);
                }
                ((MethodDeclaration)methodDeclaration).returnType = this.createTypeReferenceForClassNode(returnType);
            }
            methodDeclaration.thrownExceptions = this.createTypeReferencesForClassNodes(methodNode.getExceptions());
            this.fixupSourceLocationsForMethodDeclaration(methodDeclaration, methodNode);
            return methodDeclaration;
        }

        private void configureSuperClass(TypeDeclaration typeDeclaration, ClassNode superclass, boolean isEnum, boolean isTrait) {
            if (isEnum && superclass.getName().equals("java.lang.Enum") || isTrait) {
                typeDeclaration.superclass = null;
            } else if (superclass.getStart() != 0 || !superclass.equals(ClassHelper.OBJECT_TYPE)) {
                typeDeclaration.superclass = this.createTypeReferenceForClassNode(superclass);
            }
        }

        private void configureSuperInterfaces(TypeDeclaration typeDeclaration, ClassNode classNode) {
            ClassNode[] interfaces = classNode.getInterfaces();
            if (interfaces != null && interfaces.length > 0) {
                typeDeclaration.superInterfaces = new TypeReference[interfaces.length];
                int i = 0;
                int n = interfaces.length;
                while (i < n) {
                    typeDeclaration.superInterfaces[i] = this.createTypeReferenceForClassNode(interfaces[i]);
                    ++i;
                }
            } else {
                typeDeclaration.superInterfaces = new TypeReference[0];
            }
        }

        private Annotation[] createAnnotations(List<AnnotationNode> groovyAnnotations) {
            if (groovyAnnotations != null && !groovyAnnotations.isEmpty()) {
                ArrayList<MarkerAnnotation> annotations = new ArrayList<MarkerAnnotation>(groovyAnnotations.size());
                for (AnnotationNode annotationNode : groovyAnnotations) {
                    Annotation annotation;
                    TypeReference annotationReference = this.createTypeReferenceForClassNode(annotationNode.getClassNode());
                    annotationReference.sourceStart = annotationNode.getStart();
                    annotationReference.sourceEnd = annotationNode.getEnd() - 1;
                    Map<String, Expression> memberValuePairs = annotationNode.getMembers();
                    if (memberValuePairs == null || memberValuePairs.isEmpty()) {
                        annotation = new MarkerAnnotation(annotationReference, annotationReference.sourceStart);
                        annotations.add((MarkerAnnotation)annotation);
                    } else if (memberValuePairs.size() == 1 && memberValuePairs.containsKey("value")) {
                        annotation = new SingleMemberAnnotation(annotationReference, annotationReference.sourceStart);
                        ((SingleMemberAnnotation)annotation).memberValue = this.createAnnotationMemberExpression(memberValuePairs.get("value"), null);
                        annotations.add((MarkerAnnotation)annotation);
                    } else {
                        annotation = new NormalAnnotation(annotationReference, annotationReference.sourceStart);
                        ((NormalAnnotation)annotation).memberValuePairs = this.createAnnotationMemberValuePairs(memberValuePairs);
                        annotations.add((MarkerAnnotation)annotation);
                    }
                    ((Annotation)annotations.get((int)(annotations.size() - 1))).declarationSourceEnd = annotationReference.sourceEnd;
                }
                return annotations.toArray(new Annotation[annotations.size()]);
            }
            return null;
        }

        private org.eclipse.jdt.internal.compiler.ast.Expression createAnnotationMemberExpression(Expression expr, ClassNode type) {
            if (expr instanceof ListExpression) {
                ListExpression list = (ListExpression)expr;
                ArrayInitializer arrayInitializer = new ArrayInitializer();
                arrayInitializer.sourceStart = expr.getStart();
                arrayInitializer.sourceEnd = expr.getEnd() - 1;
                int n = list.getExpressions().size();
                arrayInitializer.expressions = new org.eclipse.jdt.internal.compiler.ast.Expression[n];
                int i = 0;
                while (i < n) {
                    arrayInitializer.expressions[i] = this.createAnnotationMemberExpression(list.getExpression(i), type);
                    ++i;
                }
                return arrayInitializer;
            }
            if (expr instanceof AnnotationConstantExpression) {
                Annotation[] annos = this.createAnnotations(Collections.singletonList((AnnotationNode)((AnnotationConstantExpression)expr).getValue()));
                assert (annos != null && annos.length == 1);
                return annos[0];
            }
            if (expr instanceof VariableExpression) {
                String name = ((VariableExpression)expr).getName();
                return new SingleNameReference(name.toCharArray(), UnitPopulator.toPos(expr.getStart(), expr.getEnd() - 1));
            }
            if (expr instanceof PropertyExpression) {
                char[][] toks;
                PropertyExpression prop = (PropertyExpression)expr;
                int propertyEnd = prop.getProperty().getEnd() - 1;
                if ("class".equals(prop.getPropertyAsString())) {
                    return new ClassLiteralAccess(propertyEnd, this.createTypeReferenceForClassLiteral(prop));
                }
                char[] text = this.sourceUnit.readSourceRange(prop.getStart(), propertyEnd - prop.getStart() + 1);
                if (text == null || text.length == 0) {
                    text = prop.getText().toCharArray();
                }
                if ((toks = CharOperation.splitOn('.', text)).length == 1) {
                    return new SingleNameReference(toks[0], UnitPopulator.toPos(prop.getStart(), propertyEnd));
                }
                return new QualifiedNameReference(toks, this.positionsFor(toks, prop.getStart(), propertyEnd), prop.getStart(), propertyEnd);
            }
            if (expr instanceof ClassExpression) {
                char[][] toks;
                char[] text = this.sourceUnit.readSourceRange(expr.getStart(), expr.getLength());
                if (text == null || text.length == 0) {
                    text = expr.getText().toCharArray();
                }
                int n = "class".equals(String.valueOf((toks = CharOperation.splitOn('.', text))[toks.length - 1]).trim()) ? toks.length - 1 : toks.length;
                long[] poss = this.positionsFor(toks, expr.getStart(), expr.getEnd() - 1);
                return new ClassLiteralAccess(expr.getEnd() - 1, n == 1 ? new SingleTypeReference(toks[0], poss[0]) : new QualifiedTypeReference((char[][])Arrays.copyOfRange(toks, 0, n), Arrays.copyOfRange(poss, 0, n)));
            }
            if (expr instanceof ClosureExpression) {
                return new ClassLiteralAccess(expr.getEnd() - 1, new SingleTypeReference("Closure".toCharArray(), UnitPopulator.toPos(expr.getStart(), expr.getEnd() - 1)));
            }
            if (!(expr instanceof BinaryExpression)) {
                org.eclipse.jdt.internal.compiler.ast.Expression expression = this.createInitializationExpression(expr, type);
                if (expression != null) {
                    return expression;
                }
                Util.log(2, "Unhandled annotation value type: " + expr.getClass().getSimpleName());
            }
            return new NullLiteral(expr.getStart(), expr.getEnd() - 1);
        }

        private MemberValuePair[] createAnnotationMemberValuePairs(Map<String, Expression> memberValuePairs) {
            return (MemberValuePair[])memberValuePairs.entrySet().stream().map(memberValuePair -> {
                char[] name = ((String)memberValuePair.getKey()).toCharArray();
                int start = Math.max(0, ((Expression)memberValuePair.getValue()).getStart() - name.length - 1);
                int until = ((Expression)memberValuePair.getValue()).getEnd() - 1;
                org.eclipse.jdt.internal.compiler.ast.Expression value = this.createAnnotationMemberExpression((Expression)memberValuePair.getValue(), null);
                return new MemberValuePair(name, start, until, value);
            }).toArray(MemberValuePair[]::new);
        }

        private Argument[] createArguments(Parameter[] parameters) {
            if (parameters == null || parameters.length == 0) {
                return null;
            }
            int n = parameters.length;
            Argument[] arguments = new Argument[n];
            int i = 0;
            while (i < n) {
                Parameter parameter = parameters[i];
                arguments[i] = new Argument(parameter.getName().toCharArray(), UnitPopulator.toPos(parameter.getStart(), parameter.getEnd() - 1), this.createTypeReferenceForClassNode(parameter.getType()), parameter.getModifiers());
                arguments[i].annotations = this.createAnnotations(parameter.getAnnotations());
                arguments[i].declarationSourceStart = arguments[i].sourceStart;
                ++i;
            }
            if (this.isVargs(parameters)) {
                arguments[n - 1].type.bits |= 0x4000;
            }
            return arguments;
        }

        private org.eclipse.jdt.internal.compiler.ast.Expression createInitializationExpression(Expression expr, ClassNode type) {
            block79: {
                block77: {
                    if (!(expr instanceof ConstantExpression)) break block77;
                    char[] chars = this.sourceUnit.readSourceRange(expr.getStart(), expr.getLength());
                    if (chars == null || chars.length < 1) {
                        chars = expr.getText().toCharArray();
                    }
                    int start = expr.getStart();
                    int until = expr.getEnd() - 1;
                    Object value = ((ConstantExpression)expr).getValue();
                    switch (expr.getType().getName()) {
                        case "java.lang.Object": {
                            assert (value == null);
                            return new NullLiteral(start, until);
                        }
                        case "boolean": 
                        case "java.lang.Boolean": {
                            return Boolean.TRUE.equals(value) ? new TrueLiteral(start, until) : new FalseLiteral(start, until);
                        }
                        case "java.lang.Integer": 
                        case "int": {
                            switch (chars[0]) {
                                case '+': 
                                case '-': {
                                    UnaryExpression constant = new UnaryExpression(IntLiteral.buildIntLiteral(CharOperation.subarray(chars, 1, chars.length), start + 1, start + chars.length), chars[0] == '-' ? 13 : 14);
                                    constant.sourceStart = start;
                                    constant.sourceEnd = until;
                                    return constant;
                                }
                            }
                            return IntLiteral.buildIntLiteral(chars, start, start + chars.length);
                        }
                        case "long": 
                        case "java.lang.Long": {
                            switch (chars[0]) {
                                case '+': 
                                case '-': {
                                    UnaryExpression constant = new UnaryExpression(LongLiteral.buildLongLiteral(CharOperation.subarray(chars, 1, chars.length), start + 1, start + chars.length), chars[0] == '-' ? 13 : 14);
                                    constant.sourceStart = start;
                                    constant.sourceEnd = until;
                                    return constant;
                                }
                            }
                            return LongLiteral.buildLongLiteral(chars, start, start + chars.length);
                        }
                        case "java.lang.Float": 
                        case "float": {
                            switch (chars[0]) {
                                case '+': 
                                case '-': {
                                    UnaryExpression constant = new UnaryExpression(new FloatLiteral(CharOperation.subarray(chars, 1, chars.length), start + 1, until), chars[0] == '-' ? 13 : 14);
                                    constant.sourceStart = start;
                                    constant.sourceEnd = until;
                                    return constant;
                                }
                            }
                            return new FloatLiteral(chars, start, until);
                        }
                        case "double": 
                        case "java.lang.Double": {
                            switch (chars[0]) {
                                case '+': 
                                case '-': {
                                    UnaryExpression constant = new UnaryExpression(new DoubleLiteral(CharOperation.subarray(chars, 1, chars.length), start + 1, until), chars[0] == '-' ? 13 : 14);
                                    constant.sourceStart = start;
                                    constant.sourceEnd = until;
                                    return constant;
                                }
                            }
                            return new DoubleLiteral(chars, start, until);
                        }
                        case "java.math.BigDecimal": {
                            return new DoubleLiteral(value.toString().toCharArray(), start, until);
                        }
                        case "java.math.BigInteger": {
                            chars[chars.length - 1] = 76;
                            return LongLiteral.buildLongLiteral(chars, start, start + chars.length);
                        }
                        case "java.lang.Short": 
                        case "byte": 
                        case "short": 
                        case "java.lang.Byte": {
                            return IntLiteral.buildIntLiteral(value.toString().toCharArray(), start, start + chars.length);
                        }
                        case "char": 
                        case "java.lang.Character": {
                            if (chars.length < 3 || chars[0] != '\'' || chars[chars.length - 1] != '\'') {
                                chars = new char[]{'\'', ((Character)value).charValue(), '\''};
                            }
                            return new CharLiteral(chars, start, until);
                        }
                        case "java.lang.String": {
                            if (ClassHelper.char_TYPE.equals(type) && ((String)value).length() == 1) {
                                return new CharLiteral(new char[]{'\'', ((String)value).charAt(0), '\''}, start, until);
                            }
                            if (CharOperation.prefixEquals(TRIPLE_QUOTE1, chars) || CharOperation.prefixEquals(TRIPLE_QUOTE2, chars)) {
                                chars = CharOperation.subarray(chars, 3, chars.length - 3);
                            } else if (CharOperation.prefixEquals(DOLLAR_SLASHY, chars)) {
                                chars = CharOperation.subarray(chars, 2, chars.length - 2);
                            } else if (chars[0] == '\"' || chars[0] == '\'' || chars[0] == '/') {
                                chars = CharOperation.subarray(chars, 1, chars.length - 1);
                            }
                            return new StringLiteral(chars, start, until, expr.getLineNumber());
                        }
                    }
                    Util.log(2, "Unhandled constant expression type: " + expr.getType().getName());
                    break block79;
                }
                if (expr instanceof CastExpression) {
                    Expression operand = ((CastExpression)expr).getExpression();
                    return Optional.ofNullable(this.createInitializationExpression(operand, expr.getType())).map(o -> {
                        org.eclipse.jdt.internal.compiler.ast.CastExpression cast = new org.eclipse.jdt.internal.compiler.ast.CastExpression((org.eclipse.jdt.internal.compiler.ast.Expression)o, this.createTypeReferenceForClassNode(expr.getType()));
                        cast.sourceStart = expr.getStart();
                        cast.sourceEnd = expr.getEnd();
                        return cast;
                    }).orElse(null);
                }
            }
            return null;
        }

        private Statement[] createStatements(Collection<VariableExpression> expressions) {
            int n = expressions.size();
            Iterator<VariableExpression> it = expressions.iterator();
            Statement[] statements = new Statement[n];
            int i = 0;
            while (i < n) {
                VariableExpression variableExpression = it.next();
                LocalDeclaration variableDeclaration = new LocalDeclaration(variableExpression.getName().toCharArray(), variableExpression.getStart(), variableExpression.getEnd() - 1);
                variableDeclaration.type = this.createTypeReferenceForClassNode(variableExpression.getOriginType());
                variableDeclaration.bits |= variableDeclaration.type.bits & 0x100000;
                statements[i] = variableDeclaration;
                ++i;
            }
            return statements;
        }

        private TypeReference createTypeReferenceForArrayNameTrailingBrackets(ClassNode node, int sourceStart, int sourceEnd) {
            String name = node.getName();
            int dim = 0;
            int pos = name.length() - 2;
            ClassNode componentType = node;
            while (pos > 0 && name.charAt(pos) == '[') {
                ++dim;
                pos -= 2;
                componentType = componentType.getComponentType();
            }
            if (ClassHelper.isPrimitiveType(componentType)) {
                Integer typeId = charToTypeId.get(Character.valueOf(name.charAt(dim)));
                if (typeId == null) {
                    throw new IllegalStateException("node " + node + " reported it had a primitive component type, but it does not!");
                }
                TypeReference baseTypeReference = TypeReference.baseTypeReference(typeId, dim);
                baseTypeReference.sourceStart = sourceStart;
                baseTypeReference.sourceEnd = sourceStart + componentType.getName().length();
                return baseTypeReference;
            }
            assert (dim > 0) : "array ClassNode with no dimensions: " + name;
            char[] typeName = name.substring(0, pos + 2).toCharArray();
            if (this.unitDeclaration.imports != null) {
                char[][] compoundName = CharOperation.splitOn('.', typeName);
                ImportReference[] importReferenceArray = this.unitDeclaration.imports;
                int n = this.unitDeclaration.imports.length;
                int n2 = 0;
                while (n2 < n) {
                    ImportReference importReference = importReferenceArray[n2];
                    if (this.isAliasForType(importReference, compoundName[0])) {
                        typeName = CharOperation.concatWith(importReference.getImportName(), '.');
                        if (compoundName.length <= 1) break;
                        typeName = CharOperation.concatWith(typeName, CharOperation.subarray(compoundName, 1, -1), '.');
                        break;
                    }
                    ++n2;
                }
            }
            return this.createTypeReferenceForArrayName(typeName, componentType, dim, sourceStart, sourceEnd);
        }

        private TypeReference createTypeReferenceForArrayNameLeadingBrackets(ClassNode node, int sourceStart, int sourceEnd) {
            String name = node.getName();
            int dim = 0;
            ClassNode componentType = node;
            while (name.charAt(dim) == '[') {
                ++dim;
                componentType = componentType.getComponentType();
            }
            if (ClassHelper.isPrimitiveType(componentType)) {
                Integer typeId = charToTypeId.get(Character.valueOf(name.charAt(dim)));
                if (typeId == null) {
                    throw new IllegalStateException("node " + node + " reported it had a primitive component type, but it does not!");
                }
                TypeReference baseTypeReference = TypeReference.baseTypeReference(typeId, dim);
                baseTypeReference.sourceStart = sourceStart;
                baseTypeReference.sourceEnd = sourceStart + componentType.getName().length();
                return baseTypeReference;
            }
            if ((name = name.substring(dim)).charAt(name.length() - 1) == ';') {
                name = name.substring(1, name.length() - 1);
            }
            char[] typeName = name.toCharArray();
            if (this.unitDeclaration.imports != null) {
                char[][] compoundName = CharOperation.splitOn('.', typeName);
                ImportReference[] importReferenceArray = this.unitDeclaration.imports;
                int n = this.unitDeclaration.imports.length;
                int n2 = 0;
                while (n2 < n) {
                    ImportReference importReference = importReferenceArray[n2];
                    if (this.isAliasForType(importReference, compoundName[0])) {
                        typeName = CharOperation.concatWith(importReference.getImportName(), '.');
                        if (compoundName.length <= 1) break;
                        typeName = CharOperation.concatWith(typeName, CharOperation.subarray(compoundName, 1, -1), '.');
                        break;
                    }
                    ++n2;
                }
            }
            return this.createTypeReferenceForArrayName(typeName, componentType, dim, sourceStart, sourceEnd);
        }

        private TypeReference createTypeReferenceForArrayName(char[] typeName, ClassNode typeNode, int dim, int sourceStart, int sourceEnd) {
            if (!typeNode.isUsingGenerics()) {
                if (CharOperation.indexOf('.', typeName) < 0) {
                    ArrayTypeReference tr = new ArrayTypeReference(typeName, dim, UnitPopulator.toPos(sourceStart, sourceEnd - 1));
                    tr.originalSourceEnd = typeNode.getEnd() - 1;
                    return tr;
                }
                char[][] compoundName = CharOperation.splitOn('.', typeName);
                ArrayQualifiedTypeReference tr = new ArrayQualifiedTypeReference(compoundName, dim, this.positionsFor(compoundName, sourceStart, sourceEnd == -2 ? -2 : sourceEnd - dim * 2));
                tr.sourceEnd = sourceEnd == -2 ? -2 : sourceEnd - 1;
                return tr;
            }
            GenericsType[] generics = typeNode.getGenericsTypes();
            TypeReference[] typeArgs = new TypeReference[generics.length];
            int i = 0;
            while (i < generics.length) {
                typeArgs[i] = this.createTypeReferenceForGenerics(generics[i]);
                ++i;
            }
            if (CharOperation.indexOf('.', typeName) < 0) {
                ParameterizedSingleTypeReference tr = new ParameterizedSingleTypeReference(typeName, typeArgs, dim, UnitPopulator.toPos(sourceStart, sourceEnd - 1));
                tr.originalSourceEnd = typeNode.getEnd() - 1;
                return tr;
            }
            char[][] compoundName = CharOperation.splitOn('.', typeName);
            TypeReference[][] compoundArgs = new TypeReference[compoundName.length][];
            compoundArgs[compoundName.length - 1] = typeArgs;
            ParameterizedQualifiedTypeReference tr = new ParameterizedQualifiedTypeReference(compoundName, compoundArgs, dim, this.positionsFor(compoundName, sourceStart, sourceEnd == -2 ? -2 : sourceEnd - dim * 2));
            tr.sourceEnd = sourceEnd == -2 ? -2 : sourceEnd - 1;
            return tr;
        }

        private TypeReference createTypeReferenceForClassLiteral(PropertyExpression expression) {
            Expression candidate = expression.getObjectExpression();
            LinkedList<char[]> nameParts = new LinkedList<char[]>();
            while (candidate instanceof PropertyExpression) {
                nameParts.add(0, ((PropertyExpression)candidate).getPropertyAsString().toCharArray());
                candidate = ((PropertyExpression)candidate).getObjectExpression();
            }
            if (candidate instanceof VariableExpression) {
                nameParts.add(0, ((VariableExpression)candidate).getName().toCharArray());
            }
            char[][] namePartsArr = (char[][])nameParts.toArray((T[])new char[nameParts.size()][]);
            long[] poss = this.positionsFor(namePartsArr, expression.getObjectExpression().getStart(), expression.getObjectExpression().getEnd());
            TypeReference ref = namePartsArr.length > 1 ? new QualifiedTypeReference(namePartsArr, poss) : (namePartsArr.length == 1 ? new SingleTypeReference(namePartsArr[0], poss[0]) : TypeReference.baseTypeReference(6, 0));
            return ref;
        }

        private TypeReference[] createTypeReferencesForClassNodes(ClassNode[] classNodes) {
            if (classNodes == null) {
                return null;
            }
            int n = classNodes.length;
            if (n == 0) {
                return null;
            }
            TypeReference[] refs = new TypeReference[n];
            int i = 0;
            while (i < n) {
                refs[i] = this.createTypeReferenceForClassNode(classNodes[i]);
                ++i;
            }
            return refs;
        }

        private TypeReference createTypeReferenceForClassNode(ClassNode classNode) {
            return this.createTypeReferenceForClassNode(classNode, this.startOffset(classNode), this.endOffset(classNode));
        }

        private TypeReference createTypeReferenceForClassNode(ClassNode classNode, int sourceStart, int sourceEnd) {
            TypeReference[][] typeRefs;
            String name;
            TypeReference tr;
            ArrayList<TypeReference> typeArguments = null;
            GenericsType[] genericsTypes = classNode.getGenericsTypes();
            if (genericsTypes != null) {
                GenericsType[] genericsTypeArray = genericsTypes;
                int n = genericsTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    GenericsType gt = genericsTypeArray[n2];
                    tr = this.createTypeReferenceForGenerics(gt);
                    if (tr != null) {
                        if (typeArguments == null) {
                            typeArguments = new ArrayList<TypeReference>();
                        }
                        typeArguments.add(tr);
                    }
                    ++n2;
                }
            }
            if ((name = classNode.getName()).length() == 1 && name.charAt(0) == '?') {
                Wildcard tr2 = new Wildcard(0);
                tr2.sourceStart = sourceStart;
                tr2.sourceEnd = sourceEnd;
                return tr2;
            }
            int arrayLoc = name.indexOf(91);
            if (arrayLoc == 0) {
                return this.createTypeReferenceForArrayNameLeadingBrackets(classNode, sourceStart, sourceEnd);
            }
            if (arrayLoc > 0) {
                return this.createTypeReferenceForArrayNameTrailingBrackets(classNode, sourceStart, sourceEnd);
            }
            if (nameToPrimitiveTypeId.containsKey(name)) {
                TypeReference tr3 = TypeReference.baseTypeReference(nameToPrimitiveTypeId.get(name), 0);
                tr3.sourceStart = sourceStart;
                tr3.sourceEnd = sourceEnd;
                return tr3;
            }
            char[] typeName = name.toCharArray();
            char[][] compoundName = CharOperation.splitOn('.', typeName);
            if (this.unitDeclaration.imports != null) {
                ImportReference[] importReferenceArray = this.unitDeclaration.imports;
                int n = this.unitDeclaration.imports.length;
                int n3 = 0;
                while (n3 < n) {
                    ImportReference importReference = importReferenceArray[n3];
                    if (this.isAliasForType(importReference, compoundName[0])) {
                        if (compoundName.length == 1) {
                            compoundName = importReference.getImportName();
                            break;
                        }
                        compoundName = CharOperation.arrayConcat(importReference.getImportName(), CharOperation.subarray(compoundName, 1, -1));
                        break;
                    }
                    ++n3;
                }
            }
            if (compoundName.length == 1) {
                if (typeArguments == null) {
                    tr = UnitPopulator.verify(new SingleTypeReference(typeName, UnitPopulator.toPos(sourceStart, sourceEnd - 1)));
                    if (!this.checkGenerics) {
                        tr.bits |= 0x40000000;
                    }
                    return tr;
                }
                typeRefs = typeArguments.toArray(new TypeReference[typeArguments.size()]);
                return new ParameterizedSingleTypeReference(typeName, (TypeReference[])typeRefs, 0, UnitPopulator.toPos(sourceStart, sourceEnd - 1));
            }
            if (typeArguments == null) {
                tr = new QualifiedTypeReference(compoundName, this.positionsFor(compoundName, sourceStart, sourceEnd));
                if (!this.checkGenerics) {
                    tr.bits |= 0x40000000;
                }
                return tr;
            }
            typeRefs = new TypeReference[compoundName.length][];
            typeRefs[compoundName.length - 1] = typeArguments.toArray(new TypeReference[typeArguments.size()]);
            return new ParameterizedQualifiedTypeReference(compoundName, typeRefs, 0, this.positionsFor(compoundName, sourceStart, sourceEnd));
        }

        private TypeReference createTypeReferenceForGenerics(GenericsType genericsType) {
            if (genericsType.isWildcard()) {
                ClassNode[] bounds = genericsType.getUpperBounds();
                if (bounds != null) {
                    TypeReference boundReference = this.createTypeReferenceForClassNode(bounds[0]);
                    Wildcard wildcard = new Wildcard(1);
                    wildcard.sourceStart = genericsType.getStart();
                    wildcard.sourceEnd = boundReference.sourceEnd();
                    wildcard.bound = boundReference;
                    return wildcard;
                }
                if (genericsType.getLowerBound() != null) {
                    TypeReference boundReference = this.createTypeReferenceForClassNode(genericsType.getLowerBound());
                    Wildcard wildcard = new Wildcard(2);
                    wildcard.sourceStart = genericsType.getStart();
                    wildcard.sourceEnd = boundReference.sourceEnd();
                    wildcard.bound = boundReference;
                    return wildcard;
                }
                Wildcard w = new Wildcard(0);
                w.sourceStart = genericsType.getStart();
                w.sourceEnd = genericsType.getStart();
                return w;
            }
            if (!genericsType.getType().isGenericsPlaceHolder()) {
                TypeReference typeReference = this.createTypeReferenceForClassNode(genericsType.getType());
                return typeReference;
            }
            return null;
        }

        private TypeParameter[] createTypeParametersForGenerics(GenericsType[] generics) {
            int n = generics.length;
            TypeParameter[] typeParameters = new TypeParameter[n];
            int i = 0;
            while (i < n) {
                TypeParameter typeParameter;
                typeParameters[i] = typeParameter = new TypeParameter();
                typeParameter.name = generics[i].getName().toCharArray();
                int offset = generics[i].getStart();
                int length = typeParameter.name.length;
                typeParameter.sourceStart = offset;
                typeParameter.sourceEnd = offset + length;
                ClassNode[] upperBounds = generics[i].getUpperBounds();
                if (upperBounds != null && upperBounds.length > 0) {
                    String source = String.valueOf(this.sourceUnit.readSourceRange(generics[i].getStart(), generics[i].getLength()));
                    int _start = this.startOffset(upperBounds[0]);
                    int _until = this.endOffset(upperBounds[0]);
                    if (_until > 0) {
                        source = source.substring(_start - offset);
                        length = _until - _start;
                        offset = _start;
                    } else {
                        offset += length;
                        Matcher m = EXTENDS.matcher(source = source.substring(length));
                        if (m.find()) {
                            length = m.group().length();
                            offset += length;
                            source = source.substring(length);
                        }
                        length = upperBounds[0].getName().length();
                        String name = GroovyUtils.splitName(upperBounds[0])[1];
                        assert (length == source.indexOf(name) + name.length());
                        assert (source.length() == length || source.charAt(length) != '<');
                    }
                    typeParameter.type = this.createTypeReferenceForClassNode(upperBounds[0], offset, offset + length);
                    int j = 1;
                    int k = upperBounds.length;
                    while (j < k) {
                        if (j == 1) {
                            typeParameter.bounds = new TypeReference[k - 1];
                        }
                        _start = this.startOffset(upperBounds[j]);
                        _until = this.endOffset(upperBounds[j]);
                        if (_until > 0) {
                            source = source.substring(_start - offset);
                            length = _until - _start;
                            offset = _start;
                        } else {
                            offset += length;
                            Matcher m = AND.matcher(source = source.substring(length));
                            if (m.find()) {
                                length = m.group().length();
                                offset += length;
                                source = source.substring(length);
                            }
                            length = upperBounds[0].getName().length();
                        }
                        typeParameter.bounds[j - 1] = this.createTypeReferenceForClassNode(upperBounds[j], offset, offset + length);
                        typeParameter.bounds[j - 1].bits |= 0x10;
                        ++j;
                    }
                }
                ++i;
            }
            return typeParameters;
        }

        private long[] positionsFor(char[][] reference, long start, long end) {
            int n = reference.length;
            long[] result = new long[n];
            if (start < end) {
                long offset = start;
                int i = 0;
                while (i < n) {
                    long length = reference[i].length - 1;
                    result[i] = offset << 32 | offset + length;
                    offset += length + 2L;
                    ++i;
                }
            } else if (start == -1L && end == -2L) {
                Arrays.fill(result, -2L);
            } else {
                Arrays.fill(result, start << 32 | start);
            }
            return result;
        }

        private int trailerLength(ASTNode node) {
            int length = 0;
            if (node.getLastLineNumber() > 0 && this.sourceUnit != null) {
                if (this.janitor == null) {
                    this.janitor = new Janitor();
                }
                ReaderSource source = this.sourceUnit.getSource();
                String line = source.getLine(node.getLastLineNumber(), this.janitor);
                StringBuilder sb = null;
                char c = '\u0000';
                int endPos = node.getLastColumnNumber() - 1;
                while (endPos < line.length() && ((c = line.charAt(endPos++)) == ';' || c == ' ' || c == '\t')) {
                    (sb != null ? sb : new StringBuilder()).appendCodePoint(c);
                }
                if (sb != null) {
                    length += sb.length();
                }
            }
            return length;
        }

        private int startOffset(ASTNode node) {
            int s = node.getStart();
            int e = node.getEnd();
            if (s == 0 && e == 0) {
                return -1;
            }
            return s;
        }

        private int endOffset(ASTNode node) {
            int s = node.getStart();
            int e = node.getEnd();
            if (s == 0 && e == 0) {
                return -2;
            }
            return e;
        }

        private int getModifiers(ClassNode node, boolean isInner) {
            int modifiers = node.getModifiers();
            if (this.isTrait(node)) {
                modifiers |= 0x200;
            }
            if (node.isInterface()) {
                modifiers &= 0xFFFFFBFF;
            }
            if (node.isEnum()) {
                modifiers &= 0xFFFFFBEF;
            }
            if (!isInner) {
                modifiers &= 0xFFFFFFF1;
            } else if (((InnerClassNode)node).isAnonymous()) {
                modifiers &= 0xFFFFBFFE;
            }
            if (this.hasPackageScopeXform(node, PackageScopeTarget.CLASS)) {
                modifiers &= 0xFFFFFFFE;
            }
            return modifiers;
        }

        private int getModifiers(FieldNode node) {
            int modifiers = node.getModifiers();
            if (node.getDeclaringClass().getProperty(node.getName()) != null && this.hasPackageScopeXform(node, PackageScopeTarget.FIELDS)) {
                modifiers &= 0xFFFFFFFD;
            }
            return modifiers;
        }

        private int getModifiers(MethodNode node) {
            int modifiers = node.getModifiers() & 0xFFFFEF7F;
            if (node.isDefault()) {
                modifiers |= 0x10000;
            }
            if (node.getCode() == null) {
                modifiers |= 0x1000000;
            }
            if (node.isSyntheticPublic() && this.hasPackageScopeXform(node, PackageScopeTarget.METHODS)) {
                modifiers &= 0xFFFFFFFE;
            }
            return modifiers;
        }

        private int getModifiers(ConstructorNode node) {
            int modifiers = node.getModifiers();
            if (node.isSyntheticPublic() && this.hasPackageScopeXform(node, PackageScopeTarget.CONSTRUCTORS)) {
                modifiers &= 0xFFFFFFFE;
            }
            return modifiers;
        }

        private boolean hasPackageScopeXform(AnnotatedNode node, final PackageScopeTarget type) {
            boolean member = !(node instanceof ClassNode) && type != PackageScopeTarget.CLASS;
            for (AnnotationNode anno : node.getAnnotations()) {
                if (!this.isType("groovy.transform.PackageScope", anno.getClassNode().getName())) continue;
                Expression expr = anno.getMember("value");
                if (expr == null) {
                    return member || node instanceof ClassNode && type == PackageScopeTarget.CLASS;
                }
                final boolean[] val = new boolean[1];
                expr.visit(new CodeVisitorSupport(){

                    @Override
                    public void visitPropertyExpression(PropertyExpression property) {
                        if (this.isType("groovy.transform.PackageScopeTarget", property.getObjectExpression().getText()) && property.getPropertyAsString().equals(type.name())) {
                            val[0] = true;
                        }
                    }

                    @Override
                    public void visitVariableExpression(VariableExpression variable) {
                        if (variable.getName().equals(type.name())) {
                            ModuleNode mod = sourceUnit.getAST();
                            ImportNode imp = mod.getStaticImports().get(type.name());
                            if (imp != null && this.isType("groovy.transform.PackageScopeTarget", imp.getType().getName())) {
                                val[0] = true;
                            } else if (imp == null && mod.getStaticStarImports().get("groovy.transform.PackageScopeTarget") != null) {
                                val[0] = true;
                            }
                        }
                    }
                });
                return val[0];
            }
            if (member) {
                return this.hasPackageScopeXform(node.getDeclaringClass(), type);
            }
            return false;
        }

        private boolean isAliasForType(ImportReference importReference, char[] typeName) {
            if (importReference instanceof AliasImportReference && !importReference.isStatic()) {
                return CharOperation.equals(importReference.getSimpleName(), typeName);
            }
            return false;
        }

        private boolean isTrait(ClassNode classNode) {
            return this.unitDeclaration.traitHelper.isTrait(classNode);
        }

        private boolean isVargs(Parameter[] parameters) {
            if (parameters.length == 0) {
                return false;
            }
            Parameter last = parameters[parameters.length - 1];
            ClassNode type = last.getType();
            return type.isArray();
        }

        private boolean isType(String expect, String actual) {
            if (actual.equals(expect)) {
                return true;
            }
            int dot = expect.lastIndexOf(46);
            if (dot != -1 && actual.equals(expect.substring(dot + 1))) {
                ModuleNode mod = this.sourceUnit.getAST();
                ClassNode imp = mod.getImportType(actual);
                if (imp != null) {
                    return imp.getName().equals(expect);
                }
                String pkg = expect.substring(0, dot + 1);
                for (ImportNode sin : mod.getStarImports()) {
                    if (!sin.getPackageName().equals(pkg)) continue;
                    return true;
                }
            }
            return false;
        }

        private static String lexicalKey(ImportReference ref) {
            StringBuilder key = new StringBuilder();
            key.append(Prefix.format(ref.declarationSourceStart));
            key.append(CharOperation.concatWith(ref.tokens, '.'));
            if ((ref.bits & 0x20000) == 0) {
                key.append(" as ").append(ref.getSimpleName());
            }
            return key.toString();
        }

        private static char[] toMainName(char[] fileName) {
            int end;
            if (fileName == null) {
                return CharOperation.NO_CHAR;
            }
            int start = CharOperation.lastIndexOf('/', fileName) + 1;
            if (start == 0 || start < CharOperation.lastIndexOf('\\', fileName)) {
                start = CharOperation.lastIndexOf('\\', fileName) + 1;
            }
            if ((end = CharOperation.lastIndexOf('.', fileName)) == -1) {
                end = fileName.length;
            }
            return CharOperation.subarray(fileName, start, end);
        }

        private static long toPos(long start, long end) {
            if (start == 0L && end <= 0L) {
                return NON_EXISTENT_POSITION;
            }
            if (start < 0L || end < 0L) {
                return NON_EXISTENT_POSITION;
            }
            return start << 32 | end;
        }

        private Javadoc findJavadoc(int line) {
            for (Comment comment : this.sourceUnit.getComments()) {
                if (!comment.isJavadoc() || comment.getLastLine() + 1 != line && (comment.getLastLine() + 2 != line || comment.usedUp)) continue;
                int[] pos = comment.getPositions(this.unitDeclaration.compilationResult.lineSeparatorPositions);
                comment.usedUp = true;
                return new Javadoc(pos[0], pos[1]);
            }
            return null;
        }

        private void fixupSourceLocationsForTypeDeclaration(GroovyTypeDeclaration typeDeclaration, ClassNode classNode) {
            if (GroovyUtils.isAnonymous(classNode)) {
                typeDeclaration.sourceStart = classNode.getNameStart();
                typeDeclaration.sourceEnd = classNode.getStart() - 2;
                typeDeclaration.bodyStart = classNode.getStart() + 1;
                typeDeclaration.bodyEnd = classNode.getEnd() - 1;
                typeDeclaration.declarationSourceStart = typeDeclaration.sourceStart;
                typeDeclaration.declarationSourceEnd = typeDeclaration.bodyEnd;
            } else {
                typeDeclaration.sourceStart = Math.max(classNode.getNameStart(), classNode.getStart());
                typeDeclaration.sourceEnd = Math.max(classNode.getNameEnd(), classNode.getStart() - 1);
                Javadoc doc = this.findJavadoc(classNode.getLineNumber());
                if (doc != null) {
                    if (this.unitDeclaration.imports != null && this.unitDeclaration.imports.length > 0) {
                        if (doc.sourceStart < this.unitDeclaration.imports[this.unitDeclaration.imports.length - 1].sourceStart) {
                            doc = null;
                        }
                    } else if (this.unitDeclaration.currentPackage != null && doc.sourceStart < this.unitDeclaration.currentPackage.sourceStart) {
                        doc = null;
                    }
                    typeDeclaration.javadoc = doc;
                }
                typeDeclaration.declarationSourceStart = doc != null ? doc.sourceStart : classNode.getStart();
                typeDeclaration.bodyEnd = typeDeclaration.declarationSourceEnd = classNode.getEnd() - 1;
                typeDeclaration.modifiersSourceStart = classNode.getStart();
            }
        }

        private void fixupSourceLocationsForConstructorDeclaration(ConstructorDeclaration constructorDecl, ConstructorNode constructorNode) {
            Javadoc doc;
            constructorDecl.javadoc = doc = this.findJavadoc(constructorNode.getLineNumber());
            constructorDecl.declarationSourceStart = doc != null ? doc.sourceStart : constructorNode.getStart();
            constructorDecl.modifiersSourceStart = constructorNode.getStart();
            constructorDecl.declarationSourceEnd = constructorNode.getEnd() - 1;
            constructorDecl.sourceStart = constructorNode.getNameStart();
            constructorDecl.sourceEnd = UnitPopulator.rparenOffset(constructorNode);
            constructorDecl.bodyStart = constructorNode.getCode() != null ? constructorNode.getCode().getStart() : constructorDecl.sourceEnd + 1;
            constructorDecl.bodyEnd = constructorDecl.declarationSourceEnd - 1;
        }

        private void fixupSourceLocationsForMethodDeclaration(AbstractMethodDeclaration methodDecl, MethodNode methodNode) {
            Javadoc doc;
            methodDecl.javadoc = doc = this.findJavadoc(methodNode.getLineNumber());
            methodDecl.declarationSourceStart = doc != null ? doc.sourceStart : methodNode.getStart();
            methodDecl.modifiersSourceStart = methodNode.getStart();
            methodDecl.declarationSourceEnd = methodNode.getEnd() - 1;
            methodDecl.sourceStart = Math.max(methodNode.getNameStart(), methodNode.getStart());
            methodDecl.sourceEnd = Math.max(UnitPopulator.rparenOffset(methodNode), methodNode.getStart());
            methodDecl.bodyStart = methodNode.getCode() != null ? methodNode.getCode().getStart() : methodDecl.sourceEnd + 1;
            methodDecl.bodyEnd = methodDecl.declarationSourceEnd - (methodDecl instanceof AnnotationMethodDeclaration ? 0 : 1);
        }

        private void fixupSourceLocationsForFieldDeclaration(FieldDeclaration fieldDecl, FieldNode fieldNode) {
            Javadoc doc;
            fieldDecl.javadoc = doc = this.findJavadoc(fieldNode.getLineNumber());
            fieldDecl.declarationSourceStart = doc != null ? doc.sourceStart : fieldNode.getStart();
            fieldDecl.modifiersSourceStart = fieldNode.getStart();
            fieldDecl.endPart1Position = fieldNode.getType().getEnd();
            Integer end2pos = (Integer)fieldNode.getNodeMetaData("end2pos");
            if (end2pos != null) {
                fieldDecl.endPart2Position = end2pos;
                List<FieldNode> fields = fieldNode.getDeclaringClass().getFields();
                int i = fields.indexOf(fieldNode);
                int n = fields.size();
                while (i + 1 < n && fields.get(i + 1).getStart() == fieldNode.getStart()) {
                    ++i;
                }
                Expression fieldInit = fields.get(i).getInitialExpression();
                fieldDecl.declarationEnd = fieldInit != null && fieldInit.getEnd() > 0 ? fieldInit.getEnd() - 1 : fields.get(i).getNameEnd();
                fieldDecl.declarationSourceEnd = fields.get(i).getEnd() - 1;
                if (this.sourceUnit.readSourceRange(fields.get(i).getEnd(), 1)[0] == ';') {
                    ++fieldDecl.declarationSourceEnd;
                    fieldDecl.declarationEnd = fieldDecl.declarationSourceEnd;
                }
            } else if (!fieldNode.isEnum()) {
                Expression fieldInit = fieldNode.getInitialExpression();
                fieldDecl.endPart2Position = fieldInit != null && fieldInit.getEnd() > 0 ? fieldInit.getEnd() - 1 : fieldNode.getNameEnd();
                fieldDecl.declarationEnd = fieldDecl.endPart2Position;
                fieldDecl.declarationSourceEnd = fieldNode.getEnd() - 1;
                if (this.sourceUnit.readSourceRange(fieldNode.getEnd(), 1)[0] == ';') {
                    ++fieldDecl.declarationSourceEnd;
                    fieldDecl.declarationEnd = fieldDecl.declarationSourceEnd;
                    fieldDecl.endPart2Position = fieldDecl.declarationSourceEnd;
                }
            } else {
                fieldDecl.endPart2Position = 0;
                fieldDecl.endPart1Position = 0;
                fieldDecl.declarationEnd = fieldDecl.declarationSourceEnd = fieldNode.getEnd() - 1;
            }
            if (fieldDecl.initialization != null && fieldDecl.initialization.sourceStart < fieldDecl.sourceEnd) {
                fieldDecl.initialization.sourceStart = fieldDecl.initialization.sourceEnd = fieldDecl.sourceEnd;
            }
        }

        private List<Argument[]> getVariantsAllowingForDefaulting(Parameter[] groovyParameters, Argument[] javaArguments) {
            int nextToLetDefault;
            ArrayList<Argument[]> variants = new ArrayList<Argument[]>();
            int nParams = groovyParameters.length;
            Parameter[] wipableParameters = new Parameter[nParams];
            System.arraycopy(groovyParameters, 0, wipableParameters, 0, nParams);
            ArrayList<Argument> variantArgs = new ArrayList<Argument>(nParams);
            do {
                int nArgs;
                variantArgs.clear();
                nextToLetDefault = -1;
                int p = 0;
                while (p < nParams) {
                    if (wipableParameters[p] != null) {
                        if (javaArguments[p].type.isParameterizedTypeReference()) {
                            Argument clone = new Argument(javaArguments[p].name, UnitPopulator.toPos(javaArguments[p].sourceStart, javaArguments[p].sourceEnd), this.createTypeReferenceForClassNode(groovyParameters[p].getType()), javaArguments[p].modifiers);
                            if (javaArguments[p].isVarArgs()) {
                                clone.type.bits |= 0x4000;
                            }
                            clone.annotations = javaArguments[p].annotations;
                            clone.declarationSourceStart = clone.sourceStart;
                            variantArgs.add(clone);
                        } else {
                            variantArgs.add(javaArguments[p]);
                        }
                        if (wipableParameters[p].hasInitialExpression()) {
                            nextToLetDefault = p;
                        }
                    }
                    ++p;
                }
                if (nextToLetDefault != -1) {
                    wipableParameters[nextToLetDefault] = null;
                }
                if ((nArgs = variantArgs.size()) >= nParams) continue;
                variants.add(nArgs == 0 ? null : variantArgs.toArray(new Argument[nArgs]));
            } while (nextToLetDefault != -1);
            return variants;
        }

        private boolean addUnlessDuplicate(List<AbstractMethodDeclaration> methodDeclarations, AbstractMethodDeclaration newDeclaration) {
            boolean isDuplicate = false;
            for (AbstractMethodDeclaration aMethodDecl : methodDeclarations) {
                int vmdArgsLen;
                if (!CharOperation.equals(aMethodDecl.selector, newDeclaration.selector)) continue;
                Argument[] mdArgs = aMethodDecl.arguments;
                Argument[] vmdArgs = newDeclaration.arguments;
                int mdArgsLen = mdArgs == null ? 0 : mdArgs.length;
                int n = vmdArgsLen = vmdArgs == null ? 0 : vmdArgs.length;
                if (mdArgsLen != vmdArgsLen) continue;
                boolean argsTheSame = true;
                int i = 0;
                while (i < mdArgsLen) {
                    if (!CharOperation.equals(mdArgs[i].type.getTypeName(), vmdArgs[i].type.getTypeName())) {
                        argsTheSame = false;
                        break;
                    }
                    ++i;
                }
                if (!argsTheSame) continue;
                isDuplicate = true;
                break;
            }
            return !isDuplicate ? methodDeclarations.add(newDeclaration) : false;
        }

        private static int rparenOffset(MethodNode methodNode) {
            Integer rparenOffset = (Integer)methodNode.getNodeMetaData("rparen.offset");
            if (rparenOffset != null) {
                return rparenOffset;
            }
            int nameEnd = methodNode.getNameEnd();
            if (nameEnd > 0) {
                nameEnd += 2;
            }
            return nameEnd;
        }

        private static TypeReference verify(TypeReference toVerify) {
            if (toVerify.getClass().equals(SingleTypeReference.class)) {
                SingleTypeReference str = (SingleTypeReference)toVerify;
                if (str.sourceStart == -1) {
                    if (str.sourceEnd != -2) {
                        throw new IllegalStateException("TypeReference '" + String.valueOf(str.token) + " should end at -2");
                    }
                } else if (str.sourceEnd < str.sourceStart) {
                    throw new IllegalStateException("TypeReference '" + String.valueOf(str.token) + " should end at " + str.sourceStart + " or later");
                }
            } else {
                throw new IllegalStateException("Cannot verify type reference of this class " + toVerify.getClass());
            }
            return toVerify;
        }

        private class AnonInnerFinder
        extends CodeVisitorSupport {
            private final Object enclosingDecl;

            private AnonInnerFinder(Object enclosingDecl) {
                this.enclosingDecl = enclosingDecl;
            }

            public void visitMethodNode(MethodNode node) {
                node.getCode().visit(this);
                if (node.hasDefaultValue()) {
                    Arrays.stream(node.getParameters()).filter(Parameter::hasInitialExpression).forEach(p -> p.getInitialExpression().visit(this));
                }
            }

            @Override
            public void visitConstructorCallExpression(ConstructorCallExpression call) {
                if (call.isUsingAnonymousInnerClass()) {
                    UnitPopulator.this.anonymousLocations.put(call.getType(), this.enclosingDecl);
                }
                super.visitConstructorCallExpression(call);
            }
        }

        private static class LocalVariableFinder
        extends CodeVisitorSupport {
            private final Map<String, VariableExpression> variables;

            private LocalVariableFinder(Map<String, VariableExpression> variables) {
                this.variables = variables;
            }

            @Override
            public void visitConstructorCallExpression(ConstructorCallExpression expression) {
            }

            @Override
            public void visitDeclarationExpression(DeclarationExpression expression) {
                if (!expression.isMultipleAssignmentDeclaration()) {
                    this.variables.putIfAbsent(expression.getVariableExpression().getName(), expression.getVariableExpression());
                } else {
                    for (Expression expr : expression.getTupleExpression().getExpressions()) {
                        this.variables.putIfAbsent(((VariableExpression)expr).getName(), (VariableExpression)expr);
                    }
                }
                super.visitDeclarationExpression(expression);
            }
        }
    }
}

