/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.internal.compiler.ast;

import groovy.lang.GroovyClassLoader;
import groovy.lang.MissingClassException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.codehaus.groovy.transform.trait.Traits;
import org.codehaus.groovy.vmplugin.v5.Java5;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyCompilationUnitDeclaration;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyTypeDeclaration;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTAnnotationNode;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTClassNodeBuilder;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTFieldNode;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTMethodNode;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTNode;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTResolver;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.groovy.core.util.ArrayUtils;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.impl.BooleanConstant;
import org.eclipse.jdt.internal.compiler.impl.ByteConstant;
import org.eclipse.jdt.internal.compiler.impl.CharConstant;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.impl.DoubleConstant;
import org.eclipse.jdt.internal.compiler.impl.FloatConstant;
import org.eclipse.jdt.internal.compiler.impl.IntConstant;
import org.eclipse.jdt.internal.compiler.impl.LongConstant;
import org.eclipse.jdt.internal.compiler.impl.ShortConstant;
import org.eclipse.jdt.internal.compiler.impl.StringConstant;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.DelegateMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LazilyResolvedMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MemberTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.RawTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;

public class JDTClassNode
extends ClassNode
implements JDTNode {
    private volatile int bits;
    private boolean lazyInitStarted;
    private boolean anyGenericsInitialized;
    private GroovyTypeDeclaration groovyTypeDecl;
    private ReferenceBinding jdtBinding;
    private final JDTResolver resolver;
    private boolean unfindable;
    private Boolean isTrait;

    @Override
    public ReferenceBinding getJdtBinding() {
        return this.jdtBinding;
    }

    public void setJdtBinding(ReferenceBinding jdtBinding) {
        this.jdtBinding = jdtBinding;
    }

    @Override
    public JDTResolver getResolver() {
        return this.resolver;
    }

    public JDTClassNode(ReferenceBinding jdtReferenceBinding, JDTResolver resolver) {
        super(JDTClassNode.getName(jdtReferenceBinding), JDTClassNode.getMods(jdtReferenceBinding), null);
        this.jdtBinding = jdtReferenceBinding;
        this.resolver = resolver;
        this.lazyInitDone = false;
        this.isPrimaryNode = false;
    }

    private static String getName(TypeBinding tb) {
        if (tb instanceof ArrayBinding) {
            return String.valueOf(((ArrayBinding)tb).signature());
        }
        if (tb instanceof MemberTypeBinding) {
            MemberTypeBinding mtb = (MemberTypeBinding)tb;
            return CharOperation.toString(mtb.compoundName);
        }
        if (tb instanceof ReferenceBinding) {
            return CharOperation.toString(((ReferenceBinding)tb).compoundName);
        }
        return String.valueOf(tb.sourceName());
    }

    private static int getMods(TypeBinding tb) {
        if (tb instanceof ReferenceBinding) {
            return ((ReferenceBinding)tb).modifiers;
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lazyClassInit() {
        if (!this.lazyInitDone) {
            Object object = this.lazyInitLock;
            synchronized (object) {
                ReferenceBinding[] superInterfaceBindings;
                ReferenceBinding superClass;
                if (this.lazyInitDone || this.lazyInitStarted) {
                    return;
                }
                this.lazyInitStarted = true;
                if (this.jdtBinding instanceof SourceTypeBinding) {
                    TypeDeclaration typeDecl;
                    SourceTypeBinding sourceTypeBinding = (SourceTypeBinding)this.jdtBinding;
                    if (sourceTypeBinding.scope != null && (typeDecl = sourceTypeBinding.scope.referenceContext) instanceof GroovyTypeDeclaration) {
                        this.groovyTypeDecl = (GroovyTypeDeclaration)typeDecl;
                    }
                }
                if (!this.jdtBinding.isInterface() && (superClass = this.jdtBinding.superclass()) != null) {
                    this.setUnresolvedSuperClass(this.resolver.convertToClassNode(superClass));
                }
                if ((superInterfaceBindings = this.jdtBinding.superInterfaces()) == null) {
                    superInterfaceBindings = Binding.NO_SUPERINTERFACES;
                }
                int n = superInterfaceBindings.length;
                ClassNode[] interfaces = new ClassNode[n];
                int i = 0;
                while (i < n) {
                    interfaces[i] = this.resolver.convertToClassNode(superInterfaceBindings[i]);
                    ++i;
                }
                this.setInterfaces(interfaces);
                this.initializeMembers();
                this.lazyInitDone = true;
            }
        }
    }

    private void initializeMembers() {
        if (this.isRedirectNode()) {
            return;
        }
        try {
            SourceTypeBinding sourceTypeBinding;
            Object mNode3;
            int n;
            MethodBinding[] methodBindings;
            ArrayList<Object[]> pairs = new ArrayList<Object[]>();
            if (this.jdtBinding instanceof ParameterizedTypeBinding) {
                ReferenceBinding genericType = ((ParameterizedTypeBinding)this.jdtBinding).genericType();
                methodBindings = genericType.methods();
            } else {
                methodBindings = this.jdtBinding.methods();
            }
            if (methodBindings != null) {
                MethodBinding[] methodBindingArray = methodBindings;
                n = methodBindings.length;
                int n2 = 0;
                while (n2 < n) {
                    MethodBinding methodBinding = methodBindingArray[n2];
                    if (methodBinding.isConstructor()) {
                        ConstructorNode cNode = this.constructorBindingToConstructorNode(methodBinding);
                        pairs.add(new Object[]{methodBinding, cNode});
                        this.addConstructor(cNode);
                    } else {
                        mNode3 = this.methodBindingToMethodNode(methodBinding);
                        pairs.add(new Object[]{methodBinding, mNode3});
                        this.addMethod((MethodNode)mNode3);
                    }
                    ++n2;
                }
            }
            if (this.jdtBinding instanceof BinaryTypeBinding) {
                MethodBinding[] infraBindings;
                mNode3 = infraBindings = ((BinaryTypeBinding)this.jdtBinding).infraMethods();
                int n3 = infraBindings.length;
                n = 0;
                while (n < n3) {
                    MethodBinding methodBinding = mNode3[n];
                    if (methodBinding.isConstructor()) {
                        ConstructorNode cNode = this.constructorBindingToConstructorNode(methodBinding);
                        pairs.add(new Object[]{methodBinding, cNode});
                        this.addConstructor(cNode);
                    } else {
                        MethodNode mNode2 = this.methodBindingToMethodNode(methodBinding);
                        pairs.add(new Object[]{methodBinding, mNode2});
                        this.addMethod(mNode2);
                    }
                    ++n;
                }
            } else if (this.jdtBinding instanceof SourceTypeBinding && (this.jdtBinding.tagBits & 0x80L) == 0L && (sourceTypeBinding = (SourceTypeBinding)this.jdtBinding).isPrototype()) {
                SyntheticMethodBinding[] syntheticMethodBindings;
                ClassScope classScope = sourceTypeBinding.scope;
                if (classScope != null) {
                    CompilationUnitScope cuScope = classScope.compilationUnitScope();
                    LookupEnvironment environment = classScope.environment();
                    cuScope.verifyMethods(environment.methodVerifier());
                }
                if ((syntheticMethodBindings = sourceTypeBinding.syntheticMethods()) != null) {
                    SyntheticMethodBinding[] syntheticMethodBindingArray = syntheticMethodBindings;
                    int mNode2 = syntheticMethodBindings.length;
                    int mNode3 = 0;
                    while (mNode3 < mNode2) {
                        SyntheticMethodBinding syntheticBinding = syntheticMethodBindingArray[mNode3];
                        if (syntheticBinding.isConstructor()) {
                            ConstructorNode cNode = this.constructorBindingToConstructorNode(syntheticBinding);
                            pairs.add(new Object[]{syntheticBinding, cNode});
                            this.addConstructor(cNode);
                        } else {
                            MethodNode mNode4 = this.methodBindingToMethodNode(syntheticBinding);
                            pairs.add(new Object[]{syntheticBinding, mNode4});
                            this.addMethod(mNode4);
                        }
                        ++mNode3;
                    }
                }
            }
            for (Object[] pair : pairs) {
                if (!(pair[0] instanceof DelegateMethodBinding)) continue;
                MethodBinding target = ((DelegateMethodBinding)pair[0]).delegateMethod.binding;
                for (MethodNode candidate : pair[1] instanceof ConstructorNode ? this.constructors : this.methods.getNotNull(((MethodNode)pair[1]).getName())) {
                    Binding binding;
                    Binding binding2 = binding = pair[1] instanceof JDTNode ? ((JDTNode)((Object)candidate)).getJdtBinding() : (Binding)candidate.getNodeMetaData("JdtBinding");
                    if (binding != target) continue;
                    ((MethodNode)pair[1]).setOriginal(candidate);
                }
            }
            FieldBinding[] fieldBindings = this.jdtBinding instanceof ParameterizedTypeBinding ? ((ParameterizedTypeBinding)this.jdtBinding).genericType().fields() : this.jdtBinding.fields();
            if (fieldBindings != null) {
                FieldBinding[] mNode3 = fieldBindings;
                int candidate = fieldBindings.length;
                int n4 = 0;
                while (n4 < candidate) {
                    FieldBinding fieldBinding = mNode3[n4];
                    FieldNode fNode = this.fieldBindingToFieldNode(fieldBinding, this.groovyTypeDecl);
                    this.addField(fNode);
                    ++n4;
                }
            }
            if (this.groovyTypeDecl != null && this.isTrait()) {
                for (PropertyNode pNode : this.getProperties()) {
                    MethodNode mNode5;
                    String pName = pNode.getName();
                    String capitalizedName = MetaClassHelper.capitalize(pName);
                    int mMods = 1 | pNode.getModifiers() & 8;
                    if (ClassHelper.boolean_TYPE.equals(pNode.getType())) {
                        mNode5 = this.addMethod("is" + capitalizedName, mMods, pNode.getType(), Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, null);
                        if (!(mNode5 instanceof JDTNode)) {
                            mNode5.setNameStart(pNode.getField().getNameStart());
                            mNode5.setNameEnd(pNode.getField().getNameEnd());
                            mNode5.setSynthetic(true);
                            mNode5 = this.addMethod("get" + capitalizedName, mMods, pNode.getType(), Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, null);
                            if (!(mNode5 instanceof JDTNode)) {
                                mNode5.setNameStart(pNode.getField().getNameStart());
                                mNode5.setNameEnd(pNode.getField().getNameEnd());
                                mNode5.setSynthetic(true);
                            }
                        }
                    } else {
                        mNode5 = this.addMethod("get" + capitalizedName, mMods, pNode.getType(), Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, null);
                        if (!(mNode5 instanceof JDTNode)) {
                            mNode5.setNameStart(pNode.getField().getNameStart());
                            mNode5.setNameEnd(pNode.getField().getNameEnd());
                            mNode5.setSynthetic(true);
                        }
                    }
                    if (Flags.isFinal(pNode.getModifiers()) || (mNode5 = this.addMethod("set" + capitalizedName, mMods, ClassHelper.VOID_TYPE, new Parameter[]{new Parameter(pNode.getType(), pName)}, ClassNode.EMPTY_ARRAY, null)) instanceof JDTNode) continue;
                    mNode5.setNameStart(pNode.getField().getNameStart());
                    mNode5.setNameEnd(pNode.getField().getNameEnd());
                    mNode5.setSynthetic(true);
                }
            }
        }
        catch (AbortCompilation e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Failed to initialize members for type " + this.getName(), e);
        }
    }

    private MethodNode methodBindingToMethodNode(MethodBinding methodBinding) {
        try {
            int modifiers = methodBinding.modifiers;
            if (!(!this.isInterface() || Flags.isStatic(modifiers) || Flags.isSynthetic(modifiers) || Flags.isDefaultMethod(modifiers) || this.isTrait())) {
                modifiers |= 0x400;
            }
            ClassNode returnType = methodBinding.returnType != null ? this.resolver.convertToClassNode(methodBinding.returnType) : ClassHelper.DYNAMIC_TYPE;
            Parameter[] parameters = this.makeParameters(methodBinding.parameters, methodBinding.parameterNames, methodBinding.getParameterAnnotations());
            ClassNode[] exceptions = ClassNode.EMPTY_ARRAY;
            if (methodBinding.thrownExceptions != null && methodBinding.thrownExceptions.length > 0) {
                exceptions = new ClassNode[methodBinding.thrownExceptions.length];
                int i = 0;
                while (i < methodBinding.thrownExceptions.length) {
                    exceptions[i] = this.resolver.convertToClassNode(methodBinding.thrownExceptions[i]);
                    ++i;
                }
            }
            JDTMethodNode methodNode = new JDTMethodNode(methodBinding, this.resolver, String.valueOf(methodBinding.selector), modifiers, returnType, parameters, exceptions, null);
            methodNode.setAnnotationDefault(this.jdtBinding.isAnnotationType() && methodBinding.getDefaultValue() != null);
            methodNode.setGenericsTypes(new JDTClassNodeBuilder(this.resolver).configureTypeVariables(methodBinding.typeVariables()));
            methodNode.setSynthetic(methodBinding instanceof LazilyResolvedMethodBinding);
            return methodNode;
        }
        catch (AbortCompilation e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new IllegalStateException("Failed to resolve method node for " + String.valueOf(CharOperation.concatWith(this.jdtBinding.compoundName, methodBinding.selector, '.')), e);
        }
    }

    private ConstructorNode constructorBindingToConstructorNode(MethodBinding methodBinding) {
        Parameter[] parameters = this.makeParameters(methodBinding.parameters, methodBinding.parameterNames, methodBinding.getParameterAnnotations());
        ClassNode[] exceptions = ClassNode.EMPTY_ARRAY;
        if (methodBinding.thrownExceptions != null && methodBinding.thrownExceptions.length > 0) {
            exceptions = new ClassNode[methodBinding.thrownExceptions.length];
            int i = 0;
            while (i < methodBinding.thrownExceptions.length) {
                exceptions[i] = this.resolver.convertToClassNode(methodBinding.thrownExceptions[i]);
                ++i;
            }
        }
        ConstructorNode ctorNode = new ConstructorNode(methodBinding.modifiers, parameters, exceptions, null);
        AnnotationBinding[] annotationBindingArray = methodBinding.getAnnotations();
        int n = annotationBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            AnnotationBinding annotationBinding = annotationBindingArray[n2];
            ctorNode.addAnnotation(new JDTAnnotationNode(annotationBinding, this.resolver));
            ++n2;
        }
        ctorNode.setGenericsTypes(new JDTClassNodeBuilder(this.resolver).configureTypeVariables(methodBinding.typeVariables()));
        ctorNode.putNodeMetaData("JdtBinding", methodBinding);
        return ctorNode;
    }

    private FieldNode fieldBindingToFieldNode(FieldBinding fieldBinding, TypeDeclaration typeDeclaration) {
        String name = String.valueOf(fieldBinding.name);
        int modifiers = fieldBinding.modifiers;
        ClassNode fieldType = this.resolver.convertToClassNode(fieldBinding.type);
        Constant c = fieldBinding.constant();
        Expression initializerExpression = null;
        if (c == Constant.NotAConstant) {
            FieldDeclaration fieldDecl;
            if (typeDeclaration != null && (fieldDecl = typeDeclaration.declarationOf(fieldBinding)) instanceof GroovyCompilationUnitDeclaration.FieldDeclarationWithInitializer) {
                initializerExpression = ((GroovyCompilationUnitDeclaration.FieldDeclarationWithInitializer)fieldDecl).getGroovyInitializer();
            }
        } else if (c instanceof BooleanConstant) {
            initializerExpression = new ConstantExpression(((BooleanConstant)c).booleanValue());
        } else if (c instanceof ByteConstant) {
            initializerExpression = new ConstantExpression(((ByteConstant)c).byteValue());
        } else if (c instanceof CharConstant) {
            initializerExpression = new ConstantExpression(Character.valueOf(((CharConstant)c).charValue()));
        } else if (c instanceof DoubleConstant) {
            initializerExpression = new ConstantExpression(((DoubleConstant)c).doubleValue());
        } else if (c instanceof FloatConstant) {
            initializerExpression = new ConstantExpression(Float.valueOf(((FloatConstant)c).floatValue()));
        } else if (c instanceof IntConstant) {
            initializerExpression = new ConstantExpression(((IntConstant)c).intValue());
        } else if (c instanceof LongConstant) {
            initializerExpression = new ConstantExpression(((LongConstant)c).longValue());
        } else if (c instanceof ShortConstant) {
            initializerExpression = new ConstantExpression(((ShortConstant)c).shortValue());
        } else if (c instanceof StringConstant) {
            initializerExpression = new ConstantExpression(((StringConstant)c).stringValue());
        }
        return new JDTFieldNode(fieldBinding, this.resolver, name, modifiers, fieldType, this, initializerExpression);
    }

    private ClassNode makeClassNode(TypeBinding t, TypeBinding e) {
        ClassNode back = this.resolver.convertToClassNode(e);
        if (!(t instanceof BinaryTypeBinding) && !(t instanceof SourceTypeBinding)) {
            ClassNode front = new JDTClassNodeBuilder(this.resolver).configureType(t);
            JDTClassNodeBuilder.setRedirect(front, back);
            return front;
        }
        return back;
    }

    private Parameter makeParameter(TypeBinding parameterType, String parameterName) {
        TypeBinding erasureType;
        if (parameterType instanceof ParameterizedTypeBinding) {
            erasureType = ((ParameterizedTypeBinding)parameterType).genericType();
        } else if (parameterType instanceof ArrayBinding || parameterType instanceof TypeVariableBinding) {
            erasureType = parameterType.erasure();
        } else {
            assert (!parameterType.isGenericType());
            erasureType = parameterType;
        }
        return new Parameter(this.makeClassNode(parameterType, erasureType), parameterName);
    }

    private Parameter[] makeParameters(TypeBinding[] parameterTypes, char[][] parameterNames, AnnotationBinding[][] parameterAnnotations) {
        Parameter[] parameters = Parameter.EMPTY_ARRAY;
        if (parameterTypes != null && parameterTypes.length > 0) {
            parameters = new Parameter[parameterTypes.length];
            int i = 0;
            while (i < parameterTypes.length) {
                String parameterName = i < parameterNames.length ? String.valueOf(parameterNames[i]) : (i < Java5.ARGS.length ? Java5.ARGS[i] : "arg" + i);
                parameters[i] = this.makeParameter(parameterTypes[i], parameterName);
                if (parameterAnnotations != null && parameterAnnotations.length > i) {
                    AnnotationBinding[] annotationBindingArray = parameterAnnotations[i];
                    int n = annotationBindingArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        AnnotationBinding annotationBinding = annotationBindingArray[n2];
                        parameters[i].addAnnotation(new JDTAnnotationNode(annotationBinding, this.resolver));
                        ++n2;
                    }
                }
                ++i;
            }
        }
        return parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AnnotationNode> getAnnotations() {
        if ((this.bits & 1) == 0) {
            JDTClassNode jDTClassNode = this;
            synchronized (jDTClassNode) {
                if ((this.bits & 1) == 0) {
                    if (this.jdtBinding instanceof SourceTypeBinding) {
                        long l = ((SourceTypeBinding)this.jdtBinding).getAnnotationTagBits();
                    }
                    AnnotationBinding[] annotationBindingArray = this.jdtBinding.getAnnotations();
                    int n = annotationBindingArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        AnnotationBinding annotationBinding = annotationBindingArray[n2];
                        this.addAnnotation(new JDTAnnotationNode(annotationBinding, this.resolver));
                        ++n2;
                    }
                    this.bits |= 1;
                }
            }
        }
        return Collections.unmodifiableList(super.getAnnotations());
    }

    @Override
    public List<AnnotationNode> getAnnotations(ClassNode type) {
        if ((this.bits & 1) == 0) {
            List<AnnotationNode> list = this.getAnnotations();
        }
        return Collections.unmodifiableList(super.getAnnotations(type));
    }

    @Override
    public GenericsType[] getGenericsTypes() {
        if (!this.anyGenericsInitialized) {
            this.setUpGenerics();
        }
        return super.getGenericsTypes();
    }

    @Override
    public boolean isUsingGenerics() {
        if (!this.anyGenericsInitialized) {
            this.setUpGenerics();
        }
        return super.isUsingGenerics();
    }

    @Override
    public void setUsingGenerics(boolean b) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setGenericsPlaceHolder(boolean b) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setGenericsTypes(GenericsType[] genericsTypes) {
        this.anyGenericsInitialized = true;
        super.setGenericsTypes(genericsTypes);
    }

    void setUpGenerics() {
        if (!this.anyGenericsInitialized) {
            GenericsType[] generics = this.jdtBinding instanceof RawTypeBinding ? null : (this.jdtBinding instanceof ParameterizedTypeBinding ? new JDTClassNodeBuilder(this.resolver).configureTypeArguments(((ParameterizedTypeBinding)this.jdtBinding).arguments) : new JDTClassNodeBuilder(this.resolver).configureTypeVariables(this.jdtBinding.typeVariables()));
            this.setGenericsTypes(generics);
        }
    }

    @Override
    public void addProperty(PropertyNode node) {
        throw new UnsupportedOperationException("JDTClassNode is immutable, should not be called to add property: " + node.getName());
    }

    @Override
    public PropertyNode addProperty(String name, int modifiers, ClassNode type, Expression initialValueExpression, Statement getterBlock, Statement setterBlock) {
        throw new UnsupportedOperationException("JDTClassNode is immutable, should not be called to add property: " + name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PropertyNode> getProperties() {
        if ((this.bits & 4) == 0) {
            JDTClassNode jDTClassNode = this;
            synchronized (jDTClassNode) {
                if ((this.bits & 4) == 0) {
                    this.lazyClassInit();
                    if (this.groovyTypeDecl != null) {
                        List<PropertyNode> nodes = super.getProperties();
                        for (PropertyNode node : this.groovyTypeDecl.getClassNode().getProperties()) {
                            FieldNode field = this.getField(node.getName());
                            if (field == null) {
                                field = new FieldNode(node.getName(), 2 | node.getModifiers() & 8, this.resolver.resolve(node.getType().getName()), this, null);
                                field.setDeclaringClass(this);
                                field.setSourcePosition(node.getField());
                                field.setSynthetic(true);
                            } else if (Flags.isPackageDefault(field.getModifiers())) continue;
                            PropertyNode clone = new PropertyNode(field, node.getModifiers(), null, null);
                            clone.setDeclaringClass(this);
                            clone.setSourcePosition(node);
                            nodes.add(clone);
                        }
                    }
                    this.bits |= 4;
                }
            }
        }
        return Collections.unmodifiableList(super.getProperties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<InnerClassNode> getInnerClasses() {
        if ((this.bits & 2) == 0) {
            JDTClassNode jDTClassNode = this;
            synchronized (jDTClassNode) {
                if ((this.bits & 2) == 0) {
                    this.bits |= 2;
                    if (this.jdtBinding.hasMemberTypes()) {
                        if (this.jdtBinding instanceof BinaryTypeBinding && this.jdtBinding == this.jdtBinding.prototype() && this.isTrait()) {
                            Object[] memberTypes = (ReferenceBinding[])ReflectionUtils.getPrivateField(BinaryTypeBinding.class, "memberTypes", this.jdtBinding);
                            int i = 0;
                            while (i < memberTypes.length) {
                                if (String.valueOf(memberTypes[i].sourceName).endsWith("$Trait$FieldHelper$1")) {
                                    memberTypes = (ReferenceBinding[])ArrayUtils.remove(memberTypes, i--);
                                }
                                ++i;
                            }
                            ReflectionUtils.setPrivateField(BinaryTypeBinding.class, "memberTypes", this.jdtBinding, memberTypes);
                        }
                        Arrays.stream(this.jdtBinding.memberTypes()).map(this.resolver::convertToClassNode).forEach(cn -> {
                            InnerClassNode innerClassNode = new InnerClassNode(this, cn.getName(), cn.getModifiers(), cn.getSuperClass(), (ClassNode)cn){
                                {
                                    this.isPrimaryNode = false;
                                    this.setRedirect(classNode);
                                }
                            };
                        });
                    }
                }
            }
        }
        return (this.innerClasses == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(this.innerClasses)).iterator();
    }

    @Override
    public ClassNode getOuterClass() {
        if (this.jdtBinding.isNestedType()) {
            return this.resolver.convertToClassNode(this.jdtBinding.enclosingType());
        }
        return super.getOuterClass();
    }

    @Override
    public FieldNode getOuterField(String name) {
        return this.getOuterClass().getDeclaredField(name);
    }

    @Override
    public Class getTypeClass() {
        if (this.hasClass()) {
            return this.clazz;
        }
        throw new MissingClassException(this, "-- JDTClassNode.getTypeClass() cannot locate it using transform loader");
    }

    @Override
    public boolean hasClass() {
        GroovyClassLoader transformLoader;
        if (this.clazz == null && !this.unfindable && (transformLoader = this.resolver.compilationUnit.getTransformLoader()) != null) {
            try {
                this.clazz = Class.forName(this.getName(), false, transformLoader);
            }
            catch (LinkageError | ReflectiveOperationException e) {
                this.unfindable = true;
            }
        }
        return this.clazz != null;
    }

    public boolean isAnonymous() {
        return this.jdtBinding.isAnonymousType();
    }

    @Override
    public boolean isDeprecated() {
        return this.jdtBinding.isDeprecated();
    }

    @Override
    public boolean isResolved() {
        return true;
    }

    public boolean isTrait() {
        if (this.isTrait == null) {
            this.isTrait = this.isInterface() && !this.isAnnotationDefinition() && !CharOperation.equals(this.jdtBinding.compoundName[0], TypeConstants.JAVA) ? (this.groovyTypeDecl != null ? Boolean.valueOf(Traits.isTrait(this.groovyTypeDecl.getClassNode())) : Boolean.valueOf(Traits.isTrait(this))) : Boolean.FALSE;
        }
        return this.isTrait;
    }
}

