/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jdt.groovy.internal.compiler.ast;

import groovy.lang.GroovyClassLoader;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.jdt.groovy.control.EclipseSourceUnit;
import org.codehaus.jdt.groovy.integration.internal.GroovyLanguageSupport;
import org.codehaus.jdt.groovy.internal.compiler.GroovyClassLoaderFactory;
import org.codehaus.jdt.groovy.internal.compiler.ast.Grails20TestSupport;
import org.codehaus.jdt.groovy.internal.compiler.ast.GrailsGlobalPluginAwareEntityInjector;
import org.codehaus.jdt.groovy.internal.compiler.ast.GrailsInjector;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyCompilationUnitDeclaration;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyErrorCollectorForJDT;
import org.codehaus.jdt.groovy.internal.compiler.ast.GroovyTypeDeclaration;
import org.codehaus.jdt.groovy.internal.compiler.ast.IGroovyDebugRequestor;
import org.codehaus.jdt.groovy.internal.compiler.ast.JDTResolver;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.groovy.core.util.ScriptFolderSelector;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.batch.BatchCompilerRequestor;
import org.eclipse.jdt.internal.compiler.batch.Main;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.jdt.internal.core.builder.AbstractImageBuilder;
import org.eclipse.jdt.internal.core.builder.BuildNotifier;
import org.eclipse.jdt.internal.core.builder.SourceFile;

public class GroovyParser {
    public Object requestor;
    private JDTResolver resolver;
    public final ProblemReporter problemReporter;
    public static IGroovyDebugRequestor debugRequestor;
    private final GroovyClassLoaderFactory loaderFactory;
    private CompilationUnit compilationUnit;
    private CompilerOptions compilerOptions;
    private static Map<String, ScriptFolderSelector> scriptFolderSelectorCache;

    static {
        scriptFolderSelectorCache = new ConcurrentHashMap<String, ScriptFolderSelector>();
    }

    public CompilerOptions getCompilerOptions() {
        return this.compilerOptions;
    }

    public static void clearCache(String projectName) {
        scriptFolderSelectorCache.remove(projectName);
        GroovyClassLoaderFactory.clearCache(projectName);
    }

    public GroovyParser(CompilerOptions compilerOptions, ProblemReporter problemReporter, boolean allowTransforms, boolean isReconcile) {
        this(null, compilerOptions, problemReporter, allowTransforms, isReconcile);
    }

    public GroovyParser(Object requestor, CompilerOptions compilerOptions, ProblemReporter problemReporter, boolean allowTransforms, boolean isReconcile) {
        this.requestor = requestor;
        this.compilerOptions = compilerOptions;
        this.problemReporter = problemReporter;
        this.loaderFactory = new GroovyClassLoaderFactory(compilerOptions, requestor);
        this.compilationUnit = this.newCompilationUnit(isReconcile, allowTransforms);
    }

    public void reset() {
        this.compilationUnit = this.newCompilationUnit(this.compilationUnit.isReconcile, this.compilationUnit.allowTransforms);
    }

    private CompilationUnit newCompilationUnit(boolean isReconcile, boolean allowTransforms) {
        CompilerConfiguration compilerConfiguration = GroovyLanguageSupport.newCompilerConfiguration(this.compilerOptions, this.problemReporter);
        GroovyClassLoader[] classLoaders = this.loaderFactory.getGroovyClassLoaders(compilerConfiguration);
        CompilationUnit cu = new CompilationUnit(compilerConfiguration, null, classLoaders[0], classLoaders[1], allowTransforms, this.compilerOptions.groovyExcludeGlobalASTScan);
        this.resolver = new JDTResolver(cu);
        cu.removeOutputPhaseOperation();
        cu.setResolveVisitor(this.resolver);
        cu.tweak(isReconcile);
        if (allowTransforms && this.compilerOptions != null && (this.compilerOptions.groovyFlags & 1) != 0) {
            cu.addPhaseOperation(new GrailsInjector(classLoaders[1]), 5);
            new Grails20TestSupport(this.compilerOptions, classLoaders[1]).addGrailsTestCompilerCustomizers(cu);
            cu.addPhaseOperation(new GrailsGlobalPluginAwareEntityInjector(classLoaders[1]), 5);
        }
        return cu;
    }

    public CompilationUnitDeclaration dietParse(ICompilationUnit iCompilationUnit, CompilationResult compilationResult) {
        ScriptFolderSelector scriptFolderSelector;
        String projectName;
        char[] sourceCode;
        IPath location;
        String fileName = String.valueOf(iCompilationUnit.getFileName());
        Path filePath = new Path(fileName);
        IFile eclipseFile = null;
        if (filePath.segmentCount() > 1 && ResourcesPlugin.getPlugin() != null && (location = (eclipseFile = ResourcesPlugin.getWorkspace().getRoot().getFile(filePath)).getLocation()) != null) {
            fileName = location.toFile().getAbsolutePath();
        }
        if ((sourceCode = iCompilationUnit.getContents()) == null) {
            sourceCode = CharOperation.NO_CHAR;
        }
        EclipseSourceUnit sourceUnit = new EclipseSourceUnit(eclipseFile, fileName, String.valueOf(sourceCode), this.compilationUnit.isReconcile, this.compilationUnit.getConfiguration(), this.compilationUnit.getClassLoader(), new GroovyErrorCollectorForJDT(this.compilationUnit.getConfiguration()), this.resolver);
        this.compilationUnit.addSource(sourceUnit);
        if (this.requestor instanceof Compiler) {
            Main main;
            Compiler compiler = (Compiler)this.requestor;
            if (compiler.requestor instanceof AbstractImageBuilder) {
                SourceFile sourceFile;
                AbstractImageBuilder builder = (AbstractImageBuilder)compiler.requestor;
                if (builder.notifier != null) {
                    this.compilationUnit.setProgressListener(new ProgressListenerImpl(builder.notifier));
                }
                if (eclipseFile != null && (sourceFile = (SourceFile)builder.fromIFile(eclipseFile)) != null) {
                    this.compilationUnit.getConfiguration().setTargetDirectory(sourceFile.getOutputLocation().toFile());
                }
            } else if (compiler.requestor instanceof BatchCompilerRequestor && (main = (Main)ReflectionUtils.getPrivateField(BatchCompilerRequestor.class, "compiler", compiler.requestor)) != null && main.destinationPath != null && main.destinationPath != "none") {
                this.compilationUnit.getConfiguration().setTargetDirectory(main.destinationPath);
            }
        }
        compilationResult.lineSeparatorPositions = GroovyUtils.getSourceLineSeparatorsIn(sourceCode);
        GroovyCompilationUnitDeclaration gcuDeclaration = new GroovyCompilationUnitDeclaration(this.problemReporter, compilationResult, sourceCode.length, this.compilationUnit, sourceUnit, this.compilerOptions);
        gcuDeclaration.processToPhase(3);
        if (gcuDeclaration.getModuleNode() != null) {
            gcuDeclaration.populateCompilationUnitDeclaration();
            TypeDeclaration[] typeDeclarationArray = gcuDeclaration.types;
            int n = gcuDeclaration.types.length;
            int sourceFile = 0;
            while (sourceFile < n) {
                TypeDeclaration decl = typeDeclarationArray[sourceFile];
                this.resolver.record((GroovyTypeDeclaration)decl);
                ++sourceFile;
            }
        }
        if ((projectName = this.compilerOptions.groovyProjectName) != null && eclipseFile != null && (scriptFolderSelector = scriptFolderSelectorCache.computeIfAbsent(projectName, GroovyParser::newScriptFolderSelector)).isScript(eclipseFile)) {
            gcuDeclaration.tagAsScript();
        }
        if (debugRequestor != null) {
            debugRequestor.acceptCompilationUnitDeclaration(gcuDeclaration);
        }
        return gcuDeclaration;
    }

    private static ScriptFolderSelector newScriptFolderSelector(String projectName) {
        return new ScriptFolderSelector(ResourcesPlugin.getWorkspace().getRoot().getProject(projectName));
    }

    private static class ProgressListenerImpl
    implements CompilationUnit.ProgressListener {
        private BuildNotifier notifier;

        ProgressListenerImpl(BuildNotifier notifier) {
            this.notifier = notifier;
        }

        @Override
        public void parseComplete(int phase, String sourceUnitName) {
            try {
                int lastSlash = sourceUnitName.lastIndexOf("/");
                if (lastSlash == -1) {
                    lastSlash = sourceUnitName.lastIndexOf("\\");
                }
                if (lastSlash != -1) {
                    StringBuffer msg = new StringBuffer();
                    msg.append("Parsing groovy source in ");
                    msg.append(sourceUnitName, 0, lastSlash);
                    this.notifier.subTask(msg.toString());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.notifier.checkCancel();
        }

        @Override
        public void generateComplete(int phase, ClassNode classNode) {
            try {
                String pkgName = classNode.getPackageName();
                if (pkgName != null && pkgName.length() > 0) {
                    StringBuffer msg = new StringBuffer();
                    msg.append("Generating groovy classes in ");
                    msg.append(pkgName);
                    this.notifier.subTask(msg.toString());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.notifier.checkCancel();
        }
    }
}

