/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.ast.tools;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.apache.groovy.ast.tools.ClassNodeUtils;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.NumberMath;

public class ExpressionUtils {
    private static final int[] HANDLED_TYPES = new int[]{200, 201, 202, 203, 206, 280, 281, 282, 340, 341, 342};

    static {
        Arrays.sort(HANDLED_TYPES);
    }

    private ExpressionUtils() {
    }

    public static ConstantExpression transformBinaryConstantExpression(BinaryExpression be, ClassNode targetType) {
        int type;
        ClassNode wrapperType = ClassHelper.getWrapper(targetType);
        if (ExpressionUtils.isTypeOrArrayOfType(targetType, ClassHelper.STRING_TYPE, false)) {
            if (be.getOperation().getType() == 200) {
                Expression left = ExpressionUtils.transformInlineConstants(be.getLeftExpression(), targetType);
                Expression right = ExpressionUtils.transformInlineConstants(be.getRightExpression(), targetType);
                if (left instanceof ConstantExpression && right instanceof ConstantExpression) {
                    return ExpressionUtils.configure(be, new ConstantExpression(String.valueOf((String)((ConstantExpression)left).getValue()) + ((ConstantExpression)right).getValue()));
                }
            }
        } else if (ExpressionUtils.isNumberOrArrayOfNumber(wrapperType, false) && Arrays.binarySearch(HANDLED_TYPES, type = be.getOperation().getType()) >= 0) {
            boolean isShift = type >= 280 && type <= 282;
            Expression leftX = ExpressionUtils.transformInlineConstants(be.getLeftExpression(), targetType);
            Expression rightX = ExpressionUtils.transformInlineConstants(be.getRightExpression(), isShift ? ClassHelper.int_TYPE : targetType);
            if (leftX instanceof ConstantExpression && rightX instanceof ConstantExpression) {
                Number left = ExpressionUtils.safeNumber((ConstantExpression)leftX);
                Number right = ExpressionUtils.safeNumber((ConstantExpression)rightX);
                if (left == null || right == null) {
                    return null;
                }
                Number result = null;
                switch (type) {
                    case 200: {
                        result = NumberMath.add(left, right);
                        break;
                    }
                    case 201: {
                        result = NumberMath.subtract(left, right);
                        break;
                    }
                    case 202: {
                        result = NumberMath.multiply(left, right);
                        break;
                    }
                    case 203: {
                        result = NumberMath.divide(left, right);
                        break;
                    }
                    case 280: {
                        result = NumberMath.leftShift(left, right);
                        break;
                    }
                    case 281: {
                        result = NumberMath.rightShift(left, right);
                        break;
                    }
                    case 282: {
                        result = NumberMath.rightShiftUnsigned(left, right);
                        break;
                    }
                    case 341: {
                        result = NumberMath.and(left, right);
                        break;
                    }
                    case 340: {
                        result = NumberMath.or(left, right);
                        break;
                    }
                    case 342: {
                        result = NumberMath.xor(left, right);
                        break;
                    }
                    case 206: {
                        result = DefaultGroovyMethods.power(left, right);
                    }
                }
                if (result != null) {
                    if (ClassHelper.Byte_TYPE.equals(wrapperType)) {
                        return ExpressionUtils.configure(be, new ConstantExpression(result.byteValue(), true));
                    }
                    if (ClassHelper.Short_TYPE.equals(wrapperType)) {
                        return ExpressionUtils.configure(be, new ConstantExpression(result.shortValue(), true));
                    }
                    if (ClassHelper.Long_TYPE.equals(wrapperType)) {
                        return ExpressionUtils.configure(be, new ConstantExpression(result.longValue(), true));
                    }
                    if (ClassHelper.Integer_TYPE.equals(wrapperType) || ClassHelper.Character_TYPE.equals(wrapperType)) {
                        return ExpressionUtils.configure(be, new ConstantExpression(result.intValue(), true));
                    }
                    if (ClassHelper.Float_TYPE.equals(wrapperType)) {
                        return ExpressionUtils.configure(be, new ConstantExpression(Float.valueOf(result.floatValue()), true));
                    }
                    if (ClassHelper.Double_TYPE.equals(wrapperType)) {
                        return ExpressionUtils.configure(be, new ConstantExpression(result.doubleValue(), true));
                    }
                    return ExpressionUtils.configure(be, new ConstantExpression(result, true));
                }
            }
        }
        return null;
    }

    private static Number safeNumber(ConstantExpression constX) {
        Object value = constX.getValue();
        if (value instanceof Number) {
            return (Number)value;
        }
        return null;
    }

    private static Expression clone(ConstantExpression constX, Expression origX) {
        ConstantExpression newX = new ConstantExpression(constX.getValue());
        ExpressionUtils.configure(origX, newX);
        return newX;
    }

    private static ConstantExpression configure(Expression origX, ConstantExpression newX) {
        newX.setNodeMetaData("OriginalExpression", origX);
        return newX;
    }

    public static boolean isTypeOrArrayOfType(ClassNode targetType, ClassNode type, boolean recurse) {
        if (targetType == null) {
            return false;
        }
        return type.equals(targetType) || !(targetType.isArray() && recurse ? !ExpressionUtils.isTypeOrArrayOfType(targetType.getComponentType(), type, recurse) : !type.equals(targetType.getComponentType()));
    }

    public static boolean isNumberOrArrayOfNumber(ClassNode targetType, boolean recurse) {
        if (targetType == null) {
            return false;
        }
        return targetType.isDerivedFrom(ClassHelper.Number_TYPE) || !(targetType.isArray() && recurse ? !ExpressionUtils.isNumberOrArrayOfNumber(targetType.getComponentType(), recurse) : !targetType.isArray() || !targetType.getComponentType().isDerivedFrom(ClassHelper.Number_TYPE));
    }

    public static Expression transformInlineConstants(Expression exp, ClassNode attrType) {
        if (exp instanceof PropertyExpression) {
            PropertyExpression pe = (PropertyExpression)exp;
            if (pe.getObjectExpression() instanceof ClassExpression) {
                ClassExpression ce = (ClassExpression)pe.getObjectExpression();
                ClassNode type = ce.getType();
                if (type.isEnum() || !type.isResolved() && !type.isPrimaryClassNode()) {
                    return exp;
                }
                if (type.isPrimaryClassNode()) {
                    FieldNode fn = type.redirect().getField(pe.getPropertyAsString());
                    if (fn != null && fn.isStatic() && fn.isFinal()) {
                        Expression ce2 = ExpressionUtils.transformInlineConstants(fn.getInitialValueExpression(), attrType);
                        if (ce2 instanceof ConstantExpression) {
                            return ExpressionUtils.clone((ConstantExpression)ce2, exp);
                        }
                        if (ce2 != null) {
                            return ce2;
                        }
                    }
                } else {
                    try {
                        Field field = type.redirect().getTypeClass().getField(pe.getPropertyAsString());
                        if (field != null && Modifier.isStatic(field.getModifiers()) && Modifier.isFinal(field.getModifiers())) {
                            ConstantExpression ce3 = new ConstantExpression(field.get(null), true);
                            ExpressionUtils.configure(exp, ce3);
                            return ce3;
                        }
                    }
                    catch (Exception exception) {}
                }
            }
        } else if (exp instanceof BinaryExpression) {
            ConstantExpression ce = ExpressionUtils.transformBinaryConstantExpression((BinaryExpression)exp, attrType);
            if (ce != null) {
                return ce;
            }
        } else if (exp instanceof VariableExpression) {
            FieldNode fn;
            VariableExpression ve = (VariableExpression)exp;
            if (ve.getAccessedVariable() instanceof FieldNode && (fn = (FieldNode)ve.getAccessedVariable()).isStatic() && fn.isFinal()) {
                Expression ce = ExpressionUtils.transformInlineConstants(fn.getInitialValueExpression(), attrType);
                if (ce instanceof ConstantExpression) {
                    return ExpressionUtils.clone((ConstantExpression)ce, exp);
                }
                if (ce != null) {
                    return ce;
                }
            }
        } else if (exp instanceof ListExpression) {
            return ExpressionUtils.transformListOfConstants((ListExpression)exp, attrType);
        }
        return exp;
    }

    public static Expression transformListOfConstants(ListExpression origList, ClassNode attrType) {
        ListExpression newList = new ListExpression();
        boolean changed = false;
        for (Expression e : origList.getExpressions()) {
            try {
                Expression transformed = ExpressionUtils.transformInlineConstants(e, attrType);
                newList.addExpression(transformed);
                if (transformed == e) continue;
                changed = true;
            }
            catch (Exception ignored) {
                newList.addExpression(e);
            }
        }
        if (changed) {
            newList.setSourcePosition(origList);
            return newList;
        }
        return origList;
    }

    public static Expression transformInlineConstants(Expression exp) {
        if (exp instanceof PropertyExpression) {
            PropertyExpression pe = (PropertyExpression)exp;
            if (pe.getObjectExpression() instanceof ClassExpression) {
                ClassExpression ce = (ClassExpression)pe.getObjectExpression();
                ClassNode type = ce.getType();
                FieldNode field = ClassNodeUtils.getField(type, pe.getPropertyAsString());
                if (type.isEnum() && field != null && field.isEnum()) {
                    return exp;
                }
                Expression constant = ExpressionUtils.findConstant(field);
                if (constant instanceof ConstantExpression) {
                    return ExpressionUtils.clone((ConstantExpression)constant, exp);
                }
            }
        } else {
            if (exp instanceof BinaryExpression) {
                BinaryExpression be = (BinaryExpression)exp;
                be.setLeftExpression(ExpressionUtils.transformInlineConstants(be.getLeftExpression()));
                be.setRightExpression(ExpressionUtils.transformInlineConstants(be.getRightExpression()));
                return be;
            }
            if (exp instanceof ListExpression) {
                ListExpression origList = (ListExpression)exp;
                ListExpression newList = new ListExpression();
                boolean changed = false;
                for (Expression e : origList.getExpressions()) {
                    Expression transformed = ExpressionUtils.transformInlineConstants(e);
                    newList.addExpression(transformed);
                    if (transformed == e) continue;
                    changed = true;
                }
                if (changed) {
                    newList.setSourcePosition(origList);
                    return newList;
                }
                return origList;
            }
        }
        return exp;
    }

    private static Expression findConstant(FieldNode fn) {
        if (fn != null && !fn.isEnum() && fn.isStatic() && fn.isFinal() && fn.getInitialValueExpression() instanceof ConstantExpression) {
            return fn.getInitialValueExpression();
        }
        return null;
    }
}

