/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.exec;

import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.artifact.MavenMetadataSource;
import org.codehaus.mojo.exec.AbstractExecMojo;
import org.codehaus.mojo.exec.ExecutableDependency;
import org.codehaus.mojo.exec.Property;

public class ExecJavaMojo
extends AbstractExecMojo {
    private ArtifactResolver artifactResolver;
    private ArtifactFactory artifactFactory;
    private ArtifactMetadataSource metadataSource;
    private ArtifactRepository localRepository;
    private List remoteRepositories;
    private MavenProjectBuilder projectBuilder;
    private List pluginDependencies;
    private String mainClass;
    private String[] arguments;
    private Property[] systemProperties;
    private boolean keepAlive;
    private boolean includeProjectDependencies;
    private boolean includePluginDependencies;
    private ExecutableDependency executableDependency;
    private boolean cleanupDaemonThreads;
    private long daemonThreadJoinTimeout;
    private boolean stopUnresponsiveDaemonThreads;
    private long killAfter;
    private Properties originalSystemProperties;
    static /* synthetic */ Class array$Ljava$lang$String;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isSkip()) {
            this.getLog().info((CharSequence)"skipping execute as per configuration");
            return;
        }
        if (this.killAfter != -1L) {
            this.getLog().warn((CharSequence)"Warning: killAfter is now deprecated. Do you need it ? Please comment on MEXEC-6.");
        }
        if (null == this.arguments) {
            this.arguments = new String[0];
        }
        if (this.getLog().isDebugEnabled()) {
            StringBuffer msg = new StringBuffer("Invoking : ");
            msg.append(this.mainClass);
            msg.append(".main(");
            for (int i = 0; i < this.arguments.length; ++i) {
                if (i > 0) {
                    msg.append(", ");
                }
                msg.append(this.arguments[i]);
            }
            msg.append(")");
            this.getLog().debug((CharSequence)msg);
        }
        IsolatedThreadGroup threadGroup = new IsolatedThreadGroup(this.mainClass);
        Thread bootstrapThread = new Thread(threadGroup, new Runnable(){

            public void run() {
                try {
                    Method main = Thread.currentThread().getContextClassLoader().loadClass(ExecJavaMojo.this.mainClass).getMethod("main", array$Ljava$lang$String == null ? (array$Ljava$lang$String = ExecJavaMojo.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
                    if (!main.isAccessible()) {
                        ExecJavaMojo.this.getLog().debug((CharSequence)"Setting accessibility to true in order to invoke main().");
                        main.setAccessible(true);
                    }
                    if (!Modifier.isStatic(main.getModifiers())) {
                        throw new MojoExecutionException("Can't call main(String[])-method because it is not static.");
                    }
                    main.invoke(null, new Object[]{ExecJavaMojo.this.arguments});
                }
                catch (NoSuchMethodException e) {
                    Thread.currentThread().getThreadGroup().uncaughtException(Thread.currentThread(), new Exception("The specified mainClass doesn't contain a main method with appropriate signature.", e));
                }
                catch (Exception e) {
                    Thread.currentThread().getThreadGroup().uncaughtException(Thread.currentThread(), e);
                }
            }
        }, this.mainClass + ".main()");
        bootstrapThread.setContextClassLoader(this.getClassLoader());
        this.setSystemProperties();
        bootstrapThread.start();
        this.joinNonDaemonThreads(threadGroup);
        if (this.keepAlive) {
            this.getLog().warn((CharSequence)"Warning: keepAlive is now deprecated and obsolete. Do you need it? Please comment on MEXEC-6.");
            this.waitFor(0L);
        }
        if (this.cleanupDaemonThreads) {
            this.terminateThreads(threadGroup);
            try {
                threadGroup.destroy();
            }
            catch (IllegalThreadStateException e) {
                this.getLog().warn((CharSequence)("Couldn't destroy threadgroup " + threadGroup), (Throwable)e);
            }
        }
        if (this.originalSystemProperties != null) {
            System.setProperties(this.originalSystemProperties);
        }
        IsolatedThreadGroup isolatedThreadGroup = threadGroup;
        synchronized (isolatedThreadGroup) {
            if (threadGroup.uncaughtException != null) {
                throw new MojoExecutionException("An exception occurred while executing the Java class. " + threadGroup.uncaughtException.getMessage(), threadGroup.uncaughtException);
            }
        }
        this.registerSourceRoots();
    }

    private void joinNonDaemonThreads(ThreadGroup threadGroup) {
        boolean foundNonDaemon;
        do {
            foundNonDaemon = false;
            Collection threads = this.getActiveThreads(threadGroup);
            Iterator iter = threads.iterator();
            while (iter.hasNext()) {
                Thread thread = (Thread)iter.next();
                if (thread.isDaemon()) continue;
                foundNonDaemon = true;
                this.joinThread(thread, 0L);
            }
        } while (foundNonDaemon);
    }

    private void joinThread(Thread thread, long timeoutMsecs) {
        try {
            this.getLog().debug((CharSequence)("joining on thread " + thread));
            thread.join(timeoutMsecs);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.getLog().warn((CharSequence)("interrupted while joining against thread " + thread), (Throwable)e);
        }
        if (thread.isAlive()) {
            this.getLog().warn((CharSequence)("thread " + thread + " was interrupted but is still alive after waiting at least " + timeoutMsecs + "msecs"));
        }
    }

    private void terminateThreads(ThreadGroup threadGroup) {
        long startTime = System.currentTimeMillis();
        HashSet<Thread> uncooperativeThreads = new HashSet<Thread>();
        Collection threads = this.getActiveThreads(threadGroup);
        while (!threads.isEmpty()) {
            Thread thread;
            Iterator iter = threads.iterator();
            while (iter.hasNext()) {
                thread = (Thread)iter.next();
                this.getLog().debug((CharSequence)("interrupting thread " + thread));
                thread.interrupt();
            }
            iter = threads.iterator();
            while (iter.hasNext()) {
                thread = (Thread)iter.next();
                if (!thread.isAlive()) continue;
                if (this.daemonThreadJoinTimeout <= 0L) {
                    this.joinThread(thread, 0L);
                    continue;
                }
                long timeout = this.daemonThreadJoinTimeout - (System.currentTimeMillis() - startTime);
                if (timeout > 0L) {
                    this.joinThread(thread, timeout);
                }
                if (!thread.isAlive()) continue;
                uncooperativeThreads.add(thread);
                if (this.stopUnresponsiveDaemonThreads) {
                    this.getLog().warn((CharSequence)("thread " + thread + " will be Thread.stop()'ed"));
                    thread.stop();
                    continue;
                }
                this.getLog().warn((CharSequence)("thread " + thread + " will linger despite being asked to die via interruption"));
            }
            threads = this.getActiveThreads(threadGroup);
            threads.removeAll(uncooperativeThreads);
        }
        if (!uncooperativeThreads.isEmpty()) {
            this.getLog().warn((CharSequence)("NOTE: " + uncooperativeThreads.size() + " thread(s) did not finish despite being asked to " + " via interruption. This is not a problem with exec:java, it is a problem with the running code." + " Although not serious, it should be remedied."));
        } else {
            int activeCount = threadGroup.activeCount();
            if (activeCount != 0) {
                Thread[] threadsArray = new Thread[1];
                threadGroup.enumerate(threadsArray);
                this.getLog().debug((CharSequence)("strange; " + activeCount + " thread(s) still active in the group " + threadGroup + " such as " + threadsArray[0]));
            }
        }
    }

    private Collection getActiveThreads(ThreadGroup threadGroup) {
        Thread[] threads = new Thread[threadGroup.activeCount()];
        int numThreads = threadGroup.enumerate(threads);
        ArrayList<Thread> result = new ArrayList<Thread>(numThreads);
        for (int i = 0; i < threads.length && threads[i] != null; ++i) {
            result.add(threads[i]);
        }
        return result;
    }

    private void setSystemProperties() {
        if (this.systemProperties != null) {
            this.originalSystemProperties = System.getProperties();
            for (int i = 0; i < this.systemProperties.length; ++i) {
                Property systemProperty = this.systemProperties[i];
                String value = systemProperty.getValue();
                System.setProperty(systemProperty.getKey(), value == null ? "" : value);
            }
        }
    }

    private ClassLoader getClassLoader() throws MojoExecutionException {
        ArrayList classpathURLs = new ArrayList();
        this.addRelevantPluginDependenciesToClasspath(classpathURLs);
        this.addRelevantProjectDependenciesToClasspath(classpathURLs);
        return new URLClassLoader(classpathURLs.toArray(new URL[classpathURLs.size()]));
    }

    private void addRelevantPluginDependenciesToClasspath(List path) throws MojoExecutionException {
        if (this.hasCommandlineArgs()) {
            this.arguments = this.parseCommandlineArgs();
        }
        try {
            Iterator iter = this.determineRelevantPluginDependencies().iterator();
            while (iter.hasNext()) {
                Artifact classPathElement = (Artifact)iter.next();
                this.getLog().debug((CharSequence)("Adding plugin dependency artifact: " + classPathElement.getArtifactId() + " to classpath"));
                path.add(classPathElement.getFile().toURI().toURL());
            }
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Error during setting up classpath", (Exception)e);
        }
    }

    private void addRelevantProjectDependenciesToClasspath(List path) throws MojoExecutionException {
        if (this.includeProjectDependencies) {
            try {
                this.getLog().debug((CharSequence)"Project Dependencies will be included.");
                ArrayList artifacts = new ArrayList();
                ArrayList theClasspathFiles = new ArrayList();
                this.collectProjectArtifactsAndClasspath(artifacts, theClasspathFiles);
                Iterator it = theClasspathFiles.iterator();
                while (it.hasNext()) {
                    URL url = ((File)it.next()).toURI().toURL();
                    this.getLog().debug((CharSequence)("Adding to classpath : " + url));
                    path.add(url);
                }
                Iterator iter = artifacts.iterator();
                while (iter.hasNext()) {
                    Artifact classPathElement = (Artifact)iter.next();
                    this.getLog().debug((CharSequence)("Adding project dependency artifact: " + classPathElement.getArtifactId() + " to classpath"));
                    path.add(classPathElement.getFile().toURI().toURL());
                }
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException("Error during setting up classpath", (Exception)e);
            }
        } else {
            this.getLog().debug((CharSequence)"Project Dependencies will be excluded.");
        }
    }

    private Set determineRelevantPluginDependencies() throws MojoExecutionException {
        Set relevantDependencies;
        if (this.includePluginDependencies) {
            if (this.executableDependency == null) {
                this.getLog().debug((CharSequence)"All Plugin Dependencies will be included.");
                relevantDependencies = new HashSet(this.pluginDependencies);
            } else {
                this.getLog().debug((CharSequence)"Selected plugin Dependencies will be included.");
                Artifact executableArtifact = this.findExecutableArtifact();
                Artifact executablePomArtifact = this.getExecutablePomArtifact(executableArtifact);
                relevantDependencies = this.resolveExecutableDependencies(executablePomArtifact);
            }
        } else {
            relevantDependencies = Collections.EMPTY_SET;
            this.getLog().debug((CharSequence)"Plugin Dependencies will be excluded.");
        }
        return relevantDependencies;
    }

    private Artifact getExecutablePomArtifact(Artifact executableArtifact) {
        return this.artifactFactory.createBuildArtifact(executableArtifact.getGroupId(), executableArtifact.getArtifactId(), executableArtifact.getVersion(), "pom");
    }

    private Artifact findExecutableArtifact() throws MojoExecutionException {
        Artifact executableTool = null;
        Iterator iter = this.pluginDependencies.iterator();
        while (iter.hasNext()) {
            Artifact pluginDep = (Artifact)iter.next();
            if (!this.executableDependency.matches(pluginDep)) continue;
            executableTool = pluginDep;
            break;
        }
        if (executableTool == null) {
            throw new MojoExecutionException("No dependency of the plugin matches the specified executableDependency.  Specified executableToolAssembly is: " + this.executableDependency.toString());
        }
        return executableTool;
    }

    private Set resolveExecutableDependencies(Artifact executablePomArtifact) throws MojoExecutionException {
        Set executableDependencies;
        try {
            MavenProject executableProject = this.projectBuilder.buildFromRepository(executablePomArtifact, this.remoteRepositories, this.localRepository);
            List dependencies = executableProject.getDependencies();
            Set dependencyArtifacts = MavenMetadataSource.createArtifacts((ArtifactFactory)this.artifactFactory, (List)dependencies, null, null, null);
            dependencyArtifacts.add(executableProject.getArtifact());
            ArtifactResolutionResult result = this.artifactResolver.resolveTransitively(dependencyArtifacts, executablePomArtifact, Collections.EMPTY_MAP, this.localRepository, this.remoteRepositories, this.metadataSource, null, Collections.EMPTY_LIST);
            executableDependencies = result.getArtifacts();
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Encountered problems resolving dependencies of the executable in preparation for its execution.", ex);
        }
        return executableDependencies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitFor(long millis) {
        Object lock;
        Object object = lock = new Object();
        synchronized (object) {
            try {
                lock.wait(millis);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.getLog().warn((CharSequence)("Spuriously interrupted while waiting for " + millis + "ms"), (Throwable)e);
            }
        }
    }

    class IsolatedThreadGroup
    extends ThreadGroup {
        private Throwable uncaughtException;

        public IsolatedThreadGroup(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void uncaughtException(Thread thread, Throwable throwable) {
            if (throwable instanceof ThreadDeath) {
                return;
            }
            IsolatedThreadGroup isolatedThreadGroup = this;
            synchronized (isolatedThreadGroup) {
                if (this.uncaughtException == null) {
                    this.uncaughtException = throwable;
                }
            }
            ExecJavaMojo.this.getLog().warn(throwable);
        }
    }
}

