/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.flatten.model.resolution;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Repository;
import org.apache.maven.model.building.FileModelSource;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.model.resolution.UnresolvableModelException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.artifact.resolve.ArtifactResult;
import org.apache.maven.shared.dependencies.resolve.DependencyResolver;
import org.apache.maven.shared.dependencies.resolve.DependencyResolverException;
import org.codehaus.mojo.flatten.model.resolution.ReactorModelPool;

public class FlattenModelResolver
implements ModelResolver {
    private ArtifactRepository localRepository;
    private ArtifactFactory artifactFactory;
    private DependencyResolver depencencyResolver;
    private ProjectBuildingRequest projectBuildingRequest;
    private ReactorModelPool reactorModelPool;

    public FlattenModelResolver(ArtifactRepository localRepository, ArtifactFactory artifactFactory, DependencyResolver dependencyResolver, ProjectBuildingRequest projectBuildingRequest, List<MavenProject> reactorModels) {
        this.localRepository = localRepository;
        this.artifactFactory = artifactFactory;
        this.depencencyResolver = dependencyResolver;
        this.projectBuildingRequest = projectBuildingRequest;
        this.reactorModelPool = new ReactorModelPool();
        this.reactorModelPool.addProjects(reactorModels);
    }

    private FlattenModelResolver(FlattenModelResolver other) {
        this.localRepository = other.localRepository;
        this.artifactFactory = other.artifactFactory;
        this.depencencyResolver = other.depencencyResolver;
        this.projectBuildingRequest = other.projectBuildingRequest;
        this.reactorModelPool = other.reactorModelPool;
    }

    public ModelSource resolveModel(String groupId, String artifactId, String version) {
        File pomFile = this.reactorModelPool.find(groupId, artifactId, version);
        if (pomFile == null) {
            Artifact pomArtifact = this.artifactFactory.createProjectArtifact(groupId, artifactId, version);
            pomArtifact = this.localRepository.find(pomArtifact);
            pomFile = pomArtifact.getFile();
        }
        return new FileModelSource(pomFile);
    }

    public void addRepository(Repository repository) {
    }

    public ModelResolver newCopy() {
        return new FlattenModelResolver(this);
    }

    public ModelSource resolveModel(Parent parent) throws UnresolvableModelException {
        String groupId = parent.getGroupId();
        String artifactId = parent.getArtifactId();
        String version = parent.getVersion();
        if (FlattenModelResolver.isRestrictedVersionRange(version, groupId, artifactId)) {
            version = this.resolveParentVersionRange(groupId, artifactId, version);
        }
        return this.resolveModel(groupId, artifactId, version);
    }

    private static boolean isRestrictedVersionRange(String version, String groupId, String artifactId) throws UnresolvableModelException {
        try {
            return VersionRange.createFromVersionSpec((String)version).hasRestrictions();
        }
        catch (InvalidVersionSpecificationException e) {
            throw new UnresolvableModelException(e.getMessage(), groupId, artifactId, version, (Throwable)e);
        }
    }

    private String resolveParentVersionRange(String groupId, String artifactId, String version) throws UnresolvableModelException {
        Dependency parentDependency = new Dependency();
        parentDependency.setGroupId(groupId);
        parentDependency.setArtifactId(artifactId);
        parentDependency.setVersion(version);
        parentDependency.setClassifier("");
        parentDependency.setType("pom");
        try {
            Iterable artifactResults = this.depencencyResolver.resolveDependencies(this.projectBuildingRequest, Collections.singleton(parentDependency), null, null);
            return ((ArtifactResult)artifactResults.iterator().next()).getArtifact().getVersion();
        }
        catch (DependencyResolverException e) {
            throw new UnresolvableModelException(e.getMessage(), groupId, artifactId, version, (Throwable)e);
        }
    }

    public ModelSource resolveModel(Dependency dependency) throws UnresolvableModelException {
        return this.resolveModel(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion());
    }

    public void resetRepositories() {
    }

    public void addRepository(Repository repository, boolean replace) {
    }
}

