/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.TransformerException;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.wagon.Wagon;
import org.codehaus.mojo.versions.AbstractVersionsDisplayMojo;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.VersionRetrievalException;
import org.codehaus.mojo.versions.api.internal.DefaultResolverAdapter;
import org.codehaus.mojo.versions.api.recording.ChangeRecorder;
import org.codehaus.mojo.versions.filtering.DependencyFilter;
import org.codehaus.mojo.versions.internal.DependencyUpdatesLoggingHelper;
import org.codehaus.mojo.versions.rewriting.MutableXMLStreamReader;
import org.codehaus.mojo.versions.rule.RuleService;
import org.codehaus.mojo.versions.rule.RulesServiceBuilder;
import org.codehaus.mojo.versions.utils.ArtifactFactory;
import org.codehaus.mojo.versions.utils.DependencyBuilder;
import org.codehaus.mojo.versions.utils.DependencyComparator;
import org.codehaus.mojo.versions.utils.ExtensionUtils;
import org.codehaus.mojo.versions.utils.SegmentUtils;
import org.eclipse.aether.RepositorySystem;

@Mojo(name="display-extension-updates", aggregator=true, threadSafe=true)
public class DisplayExtensionUpdatesMojo
extends AbstractVersionsDisplayMojo {
    @Parameter(property="extensionIncludes", defaultValue="*")
    private List<String> extensionIncludes;
    @Parameter(property="extensionExcludes")
    private List<String> extensionExcludes;
    @Parameter(property="allowMajorUpdates", defaultValue="true")
    private boolean allowMajorUpdates = true;
    @Parameter(property="allowMinorUpdates", defaultValue="true")
    private boolean allowMinorUpdates = true;
    @Parameter(property="allowIncrementalUpdates", defaultValue="true")
    private boolean allowIncrementalUpdates = true;
    @Parameter(property="processCoreExtensions", defaultValue="true")
    private boolean processCoreExtensions = true;
    @Parameter(property="processBuildExtensions", defaultValue="true")
    private boolean processBuildExtensions = true;
    @Parameter(property="interpolateProperties", defaultValue="true")
    protected boolean interpolateProperties = true;
    @Parameter(property="verbose", defaultValue="false")
    private boolean verbose;
    @Parameter(property="allowSnapshots", defaultValue="false")
    protected boolean allowSnapshots;

    @Inject
    public DisplayExtensionUpdatesMojo(ArtifactFactory artifactFactory, RepositorySystem repositorySystem, Map<String, Wagon> wagonMap, Map<String, ChangeRecorder> changeRecorders) throws MojoExecutionException {
        super(artifactFactory, repositorySystem, wagonMap, changeRecorders);
    }

    @Override
    protected boolean getAllowSnapshots() {
        return this.allowSnapshots;
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping execution");
            return;
        }
        this.logInit();
        this.validateInput();
        if (!this.processCoreExtensions && !this.processBuildExtensions) {
            this.getLog().info((CharSequence)"Neither core nor build extensions are to be processed. Nothing to do.");
            return;
        }
        DependencyFilter includeFilter = DependencyFilter.parseFrom(this.extensionIncludes);
        DependencyFilter excludeFilter = DependencyFilter.parseFrom(this.extensionExcludes);
        DefaultResolverAdapter resolverAdapter = new DefaultResolverAdapter(this.artifactFactory, this.repositorySystem, this.getLog(), this.session);
        RuleService ruleService = new RulesServiceBuilder().withMavenSession(this.session).withWagonMap(this.wagonMap).withServerId(this.serverId).withRulesUri(this.rulesUri).withRuleSet(this.ruleSet).withIgnoredVersions((Collection)this.ignoredVersions).withLog(this.getLog()).build();
        Optional unchangedSegment = SegmentUtils.determineUnchangedSegment((boolean)this.allowMajorUpdates, (boolean)this.allowMinorUpdates, (boolean)this.allowIncrementalUpdates, (Log)this.getLog());
        DependencyUpdatesLoggingHelper loggingHelper = new DependencyUpdatesLoggingHelper(this.getProject(), this.getLog(), this.artifactFactory, ruleService, unchangedSegment, this.allowSnapshots, 72 + this.getOutputLineWidthOffset(), this.verbose);
        try {
            Stream coreExtensions = this.processCoreExtensions ? ExtensionUtils.getCoreExtensions((MavenProject)this.project) : Stream.empty();
            Stream buildExtensions = this.processBuildExtensions ? ExtensionUtils.getBuildExtensions((MavenProject)this.getProject(), (Log)this.getLog(), (boolean)this.interpolateProperties) : Stream.empty();
            Collection dependencies = Stream.concat(coreExtensions, buildExtensions).map(e -> DependencyBuilder.newBuilder().withGroupId(e.getGroupId()).withArtifactId(e.getArtifactId()).withVersion(e.getVersion()).build()).filter(arg_0 -> ((DependencyFilter)includeFilter).matchersMatch(arg_0)).filter(dependency -> !excludeFilter.matchersMatch(dependency)).collect(Collectors.toSet());
            if (dependencies.isEmpty()) {
                this.getLog().info((CharSequence)"Extensions set filtered by include- and exclude-filters is empty. Nothing to do.");
                return;
            }
            SortedMap versionMap = resolverAdapter.resolveDependencyVersions(dependencies, true, true);
            if (!this.allowSnapshots) {
                versionMap = versionMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new ArtifactVersions((ArtifactVersions)e.getValue()).filter(v -> !ArtifactUtils.isSnapshot((String)v)), (v1, v2) -> v1, () -> new TreeMap(DependencyComparator.INSTANCE)));
            }
            this.logUpdates(loggingHelper, versionMap);
        }
        catch (IOException | XMLStreamException | TransformerException e2) {
            throw new MojoExecutionException(e2.getMessage());
        }
        catch (VersionRetrievalException e3) {
            throw new MojoExecutionException(e3.getMessage(), (Exception)((Object)e3));
        }
    }

    private void logUpdates(DependencyUpdatesLoggingHelper loggingHelper, SortedMap<Dependency, ArtifactVersions> versionMap) {
        DependencyUpdatesLoggingHelper.DependencyUpdatesResult updates = loggingHelper.getDependencyUpdates(versionMap);
        if (this.verbose) {
            if (updates.getUsingLatest().isEmpty()) {
                if (!updates.getWithUpdates().isEmpty()) {
                    this.logLine(false, "No extensions are using the newest version.");
                    this.logLine(false, "");
                }
            } else {
                this.logLine(false, "The following extensions are using the newest version:");
                updates.getUsingLatest().forEach(s -> this.logLine(false, (String)s));
                this.logLine(false, "");
            }
        }
        if (updates.getWithUpdates().isEmpty()) {
            if (!updates.getUsingLatest().isEmpty()) {
                this.logLine(false, "No extensions have newer versions.");
                this.logLine(false, "");
            }
        } else {
            this.logLine(false, "The following extensions have newer versions:");
            updates.getWithUpdates().forEach(s -> this.logLine(false, (String)s));
            this.logLine(false, "");
        }
    }

    @Override
    protected void update(MutableXMLStreamReader pom) {
    }
}

