/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.components.io.resources;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.codehaus.plexus.components.io.attributes.PlexusIoResourceAttributes;
import org.codehaus.plexus.components.io.functions.InputStreamSupplier;
import org.codehaus.plexus.components.io.functions.InputStreamTransformer;
import org.codehaus.plexus.components.io.resources.AbstractPlexusIoResourceCollection;
import org.codehaus.plexus.components.io.resources.ClosingInputStream;
import org.codehaus.plexus.components.io.resources.Deferred;
import org.codehaus.plexus.components.io.resources.PlexusIoArchivedResourceCollection;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;
import org.codehaus.plexus.components.io.resources.ResourceFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PlexusIoCompressedFileResourceCollection
implements PlexusIoArchivedResourceCollection,
Iterable<PlexusIoResource> {
    private File file;
    private String path;
    private InputStreamTransformer streamTransformers = AbstractPlexusIoResourceCollection.identityTransformer;

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public void setFile(File file) {
        this.file = file;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    protected abstract PlexusIoResourceAttributes getAttributes(File var1) throws IOException;

    public void setStreamTransformer(InputStreamTransformer streamTransformers) {
        this.streamTransformers = streamTransformers;
    }

    @Override
    public Iterator<PlexusIoResource> getResources() throws IOException {
        final File f = this.getFile();
        String p = (this.getPath() == null ? this.getName(f) : this.getPath()).replace('\\', '/');
        if (f == null) {
            throw new IOException("No archive file is set.");
        }
        if (!f.isFile()) {
            throw new IOException("The archive file " + f.getPath() + " does not exist or is no file.");
        }
        PlexusIoResourceAttributes attributes = this.getAttributes(f);
        InputStreamSupplier inputStreamSupplier = new InputStreamSupplier(){

            @Nonnull
            public InputStream get() throws IOException {
                return PlexusIoCompressedFileResourceCollection.this.getInputStream(f);
            }
        };
        PlexusIoResource resource = ResourceFactory.createResource(f, p, attributes, inputStreamSupplier, this.streamTransformers);
        return Collections.singleton(resource).iterator();
    }

    protected String getName(File file) throws IOException {
        String name = file.getPath();
        String ext = this.getDefaultExtension();
        if (ext != null && ext.length() > 0 && name.endsWith(ext)) {
            return name.substring(0, name.length() - ext.length());
        }
        return name;
    }

    protected abstract String getDefaultExtension();

    @Nonnull
    protected abstract InputStream getInputStream(File var1) throws IOException;

    @Override
    public InputStream getInputStream(PlexusIoResource resource) throws IOException {
        InputStream contents = resource.getContents();
        return new ClosingInputStream(this.streamTransformers.transform(resource, contents), contents);
    }

    @Override
    public PlexusIoResource resolve(PlexusIoResource resource) throws IOException {
        Deferred deferred = new Deferred(resource, this, this.streamTransformers != AbstractPlexusIoResourceCollection.identityTransformer);
        return deferred.asResource();
    }

    @Override
    public Iterator<PlexusIoResource> iterator() {
        try {
            return this.getResources();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getName(PlexusIoResource resource) {
        return resource.getName();
    }

    @Override
    public long getLastModified() throws IOException {
        File f = this.getFile();
        return f == null ? 0L : f.lastModified();
    }
}

