/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import org.picocontainer.ComponentAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.BatchExtensionDictionnary;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.database.daos.MeasuresDao;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.resources.Language;
import org.sonar.api.resources.Languages;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.ProjectFileSystem;
import org.sonar.api.resources.Resource;
import org.sonar.api.utils.IocContainer;
import org.sonar.api.utils.SonarException;
import org.sonar.batch.DefaultProfileLoader;
import org.sonar.batch.DefaultProjectClasspath;
import org.sonar.batch.DefaultProjectFileSystem2;
import org.sonar.batch.DefaultSensorContext;
import org.sonar.batch.DefaultTimeMachine;
import org.sonar.batch.ProfileProvider;
import org.sonar.batch.ProjectTree;
import org.sonar.batch.ResourceFilters;
import org.sonar.batch.ViolationFilters;
import org.sonar.batch.bootstrap.Module;
import org.sonar.batch.bootstrap.ProjectExtensionInstaller;
import org.sonar.batch.components.TimeMachineConfiguration;
import org.sonar.batch.config.ProjectSettings;
import org.sonar.batch.events.EventBus;
import org.sonar.batch.index.DefaultIndex;
import org.sonar.batch.index.DefaultResourcePersister;
import org.sonar.batch.phases.Phases;
import org.sonar.batch.phases.PhasesTimeProfiler;
import org.sonar.core.qualitymodel.DefaultModelFinder;
import org.sonar.jpa.dao.ProfilesDao;
import org.sonar.jpa.dao.RulesDao;

public class ProjectModule
extends Module {
    private static final Logger LOG = LoggerFactory.getLogger(ProjectModule.class);
    private Project project;
    private boolean dryRun;

    public ProjectModule(Project project, boolean dryRun) {
        this.project = project;
        this.dryRun = dryRun;
    }

    protected void configure() {
        this.logSettings();
        this.addCoreComponents();
        this.addProjectComponents();
        this.addProjectPluginExtensions();
    }

    private void addProjectComponents() {
        ProjectDefinition projectDefinition = this.getComponentByType(ProjectTree.class).getProjectDefinition(this.project);
        this.addCoreSingleton(projectDefinition);
        this.addCoreSingleton(this.project);
        this.addCoreSingleton(this.project.getConfiguration());
        this.addCoreSingleton(ProjectSettings.class);
        this.addCoreSingleton(IocContainer.class);
        for (Object component : projectDefinition.getContainerExtensions()) {
            this.addCoreSingleton(component);
        }
        this.addCoreSingleton(DefaultProjectClasspath.class);
        this.addCoreSingleton(DefaultProjectFileSystem2.class);
        this.addCoreSingleton(RulesDao.class);
        if (!this.dryRun) {
            this.addCoreSingleton(this.getComponentByType(DefaultResourcePersister.class).getSnapshot((Resource)this.project));
        }
        this.addCoreSingleton(TimeMachineConfiguration.class);
        this.addCoreSingleton(MeasuresDao.class);
        this.addCoreSingleton(ProfilesDao.class);
        this.addCoreSingleton(DefaultSensorContext.class);
        this.addCoreSingleton(Languages.class);
        this.addCoreSingleton(BatchExtensionDictionnary.class);
        this.addCoreSingleton(DefaultTimeMachine.class);
        this.addCoreSingleton(ViolationFilters.class);
        this.addCoreSingleton(ResourceFilters.class);
        this.addCoreSingleton(DefaultModelFinder.class);
        this.addCoreSingleton(DefaultProfileLoader.class);
        this.addAdapter((ComponentAdapter<?>)new ProfileProvider());
    }

    private void addCoreComponents() {
        this.addCoreSingleton(EventBus.class);
        this.addCoreSingleton(Phases.class);
        this.addCoreSingleton(PhasesTimeProfiler.class);
        for (Class clazz : Phases.getPhaseClasses(this.dryRun)) {
            this.addCoreSingleton(clazz);
        }
    }

    private void addProjectPluginExtensions() {
        this.addCoreSingleton(ProjectExtensionInstaller.class);
        ProjectExtensionInstaller installer = this.getComponentByType(ProjectExtensionInstaller.class);
        installer.install(this);
    }

    private void logSettings() {
        LOG.info("-------------  Analyzing {}", (Object)this.project.getName());
    }

    protected void doStart() {
        Language language = this.getComponentByType(Languages.class).get(this.project.getLanguageKey());
        if (language == null) {
            throw new SonarException("Language with key '" + this.project.getLanguageKey() + "' not found");
        }
        this.project.setLanguage(language);
        DefaultIndex index = this.getComponentByType(DefaultIndex.class);
        index.setCurrentProject(this.project, this.getComponentByType(ResourceFilters.class), this.getComponentByType(ViolationFilters.class), this.getComponentByType(RulesProfile.class));
        this.project.setFileSystem(this.getComponentByType(ProjectFileSystem.class));
        this.getComponentByType(Phases.class).execute(this.project);
    }
}

