/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.config;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.config.PropertyDefinitions;
import org.sonar.api.config.Settings;
import org.sonar.api.resources.Project;
import org.sonar.core.config.ConfigurationUtils;
import org.sonar.core.properties.PropertiesDao;
import org.sonar.core.properties.PropertyDto;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectSettings
extends Settings {
    private Configuration deprecatedCommonsConf;
    private ProjectDefinition projectDefinition;
    private PropertiesDao propertiesDao;

    public ProjectSettings(PropertyDefinitions definitions, ProjectDefinition projectDefinition, PropertiesDao propertiesDao, Project project) {
        super(definitions);
        this.deprecatedCommonsConf = project.getConfiguration();
        this.projectDefinition = projectDefinition;
        this.propertiesDao = propertiesDao;
        this.load();
    }

    public ProjectSettings load() {
        this.clear();
        this.loadBuildProperties();
        this.addEnvironmentVariables();
        this.addSystemProperties();
        String branch = this.getString("sonar.branch");
        this.clear();
        this.loadDatabaseGlobalSettings();
        this.loadDatabaseProjectSettings(this.projectDefinition, branch);
        this.loadBuildProperties();
        this.addEnvironmentVariables();
        this.addSystemProperties();
        this.updateDeprecatedCommonsConfiguration();
        return this;
    }

    private void loadBuildProperties() {
        List<ProjectDefinition> orderedProjects = ProjectSettings.getOrderedProjects(this.projectDefinition);
        for (ProjectDefinition p : orderedProjects) {
            this.addProperties(p.getProperties());
        }
    }

    private void loadDatabaseProjectSettings(ProjectDefinition projectDef, String branch) {
        if (projectDef.getParent() != null) {
            this.loadDatabaseProjectSettings(projectDef.getParent(), branch);
        }
        String projectKey = projectDef.getKey();
        if (StringUtils.isNotBlank((String)branch)) {
            projectKey = String.format("%s:%s", projectKey, branch);
        }
        List props = this.propertiesDao.selectProjectProperties(projectKey);
        for (PropertyDto dbProperty : props) {
            this.setProperty(dbProperty.getKey(), dbProperty.getValue());
        }
    }

    private void loadDatabaseGlobalSettings() {
        List props = this.propertiesDao.selectGlobalProperties();
        for (PropertyDto dbProperty : props) {
            this.setProperty(dbProperty.getKey(), dbProperty.getValue());
        }
    }

    private void updateDeprecatedCommonsConfiguration() {
        ConfigurationUtils.copyToCommonsConfiguration((Map)this.properties, (Configuration)this.deprecatedCommonsConf);
    }

    static List<ProjectDefinition> getOrderedProjects(ProjectDefinition project) {
        ArrayList result = Lists.newArrayList();
        for (ProjectDefinition pd = project; pd != null; pd = pd.getParent()) {
            result.add(0, pd);
        }
        return result;
    }
}

