/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import com.google.common.base.Throwables;
import java.io.File;
import java.net.SocketTimeoutException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchComponent;
import org.sonar.api.config.Settings;
import org.sonar.api.utils.HttpDownloader;
import org.sonar.api.utils.SonarException;
import org.sonar.api.utils.TempFolder;
import org.sonar.batch.bootstrap.AnalysisMode;
import org.sonar.batch.bootstrap.ServerClient;

public class PreviewDatabase
implements BatchComponent {
    private static final Logger LOG = LoggerFactory.getLogger(PreviewDatabase.class);
    private static final String DIALECT = "h2";
    private static final String DRIVER = "org.h2.Driver";
    private static final String URL = "jdbc:h2:";
    private static final String USER = "sonar";
    private static final String PASSWORD = "sonar";
    private static final int DEFAULT_PREVIEW_READ_TIMEOUT_SEC = 60;
    private final Settings settings;
    private final ServerClient server;
    private final TempFolder tempUtils;
    private final AnalysisMode mode;

    public PreviewDatabase(Settings settings, ServerClient server, TempFolder tempUtils, AnalysisMode mode) {
        this.settings = settings;
        this.server = server;
        this.tempUtils = tempUtils;
        this.mode = mode;
    }

    public void start() {
        if (this.mode.isPreview()) {
            File databaseFile = this.tempUtils.newFile("preview", ".h2.db");
            int readTimeoutSec = this.getReadTimeout();
            this.downloadDatabase(databaseFile, readTimeoutSec * 1000);
            String databasePath = StringUtils.removeEnd((String)databaseFile.getAbsolutePath(), (String)".h2.db");
            this.replaceSettings(databasePath);
        }
    }

    private int getReadTimeout() {
        int readTimeoutSec;
        if (this.settings.hasKey("sonar.dryRun.readTimeout")) {
            LOG.warn(String.format("Property {0} is deprecated. Please use {1} instead.", "sonar.dryRun.readTimeout", "sonar.preview.readTimeout"));
            readTimeoutSec = this.settings.getInt("sonar.dryRun.readTimeout");
        } else {
            readTimeoutSec = this.settings.hasKey("sonar.preview.readTimeout") ? this.settings.getInt("sonar.preview.readTimeout") : 60;
        }
        return readTimeoutSec;
    }

    private void downloadDatabase(File toFile, int readTimeout) {
        String projectKey = null;
        try {
            projectKey = this.settings.getString("sonar.projectKey");
            String branch = this.settings.getString("sonar.branch");
            if (StringUtils.isNotBlank((String)branch)) {
                projectKey = String.format("%s:%s", projectKey, branch);
            }
            if (StringUtils.isBlank((String)projectKey)) {
                this.server.download("/batch_bootstrap/db", toFile, readTimeout);
            } else {
                this.server.download("/batch_bootstrap/db?project=" + projectKey, toFile, readTimeout);
            }
            LOG.debug("Dry Run database size: {}", (Object)FileUtils.byteCountToDisplaySize((long)FileUtils.sizeOf((File)toFile)));
        }
        catch (SonarException e) {
            this.handleException(readTimeout, projectKey, e);
            throw e;
        }
    }

    private void handleException(int readTimeout, String projectKey, SonarException e) {
        Throwable rootCause = Throwables.getRootCause((Throwable)e);
        if (rootCause instanceof SocketTimeoutException) {
            throw new SonarException((Throwable)new SonarException(String.format("Preview database read timed out after %s ms. You can try to increase read timeout with property -Dsonar.preview.readTimeout (in seconds)", readTimeout), (Throwable)e));
        }
        if (projectKey != null && rootCause instanceof HttpDownloader.HttpException && ((HttpDownloader.HttpException)rootCause).getResponseCode() == 401) {
            throw new SonarException((Throwable)new SonarException(String.format("You don't have access rights to project [%s]", projectKey), (Throwable)e));
        }
    }

    private void replaceSettings(String databasePath) {
        this.settings.removeProperty("sonar.jdbc.schema").setProperty("sonar.jdbc.dialect", DIALECT).setProperty("sonar.jdbc.driverClassName", DRIVER).setProperty("sonar.jdbc.username", "sonar").setProperty("sonar.jdbc.password", "sonar").setProperty("sonar.jdbc.url", URL + databasePath);
    }
}

