/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.index;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.LoggerFactory;
import org.sonar.api.database.model.MeasureMapper;
import org.sonar.api.database.model.MeasureModel;
import org.sonar.api.database.model.Snapshot;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.RuleMeasure;
import org.sonar.api.resources.Resource;
import org.sonar.api.resources.ResourceUtils;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleFinder;
import org.sonar.api.utils.SonarException;
import org.sonar.batch.index.MemoryOptimizer;
import org.sonar.batch.index.ResourcePersister;
import org.sonar.core.persistence.MyBatis;

public final class MeasurePersister {
    private final MyBatis mybatis;
    private final ResourcePersister resourcePersister;
    private final RuleFinder ruleFinder;
    private final MemoryOptimizer memoryOptimizer;
    private final SetMultimap<Resource, Measure> unsavedMeasuresByResource = LinkedHashMultimap.create();
    private boolean delayedMode = false;

    public MeasurePersister(MyBatis mybatis, ResourcePersister resourcePersister, RuleFinder ruleFinder, MemoryOptimizer memoryOptimizer) {
        this.mybatis = mybatis;
        this.resourcePersister = resourcePersister;
        this.ruleFinder = ruleFinder;
        this.memoryOptimizer = memoryOptimizer;
    }

    public void setDelayedMode(boolean delayedMode) {
        this.delayedMode = delayedMode;
    }

    public Measure reloadMeasure(Measure measure) {
        return this.memoryOptimizer.reloadMeasure(measure);
    }

    public void dump() {
        LoggerFactory.getLogger(this.getClass()).debug("{} measures to dump", (Object)this.unsavedMeasuresByResource.size());
        this.insert(this.getMeasuresToSave());
    }

    public void saveMeasure(Resource resource, Measure measure) {
        MeasureModel model;
        if (this.shouldSaveLater(measure)) {
            this.unsavedMeasuresByResource.put((Object)resource, (Object)measure);
            return;
        }
        try {
            model = this.insertOrUpdate(resource, measure);
        }
        catch (Exception e) {
            throw new SonarException(String.format("Unable to save measure for metric [%s] on resource [%s]", measure.getMetricKey(), resource.getKey()), (Throwable)e);
        }
        if (model != null) {
            this.memoryOptimizer.evictDataMeasure(measure, model);
        }
    }

    private MeasureModel insertOrUpdate(Resource resource, Measure measure) {
        Snapshot snapshot = this.resourcePersister.getSnapshotOrFail(resource);
        if (measure.getId() != null) {
            return this.update(measure, snapshot);
        }
        if (MeasurePersister.shouldPersistMeasure(resource, measure)) {
            MeasureModel insert = this.insert(measure, snapshot);
            measure.setId(insert.getId());
            return insert;
        }
        return null;
    }

    private boolean shouldSaveLater(Measure measure) {
        return this.delayedMode && measure.getPersistenceMode().useMemory();
    }

    @VisibleForTesting
    static boolean shouldPersistMeasure(Resource resource, Measure measure) {
        return measure.getPersistenceMode().useDatabase() && (!ResourceUtils.isEntity((Resource)resource) || !measure.isBestValue()) && MeasurePersister.isMeasureNotEmpty(measure);
    }

    private static boolean isMeasureNotEmpty(Measure measure) {
        boolean isNotEmpty = false;
        for (int i = 1; i <= 5; ++i) {
            isNotEmpty = isNotEmpty || measure.getVariation(i) != null;
        }
        return measure.getValue() != null || measure.getData() != null || isNotEmpty;
    }

    private List<MeasureModelAndDetails> getMeasuresToSave() {
        ArrayList measures = Lists.newArrayList();
        Map map = this.unsavedMeasuresByResource.asMap();
        for (Map.Entry entry : map.entrySet()) {
            Resource resource = (Resource)entry.getKey();
            Snapshot snapshot = this.resourcePersister.getSnapshot((Resource)entry.getKey());
            for (Measure measure : (Collection)entry.getValue()) {
                if (!MeasurePersister.shouldPersistMeasure(resource, measure)) continue;
                measures.add(new MeasureModelAndDetails(this.model(measure).setSnapshotId(snapshot.getId()), resource.getKey(), measure.getMetricKey()));
            }
        }
        this.unsavedMeasuresByResource.clear();
        return measures;
    }

    private MeasureModel model(Measure measure) {
        MeasureModel model = new MeasureModel();
        model.setMetricId(measure.getMetric().getId());
        model.setDescription(measure.getDescription());
        model.setData(measure.getData());
        model.setAlertStatus(measure.getAlertStatus());
        model.setAlertText(measure.getAlertText());
        model.setTendency(measure.getTendency());
        model.setVariationValue1(measure.getVariation1());
        model.setVariationValue2(measure.getVariation2());
        model.setVariationValue3(measure.getVariation3());
        model.setVariationValue4(measure.getVariation4());
        model.setVariationValue5(measure.getVariation5());
        model.setUrl(measure.getUrl());
        model.setCharacteristic(measure.getCharacteristic());
        model.setPersonId(measure.getPersonId());
        if (measure.getValue() != null) {
            model.setValue(Double.valueOf(measure.getValue()));
        } else {
            model.setValue(null);
        }
        if (measure instanceof RuleMeasure) {
            RuleMeasure ruleMeasure = (RuleMeasure)measure;
            model.setRulePriority(ruleMeasure.getSeverity());
            if (ruleMeasure.getRule() != null) {
                Rule ruleWithId = this.ruleFinder.findByKey(ruleMeasure.getRule().getRepositoryKey(), ruleMeasure.getRule().getKey());
                if (ruleWithId == null) {
                    throw new SonarException("Can not save a measure with unknown rule " + ruleMeasure);
                }
                model.setRuleId(ruleWithId.getId());
            }
        }
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insert(Iterable<MeasureModelAndDetails> values) {
        SqlSession session = this.mybatis.openSession();
        try {
            MeasureMapper mapper = (MeasureMapper)session.getMapper(MeasureMapper.class);
            for (MeasureModelAndDetails value : values) {
                try {
                    mapper.insert(value.getMeasureModel());
                    if (value.getMeasureModel().getMeasureData() == null) continue;
                    mapper.insertData(value.getMeasureModel().getMeasureData());
                }
                catch (Exception e) {
                    throw new SonarException(String.format("Unable to save measure for metric [%s] on resource [%s]", value.getMetricKey(), value.getResourceKey()), (Throwable)e);
                }
            }
            session.commit();
        }
        finally {
            MyBatis.closeQuietly((SqlSession)session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MeasureModel insert(Measure measure, Snapshot snapshot) {
        MeasureModel value = this.model(measure);
        value.setSnapshotId(snapshot.getId());
        SqlSession session = this.mybatis.openSession();
        try {
            MeasureMapper mapper = (MeasureMapper)session.getMapper(MeasureMapper.class);
            mapper.insert(value);
            if (value.getMeasureData() != null) {
                mapper.insertData(value.getMeasureData());
            }
            session.commit();
        }
        finally {
            MyBatis.closeQuietly((SqlSession)session);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MeasureModel update(Measure measure, Snapshot snapshot) {
        MeasureModel value = this.model(measure);
        value.setId(measure.getId());
        value.setSnapshotId(snapshot.getId());
        SqlSession session = this.mybatis.openSession();
        try {
            MeasureMapper mapper = (MeasureMapper)session.getMapper(MeasureMapper.class);
            mapper.update(value);
            mapper.deleteData(value);
            if (value.getMeasureData() != null) {
                mapper.insertData(value.getMeasureData());
            }
            session.commit();
        }
        finally {
            MyBatis.closeQuietly((SqlSession)session);
        }
        return value;
    }

    private static class MeasureModelAndDetails {
        private final MeasureModel measureModel;
        private final String resourceKey;
        private final String metricKey;

        public MeasureModelAndDetails(MeasureModel measureModel, String resourceKey, String metricKey) {
            this.measureModel = measureModel;
            this.resourceKey = resourceKey;
            this.metricKey = metricKey;
        }

        public MeasureModel getMeasureModel() {
            return this.measureModel;
        }

        public String getResourceKey() {
            return this.resourceKey;
        }

        public String getMetricKey() {
            return this.metricKey;
        }
    }
}

