/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.issue;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.sonar.api.BatchComponent;
import org.sonar.api.issue.internal.DefaultIssue;
import org.sonar.api.resources.Resource;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleFinder;
import org.sonar.api.rules.RulePriority;
import org.sonar.api.rules.Violation;
import org.sonar.batch.index.ResourceCache;
import org.sonar.batch.issue.IssueCache;

public class DeprecatedViolations
implements BatchComponent {
    private final IssueCache issueCache;
    private final RuleFinder ruleFinder;
    private final ResourceCache resourceCache;

    public DeprecatedViolations(IssueCache issueCache, RuleFinder ruleFinder, ResourceCache resourceCache) {
        this.issueCache = issueCache;
        this.ruleFinder = ruleFinder;
        this.resourceCache = resourceCache;
    }

    public List<Violation> get(String componentKey) {
        Iterable<DefaultIssue> issues = this.issueCache.byComponent(componentKey);
        ArrayList violations = Lists.newArrayList();
        for (DefaultIssue issue : issues) {
            violations.add(this.toViolation(issue));
        }
        return violations;
    }

    public Violation toViolation(DefaultIssue issue) {
        Rule rule = this.ruleFinder.findByKey(issue.ruleKey());
        Resource resource = this.resourceCache.get(issue.componentKey());
        Violation violation = new Violation(rule, resource);
        violation.setNew(issue.isNew());
        violation.setChecksum(issue.checksum());
        violation.setMessage(issue.message());
        violation.setCost(issue.effortToFix());
        violation.setLineId(issue.line());
        violation.setCreatedAt(issue.creationDate());
        violation.setManual(issue.reporter() != null);
        violation.setSeverity(RulePriority.valueOf((String)issue.severity()));
        violation.setSwitchedOff(issue.resolution() != null);
        return violation;
    }
}

