/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan.filesystem;

import com.google.common.collect.Maps;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.HiddenFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchComponent;
import org.sonar.api.resources.JavaFile;
import org.sonar.api.resources.Project;
import org.sonar.api.scan.filesystem.ModuleFileSystem;
import org.sonar.api.scan.filesystem.PathResolver;
import org.sonar.api.scan.filesystem.internal.DefaultInputFile;
import org.sonar.api.scan.filesystem.internal.InputFile;
import org.sonar.api.scan.filesystem.internal.InputFileFilter;
import org.sonar.api.utils.PathUtils;
import org.sonar.batch.scan.filesystem.DefaultModuleFileSystem;
import org.sonar.batch.scan.filesystem.FileHashes;
import org.sonar.batch.scan.filesystem.InputFileCache;
import org.sonar.batch.scan.filesystem.LanguageRecognizer;

public class FileIndex
implements BatchComponent {
    private static final IOFileFilter DIR_FILTER = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{HiddenFileFilter.VISIBLE, FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.prefixFileFilter((String)"."))});
    private static final IOFileFilter FILE_FILTER = HiddenFileFilter.VISIBLE;
    private final PathResolver pathResolver;
    private final List<InputFileFilter> filters;
    private final LanguageRecognizer languageRecognizer;
    private final InputFileCache cache;
    private final FileHashes fileHashes;
    private final Project project;

    public FileIndex(List<InputFileFilter> filters, LanguageRecognizer languageRecognizer, InputFileCache cache, FileHashes fileHashes, PathResolver pathResolver, Project project) {
        this.filters = filters;
        this.languageRecognizer = languageRecognizer;
        this.cache = cache;
        this.fileHashes = fileHashes;
        this.pathResolver = pathResolver;
        this.project = project;
    }

    void index(DefaultModuleFileSystem fileSystem) {
        Logger logger = LoggerFactory.getLogger(FileIndex.class);
        logger.info("Index files");
        Progress progress = new Progress(this.cache.fileRelativePaths(fileSystem.moduleKey()));
        if (fileSystem.sourceFiles().isEmpty()) {
            for (File sourceDir : fileSystem.sourceDirs()) {
                this.indexDirectory(fileSystem, progress, sourceDir, "SOURCE");
            }
        } else {
            this.indexFiles(fileSystem, progress, fileSystem.sourceDirs(), fileSystem.sourceFiles(), "SOURCE");
        }
        if (fileSystem.testFiles().isEmpty()) {
            for (File testDir : fileSystem.testDirs()) {
                this.indexDirectory(fileSystem, progress, testDir, "TEST");
            }
        } else {
            this.indexFiles(fileSystem, progress, fileSystem.testDirs(), fileSystem.testFiles(), "TEST");
        }
        for (String path : progress.removedPaths) {
            this.cache.remove(fileSystem.moduleKey(), path);
        }
        logger.info(String.format("%d files indexed", progress.count));
    }

    private void indexFiles(DefaultModuleFileSystem fileSystem, Progress progress, List<File> sourceDirs, List<File> sourceFiles, String type) {
        for (File sourceFile : sourceFiles) {
            PathResolver.RelativePath sourceDirPath = this.pathResolver.relativePath(sourceDirs, sourceFile);
            if (sourceDirPath == null) {
                LoggerFactory.getLogger(this.getClass()).warn(String.format("File '%s' is not declared in source directories %s", sourceFile.getAbsoluteFile(), StringUtils.join(sourceDirs, (String)", ")));
                continue;
            }
            this.indexFile(fileSystem, progress, sourceDirPath.dir(), sourceFile, type);
        }
    }

    Iterable<InputFile> inputFiles(String moduleKey) {
        return this.cache.byModule(moduleKey);
    }

    private void indexDirectory(DefaultModuleFileSystem fileSystem, Progress status, File sourceDir, String type) {
        Collection files = FileUtils.listFiles((File)sourceDir, (IOFileFilter)FILE_FILTER, (IOFileFilter)DIR_FILTER);
        for (File file : files) {
            this.indexFile(fileSystem, status, sourceDir, file, type);
        }
    }

    private void indexFile(DefaultModuleFileSystem fileSystem, Progress status, File sourceDir, File file, String type) {
        String path = this.pathResolver.relativePath(fileSystem.baseDir(), file);
        if (path == null) {
            LoggerFactory.getLogger(this.getClass()).warn(String.format("File '%s' is not in basedir '%s'", file.getAbsolutePath(), fileSystem.baseDir()));
        } else {
            InputFile input = this.newInputFile(fileSystem, sourceDir, type, file, path);
            if (input != null && this.accept(input)) {
                this.cache.put(fileSystem.moduleKey(), input);
                status.markAsIndexed(path);
            }
        }
    }

    @CheckForNull
    private InputFile newInputFile(ModuleFileSystem fileSystem, File sourceDir, String type, File file, String path) {
        String lang = this.languageRecognizer.of(file);
        if (lang == null) {
            return null;
        }
        HashMap attributes = Maps.newHashMap();
        this.set(attributes, "TYPE", type);
        this.set(attributes, "LANG", lang);
        this.set(attributes, "SRC_DIR_PATH", PathUtils.canonicalPath((File)sourceDir));
        String sourceRelativePath = this.pathResolver.relativePath(sourceDir, file);
        this.set(attributes, "SRC_REL_PATH", sourceRelativePath);
        if ("java".equals(lang)) {
            this.set(attributes, "CMP_KEY", this.project.getEffectiveKey() + ":" + JavaFile.fromRelativePath((String)sourceRelativePath, (boolean)false).getKey());
        } else {
            this.set(attributes, "CMP_KEY", this.project.getEffectiveKey() + ":" + sourceRelativePath);
        }
        this.initStatus(file, fileSystem.sourceCharset(), path, attributes);
        return DefaultInputFile.create((File)file, (String)path, (Map)attributes);
    }

    private void initStatus(File file, Charset charset, String baseRelativePath, Map<String, String> attributes) {
        String hash = this.fileHashes.hash(file, charset);
        this.set(attributes, "HASH", hash);
        String remoteHash = this.fileHashes.remoteHash(baseRelativePath);
        if (StringUtils.equals((String)hash, (String)remoteHash)) {
            this.set(attributes, "STATUS", "SAME");
        } else if (StringUtils.isEmpty((String)remoteHash)) {
            this.set(attributes, "STATUS", "ADDED");
        } else {
            this.set(attributes, "STATUS", "CHANGED");
        }
    }

    private void set(Map<String, String> attributes, String key, @Nullable String value) {
        if (value != null) {
            attributes.put(key, value);
        }
    }

    private boolean accept(InputFile inputFile) {
        for (InputFileFilter filter : this.filters) {
            if (filter.accept(inputFile)) continue;
            return false;
        }
        return true;
    }

    private static class Progress {
        private int count = 0;
        private final Set<String> removedPaths;

        Progress(Set<String> removedPaths) {
            this.removedPaths = removedPaths;
        }

        void markAsIndexed(String relativePath) {
            ++this.count;
            this.removedPaths.remove(relativePath);
        }
    }
}

