/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan.filesystem;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.sonar.api.scan.filesystem.FileQuery;
import org.sonar.api.scan.filesystem.internal.InputFile;
import org.sonar.api.scan.filesystem.internal.InputFileFilter;
import org.sonar.batch.bootstrap.AnalysisMode;
import org.sonar.batch.scan.filesystem.AttributeFilter;
import org.sonar.batch.scan.filesystem.ExclusionFilter;
import org.sonar.batch.scan.filesystem.InclusionFilter;

class FileQueryFilter {
    private final List<InputFileFilter> filters = Lists.newArrayList();

    FileQueryFilter(AnalysisMode analysisMode, FileQuery query) {
        Collection status;
        for (String string : query.inclusions()) {
            this.filters.add(new InclusionFilter(string));
        }
        for (String string : query.exclusions()) {
            this.filters.add(new ExclusionFilter(string));
        }
        for (Map.Entry entry : query.attributes().entrySet()) {
            this.filters.add(new AttributeFilter((String)entry.getKey(), (Collection)entry.getValue()));
        }
        if (analysisMode.isIncremental() && ((status = (Collection)query.attributes().get("STATUS")) == null || status.isEmpty())) {
            this.filters.add(new AttributeFilter("STATUS", Lists.newArrayList((Object[])new String[]{"ADDED", "CHANGED"})));
        }
    }

    @VisibleForTesting
    List<InputFileFilter> filters() {
        return this.filters;
    }

    boolean accept(InputFile inputFile) {
        for (InputFileFilter filter : this.filters) {
            if (filter.accept(inputFile)) continue;
            return false;
        }
        return true;
    }
}

