/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan.filesystem;

import java.util.Set;
import org.sonar.api.BatchComponent;
import org.sonar.api.scan.filesystem.internal.InputFile;
import org.sonar.batch.index.Cache;
import org.sonar.batch.index.Caches;

public class InputFileCache
implements BatchComponent {
    private final Cache<String, InputFile> cache;

    public InputFileCache(Caches caches) {
        this.cache = caches.createCache("inputFiles");
    }

    public Iterable<InputFile> byModule(String moduleKey) {
        return this.cache.values(moduleKey);
    }

    public InputFileCache removeModule(String moduleKey) {
        this.cache.clear(moduleKey);
        return this;
    }

    public InputFileCache remove(String moduleKey, String relativePath) {
        this.cache.remove(moduleKey, relativePath);
        return this;
    }

    public Iterable<InputFile> all() {
        return this.cache.allValues();
    }

    public Set<String> fileRelativePaths(String moduleKey) {
        return this.cache.keySet(moduleKey);
    }

    public boolean containsFile(String moduleKey, String relativePath) {
        return this.cache.containsKey(moduleKey, relativePath);
    }

    public InputFileCache put(String moduleKey, InputFile file) {
        this.cache.put(moduleKey, file.path(), file);
        return this;
    }
}

