/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.batch.Event;
import org.sonar.api.batch.SonarIndex;
import org.sonar.api.batch.measure.Metric;
import org.sonar.api.design.Dependency;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.MeasuresFilter;
import org.sonar.api.measures.MeasuresFilters;
import org.sonar.api.measures.MetricFinder;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.rules.Violation;
import org.sonar.api.utils.SonarException;
import org.sonar.api.violations.ViolationQuery;
import org.sonar.batch.scan.measure.MeasureCache;
import org.sonar.core.measure.MeasurementFilters;

public class DefaultDecoratorContext
implements DecoratorContext {
    private static final String SAVE_MEASURE_METHOD = "saveMeasure";
    private SonarIndex sonarIndex;
    private Resource resource;
    private MeasurementFilters measurementFilters;
    private boolean readOnly = false;
    private List<DecoratorContext> childrenContexts;
    private ListMultimap<String, Measure> measuresByMetric = ArrayListMultimap.create();
    private MeasureCache measureCache;
    private MetricFinder metricFinder;

    public DefaultDecoratorContext(Resource resource, SonarIndex index, List<DecoratorContext> childrenContexts, MeasurementFilters measurementFilters, MeasureCache measureCache, MetricFinder metricFinder) {
        this.sonarIndex = index;
        this.resource = resource;
        this.childrenContexts = childrenContexts;
        this.measurementFilters = measurementFilters;
        this.measureCache = measureCache;
        this.metricFinder = metricFinder;
    }

    public void init() {
        Iterable<Measure> unfiltered = this.measureCache.byResource(this.resource);
        for (Measure measure : unfiltered) {
            this.measuresByMetric.put((Object)measure.getMetricKey(), (Object)measure);
        }
    }

    public DefaultDecoratorContext end() {
        this.readOnly = true;
        this.childrenContexts = null;
        for (Measure measure : this.measuresByMetric.values()) {
            this.measureCache.put(this.resource, measure);
        }
        return this;
    }

    public Project getProject() {
        return this.sonarIndex.getProject();
    }

    public List<DecoratorContext> getChildren() {
        this.checkReadOnly("getModules");
        return this.childrenContexts;
    }

    private void checkReadOnly(String methodName) {
        if (this.readOnly) {
            throw new IllegalStateException("Method DecoratorContext." + methodName + "() can not be executed on children.");
        }
    }

    public <M> M getMeasures(MeasuresFilter<M> filter) {
        Collection unfiltered = filter instanceof MeasuresFilters.MetricFilter ? this.measuresByMetric.get((Object)((MeasuresFilters.MetricFilter)filter).filterOnMetricKey()) : this.measuresByMetric.values();
        return (M)filter.filter(unfiltered);
    }

    public Measure getMeasure(org.sonar.api.measures.Metric metric) {
        return (Measure)this.getMeasures(MeasuresFilters.metric((Metric)metric));
    }

    public Collection<Measure> getChildrenMeasures(MeasuresFilter filter) {
        ArrayList result = Lists.newArrayList();
        for (DecoratorContext childContext : this.childrenContexts) {
            Object childResult = childContext.getMeasures(filter);
            if (childResult == null) continue;
            if (childResult instanceof Collection) {
                result.addAll((Collection)childResult);
                continue;
            }
            result.add((Measure)childResult);
        }
        return result;
    }

    public Collection<Measure> getChildrenMeasures(org.sonar.api.measures.Metric metric) {
        return this.getChildrenMeasures(MeasuresFilters.metric((Metric)metric));
    }

    public Resource getResource() {
        return this.resource;
    }

    public DecoratorContext saveMeasure(Measure measure) {
        this.checkReadOnly(SAVE_MEASURE_METHOD);
        org.sonar.api.measures.Metric metric = this.metricFinder.findByKey(measure.getMetricKey());
        if (metric == null) {
            throw new SonarException("Unknown metric: " + measure.getMetricKey());
        }
        measure.setMetric(metric);
        if (this.measurementFilters.accept(this.resource, measure)) {
            int index;
            List metricMeasures = this.measuresByMetric.get((Object)measure.getMetricKey());
            boolean add = true;
            if (metricMeasures != null && (index = metricMeasures.indexOf(measure)) > -1) {
                if (metricMeasures.get(index) == measure) {
                    add = false;
                } else if (measure.getMetric().equals((Object)CoreMetrics.TESTS)) {
                    this.measuresByMetric.remove((Object)measure.getMetric().getKey(), metricMeasures.get(index));
                } else {
                    throw new SonarException("Can not add twice the same measure on " + this.resource + ": " + measure);
                }
            }
            if (add) {
                this.measuresByMetric.put((Object)measure.getMetricKey(), (Object)measure);
            }
        }
        return this;
    }

    public DecoratorContext saveMeasure(org.sonar.api.measures.Metric metric, Double value) {
        this.checkReadOnly(SAVE_MEASURE_METHOD);
        this.saveMeasure(new Measure(metric, value));
        return this;
    }

    public List<Violation> getViolations(ViolationQuery violationQuery) {
        return this.sonarIndex.getViolations(violationQuery);
    }

    public List<Violation> getViolations() {
        return this.sonarIndex.getViolations(this.resource);
    }

    public Dependency saveDependency(Dependency dependency) {
        this.checkReadOnly("addDependency");
        return this.sonarIndex.addDependency(dependency);
    }

    public Set<Dependency> getDependencies() {
        return this.sonarIndex.getDependencies();
    }

    public Collection<Dependency> getIncomingDependencies() {
        return this.sonarIndex.getIncomingEdges((Object)this.resource);
    }

    public Collection<Dependency> getOutgoingDependencies() {
        return this.sonarIndex.getOutgoingEdges((Object)this.resource);
    }

    public List<Event> getEvents() {
        return this.sonarIndex.getEvents(this.resource);
    }

    public Event createEvent(String name, String description, String category, Date date) {
        return this.sonarIndex.addEvent(this.resource, name, description, category, date);
    }

    public void deleteEvent(Event event) {
        this.sonarIndex.deleteEvent(event);
    }

    public DefaultDecoratorContext saveViolation(Violation violation, boolean force) {
        if (violation.getResource() == null) {
            violation.setResource(this.resource);
        }
        this.sonarIndex.addViolation(violation, force);
        return this;
    }

    public DefaultDecoratorContext saveViolation(Violation violation) {
        return this.saveViolation(violation, false);
    }
}

