/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.bootstrap;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.api.config.Encryption;

public abstract class UserProperties {
    private final Map<String, String> properties;
    private final Encryption encryption;

    public UserProperties(Map<String, String> properties, @Nullable String pathToSecretKey) {
        this.encryption = new Encryption(pathToSecretKey);
        HashMap decryptedProps = Maps.newHashMap();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String value = entry.getValue();
            if (value != null && this.encryption.isEncrypted(value)) {
                try {
                    value = this.encryption.decrypt(value);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Fail to decrypt the property " + entry.getKey() + ". Please check your secret key.", e);
                }
            }
            decryptedProps.put(entry.getKey(), value);
        }
        this.properties = Maps.newHashMap((Map)decryptedProps);
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    public String property(String key) {
        return this.properties.get(key);
    }
}

