/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.components;

import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import javax.persistence.Query;
import org.sonar.api.BatchComponent;
import org.sonar.api.config.Settings;
import org.sonar.api.database.DatabaseSession;
import org.sonar.api.database.model.Snapshot;
import org.sonar.batch.ProjectTree;
import org.sonar.batch.components.PastSnapshot;
import org.sonar.batch.components.PastSnapshotFinder;

public class PeriodsDefinition
implements BatchComponent {
    public static final int CORE_TENDENCY_DEPTH_DEFAULT_VALUE = 30;
    private static final int NUMBER_OF_VARIATION_SNAPSHOTS = 5;
    private DatabaseSession session;
    private ProjectTree projectTree;
    private final Settings settings;
    private List<PastSnapshot> projectPastSnapshots;

    public PeriodsDefinition(DatabaseSession session, ProjectTree projectTree, Settings settings, PastSnapshotFinder pastSnapshotFinder) {
        this.session = session;
        this.projectTree = projectTree;
        this.settings = settings;
        this.initPastSnapshots(pastSnapshotFinder, projectTree.getRootProject().getQualifier());
    }

    private void initPastSnapshots(PastSnapshotFinder pastSnapshotFinder, String rootQualifier) {
        Snapshot projectSnapshot = this.buildProjectSnapshot();
        this.projectPastSnapshots = Lists.newLinkedList();
        if (projectSnapshot != null) {
            for (int index = 1; index <= 5; ++index) {
                PastSnapshot pastSnapshot = pastSnapshotFinder.find(projectSnapshot, rootQualifier, this.settings, index);
                if (pastSnapshot == null || pastSnapshot.getProjectSnapshot() == null) continue;
                this.projectPastSnapshots.add(pastSnapshot);
            }
        }
    }

    private Snapshot buildProjectSnapshot() {
        Query query = this.session.createNativeQuery("select p.id from projects p where p.kee=:resourceKey and p.qualifier<>:lib and p.enabled=:enabled");
        query.setParameter("resourceKey", (Object)this.projectTree.getRootProject().getKey());
        query.setParameter("lib", (Object)"LIB");
        query.setParameter("enabled", (Object)Boolean.TRUE);
        Snapshot snapshot = null;
        Number projectId = (Number)this.session.getSingleResult(query, null);
        if (projectId != null) {
            snapshot = new Snapshot();
            snapshot.setResourceId(Integer.valueOf(projectId.intValue()));
            snapshot.setCreatedAt(this.projectTree.getRootProject().getAnalysisDate());
            snapshot.setBuildDate(new Date());
            snapshot.setVersion(this.projectTree.getRootProject().getAnalysisVersion());
        }
        return snapshot;
    }

    List<PastSnapshot> getRootProjectPastSnapshots() {
        return this.projectPastSnapshots;
    }
}

