/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.debt;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.List;
import javax.annotation.Nullable;
import org.picocontainer.injectors.ProviderAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.debt.DebtCharacteristic;
import org.sonar.api.batch.debt.DebtModel;
import org.sonar.api.batch.debt.internal.DefaultDebtCharacteristic;
import org.sonar.api.batch.debt.internal.DefaultDebtModel;
import org.sonar.api.utils.TimeProfiler;
import org.sonar.core.technicaldebt.db.CharacteristicDao;
import org.sonar.core.technicaldebt.db.CharacteristicDto;

public class DebtModelProvider
extends ProviderAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(DebtModelProvider.class);
    private DebtModel model;

    public DebtModel provide(CharacteristicDao dao) {
        if (this.model == null) {
            TimeProfiler profiler = new TimeProfiler(LOG).start("Loading technical debt model");
            this.model = this.load(dao);
            profiler.stop();
        }
        return this.model;
    }

    private DebtModel load(CharacteristicDao dao) {
        DefaultDebtModel debtModel = new DefaultDebtModel();
        List allCharacteristics = dao.selectEnabledCharacteristics();
        for (CharacteristicDto dto : allCharacteristics) {
            Integer parentId = dto.getParentId();
            if (parentId == null) {
                debtModel.addCharacteristic(DebtModelProvider.toDebtCharacteristic(dto));
                continue;
            }
            debtModel.addSubCharacteristic(DebtModelProvider.toDebtCharacteristic(dto), DebtModelProvider.characteristicById(parentId, allCharacteristics).getKey());
        }
        return debtModel;
    }

    private static CharacteristicDto characteristicById(final int id, List<CharacteristicDto> allCharacteristics) {
        return (CharacteristicDto)Iterables.find(allCharacteristics, (Predicate)new Predicate<CharacteristicDto>(){

            public boolean apply(@Nullable CharacteristicDto input) {
                return input != null && id == input.getId();
            }
        });
    }

    private static DebtCharacteristic toDebtCharacteristic(CharacteristicDto characteristic) {
        return new DefaultDebtCharacteristic().setId(characteristic.getId()).setKey(characteristic.getKey()).setName(characteristic.getName()).setOrder(characteristic.getOrder()).setParentId(characteristic.getParentId());
    }
}

