/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.index;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.api.resources.Resource;

public final class Bucket {
    private Resource resource;
    private Bucket parent;
    private List<Bucket> children;

    public Bucket(Resource resource) {
        this.resource = resource;
    }

    public Resource getResource() {
        return this.resource;
    }

    public Bucket setParent(@Nullable Bucket parent) {
        this.parent = parent;
        if (parent != null) {
            parent.addChild(this);
        }
        return this;
    }

    private Bucket addChild(Bucket child) {
        if (this.children == null) {
            this.children = Lists.newArrayList();
        }
        this.children.add(child);
        return this;
    }

    private void removeChild(Bucket child) {
        if (this.children != null) {
            this.children.remove(child);
        }
    }

    public List<Bucket> getChildren() {
        return this.children == null ? Collections.emptyList() : this.children;
    }

    public Bucket getParent() {
        return this.parent;
    }

    public void clear() {
        this.children = null;
        if (this.parent != null) {
            this.parent.removeChild(this);
            this.parent = null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bucket that = (Bucket)o;
        return this.resource.equals((Object)that.resource);
    }

    public int hashCode() {
        return this.resource.hashCode();
    }
}

