/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.index;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.persistit.Exchange;
import com.persistit.Persistit;
import com.persistit.Volume;
import com.persistit.encoding.CoderManager;
import com.persistit.encoding.ValueCoder;
import com.persistit.exception.PersistitException;
import com.persistit.logging.PersistitLogger;
import com.persistit.logging.Slf4jAdapter;
import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.picocontainer.Startable;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchComponent;
import org.sonar.api.utils.TempFolder;
import org.sonar.batch.index.Cache;

public class Caches
implements BatchComponent,
Startable {
    private final Set<String> cacheNames = Sets.newHashSet();
    private File tempDir;
    private Persistit persistit;
    private Volume volume;
    private final TempFolder tempFolder;

    public Caches(TempFolder tempFolder) {
        this.tempFolder = tempFolder;
        this.initPersistit();
    }

    private void initPersistit() {
        try {
            this.tempDir = this.tempFolder.newDir("caches");
            this.persistit = new Persistit();
            this.persistit.setPersistitLogger((PersistitLogger)new Slf4jAdapter(LoggerFactory.getLogger((String)"PERSISTIT")));
            Properties props = new Properties();
            props.setProperty("datapath", this.tempDir.getAbsolutePath());
            props.setProperty("logpath", "${datapath}/log");
            props.setProperty("logfile", "${logpath}/persistit_${timestamp}.log");
            props.setProperty("buffer.count.8192", "10");
            props.setProperty("journalpath", "${datapath}/journal");
            props.setProperty("tmpvoldir", "${datapath}");
            props.setProperty("volume.1", "${datapath}/persistit,create,pageSize:8192,initialPages:10,extensionPages:100,maximumPages:25000");
            this.persistit.setProperties(props);
            this.persistit.initialize();
            this.volume = this.persistit.createTemporaryVolume();
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to start caches", e);
        }
    }

    public void registerValueCoder(Class<?> clazz, ValueCoder coder) {
        CoderManager cm = this.persistit.getCoderManager();
        cm.registerValueCoder(clazz, coder);
    }

    public <V extends Serializable> Cache<V> createCache(String cacheName) {
        Preconditions.checkState((this.volume != null && this.volume.isOpened() ? 1 : 0) != 0, (Object)"Caches are not initialized");
        Preconditions.checkState((!this.cacheNames.contains(cacheName) ? 1 : 0) != 0, (Object)("Cache is already created: " + cacheName));
        try {
            Exchange exchange = this.persistit.getExchange(this.volume, cacheName, true);
            exchange.setMaximumValueSize(0x4000000);
            Cache cache = new Cache(cacheName, exchange);
            this.cacheNames.add(cacheName);
            return cache;
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to create cache: " + cacheName, e);
        }
    }

    public void start() {
    }

    public void stop() {
        if (this.persistit != null) {
            try {
                this.persistit.close(false);
                this.persistit = null;
                this.volume = null;
            }
            catch (PersistitException e) {
                throw new IllegalStateException("Fail to close caches", e);
            }
        }
        FileUtils.deleteQuietly((File)this.tempDir);
        this.tempDir = null;
        this.cacheNames.clear();
    }

    File tempDir() {
        return this.tempDir;
    }

    Persistit persistit() {
        return this.persistit;
    }
}

