/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.issue;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import javax.annotation.Nullable;
import org.sonar.api.issue.Issue;
import org.sonar.api.issue.ProjectIssues;
import org.sonar.api.issue.internal.DefaultIssue;
import org.sonar.batch.issue.IssueCache;

public class DefaultProjectIssues
implements ProjectIssues {
    private final IssueCache cache;

    public DefaultProjectIssues(IssueCache cache) {
        this.cache = cache;
    }

    public Iterable<Issue> issues() {
        return Iterables.filter(this.cache.all(), (Predicate)new ResolvedPredicate(false));
    }

    public Iterable<Issue> resolvedIssues() {
        return Iterables.filter(this.cache.all(), (Predicate)new ResolvedPredicate(true));
    }

    private static class ResolvedPredicate
    implements Predicate<DefaultIssue> {
        private final boolean resolved;

        private ResolvedPredicate(boolean resolved) {
            this.resolved = resolved;
        }

        public boolean apply(@Nullable DefaultIssue issue) {
            if (issue != null) {
                return this.resolved ? issue.resolution() != null : issue.resolution() == null;
            }
            return false;
        }
    }
}

