/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.phases;

import org.sonar.api.BatchComponent;
import org.sonar.api.config.Settings;
import org.sonar.api.resources.Language;
import org.sonar.api.resources.Languages;
import org.sonar.api.resources.Project;
import org.sonar.api.utils.SonarException;

public class ProjectInitializer
implements BatchComponent {
    private Languages languages;
    private Settings settings;

    public ProjectInitializer(Settings settings, Languages languages) {
        this.settings = settings;
        this.languages = languages;
    }

    public void execute(Project project) {
        if (project.getLanguage() == null) {
            this.initDeprecatedLanguage(project);
        }
    }

    private void initDeprecatedLanguage(Project project) {
        String languageKey = this.settings.getString("sonar.language");
        if (languageKey != null) {
            Language language = this.languages.get(languageKey);
            if (language == null) {
                throw new SonarException("Language with key '" + languageKey + "' not found");
            }
            project.setLanguage(language);
        } else {
            project.setLanguage(Project.NONE_LANGUAGE);
        }
    }
}

