/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.profiling;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.api.resources.Project;
import org.sonar.api.utils.System2;
import org.sonar.batch.phases.Phases;
import org.sonar.batch.profiling.AbstractTimeProfiling;
import org.sonar.batch.profiling.ItemProfiling;
import org.sonar.batch.profiling.PhaseProfiling;

public class ModuleProfiling
extends AbstractTimeProfiling {
    private Map<Phases.Phase, PhaseProfiling> profilingPerPhase = new HashMap<Phases.Phase, PhaseProfiling>();
    private Map<String, ItemProfiling> profilingPerBatchStep = new LinkedHashMap<String, ItemProfiling>();
    private final Project module;

    public ModuleProfiling(@Nullable Project module, System2 system) {
        super(system);
        this.module = module;
    }

    public String moduleName() {
        if (this.module != null) {
            return this.module.getName();
        }
        return null;
    }

    public PhaseProfiling getProfilingPerPhase(Phases.Phase phase) {
        return this.profilingPerPhase.get((Object)phase);
    }

    public ItemProfiling getProfilingPerBatchStep(String stepName) {
        return this.profilingPerBatchStep.get(stepName);
    }

    public void addPhaseProfiling(Phases.Phase phase) {
        this.profilingPerPhase.put(phase, PhaseProfiling.create(this.system(), phase));
    }

    public void addBatchStepProfiling(String stepName) {
        this.profilingPerBatchStep.put(stepName, new ItemProfiling(this.system(), stepName));
    }

    public void dump() {
        double percent = (double)this.totalTime() / 100.0;
        LinkedHashMap categories = Maps.newLinkedHashMap();
        categories.putAll(this.profilingPerPhase);
        categories.putAll(this.profilingPerBatchStep);
        for (Map.Entry batchStep : ModuleProfiling.sortByDescendingTotalTime(categories).entrySet()) {
            this.println(" * " + batchStep.getKey() + " execution time: ", percent, (AbstractTimeProfiling)batchStep.getValue());
        }
        for (Phases.Phase phase : Phases.Phase.values()) {
            if (!this.profilingPerPhase.containsKey((Object)phase) || !this.getProfilingPerPhase(phase).hasItems()) continue;
            this.println("");
            this.println(" * " + (Object)((Object)phase) + " execution time breakdown: ", this.getProfilingPerPhase(phase));
            this.getProfilingPerPhase(phase).dump();
        }
    }

    public void merge(ModuleProfiling other) {
        super.add(other);
        for (Map.Entry<Phases.Phase, PhaseProfiling> entry : other.profilingPerPhase.entrySet()) {
            if (!this.profilingPerPhase.containsKey((Object)entry.getKey())) {
                this.addPhaseProfiling(entry.getKey());
            }
            this.getProfilingPerPhase(entry.getKey()).merge(entry.getValue());
        }
        for (Map.Entry<Object, AbstractTimeProfiling> entry : other.profilingPerBatchStep.entrySet()) {
            if (!this.profilingPerBatchStep.containsKey(entry.getKey())) {
                this.profilingPerBatchStep.put((String)entry.getKey(), new ItemProfiling(this.system(), (String)entry.getKey()));
            }
            this.getProfilingPerBatchStep((String)entry.getKey()).add(entry.getValue());
        }
    }
}

