/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.qualitygate;

import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.Metric;
import org.sonar.batch.qualitygate.ResolvedCondition;

class ConditionUtils {
    private ConditionUtils() {
    }

    static Metric.Level getLevel(ResolvedCondition condition, Measure measure) {
        if (ConditionUtils.evaluateCondition(condition, measure, Metric.Level.ERROR)) {
            return Metric.Level.ERROR;
        }
        if (ConditionUtils.evaluateCondition(condition, measure, Metric.Level.WARN)) {
            return Metric.Level.WARN;
        }
        return Metric.Level.OK;
    }

    private static boolean evaluateCondition(ResolvedCondition condition, Measure measure, Metric.Level alertLevel) {
        String valueToEval = ConditionUtils.getValueToEval(condition, alertLevel);
        if (StringUtils.isEmpty((String)valueToEval)) {
            return false;
        }
        Comparable criteriaValue = ConditionUtils.getValueForComparison(condition.metric(), valueToEval);
        Comparable measureValue = ConditionUtils.getMeasureValue(condition, measure);
        if (measureValue != null) {
            return ConditionUtils.doesReachThresholds(measureValue, criteriaValue, condition);
        }
        return false;
    }

    private static boolean doesReachThresholds(Comparable measureValue, Comparable criteriaValue, ResolvedCondition condition) {
        int comparison = measureValue.compareTo(criteriaValue);
        return !ConditionUtils.isNotEquals(comparison, condition) && !ConditionUtils.isGreater(comparison, condition) && !ConditionUtils.isSmaller(comparison, condition) && !ConditionUtils.isEquals(comparison, condition);
    }

    private static boolean isNotEquals(int comparison, ResolvedCondition condition) {
        return "NE".equals(condition.operator()) && comparison == 0;
    }

    private static boolean isGreater(int comparison, ResolvedCondition condition) {
        return "GT".equals(condition.operator()) && comparison != 1;
    }

    private static boolean isSmaller(int comparison, ResolvedCondition condition) {
        return "LT".equals(condition.operator()) && comparison != -1;
    }

    private static boolean isEquals(int comparison, ResolvedCondition condition) {
        return "EQ".equals(condition.operator()) && comparison != 0;
    }

    private static String getValueToEval(ResolvedCondition condition, Metric.Level alertLevel) {
        if (alertLevel.equals((Object)Metric.Level.ERROR)) {
            return condition.errorThreshold();
        }
        if (alertLevel.equals((Object)Metric.Level.WARN)) {
            return condition.warningThreshold();
        }
        throw new IllegalStateException(alertLevel.toString());
    }

    private static Comparable getValueForComparison(Metric metric, String value) {
        Object valueToCompare;
        block7: {
            valueToCompare = null;
            try {
                if (ConditionUtils.isADouble(metric)) {
                    valueToCompare = Double.parseDouble(value);
                    break block7;
                }
                if (ConditionUtils.isAInteger(metric)) {
                    valueToCompare = ConditionUtils.parseInteger(value);
                    break block7;
                }
                if (ConditionUtils.isAString(metric)) {
                    valueToCompare = value;
                    break block7;
                }
                if (ConditionUtils.isABoolean(metric)) {
                    valueToCompare = Integer.parseInt(value);
                    break block7;
                }
                if (ConditionUtils.isAWorkDuration(metric)) {
                    valueToCompare = Long.parseLong(value);
                    break block7;
                }
                throw new NotImplementedException(metric.getType().toString());
            }
            catch (NumberFormatException badValueFormat) {
                throw new IllegalArgumentException(String.format("Quality Gate: Unable to parse value '%s' to compare against %s", value, metric.getName()));
            }
        }
        return valueToCompare;
    }

    private static Comparable<Integer> parseInteger(String value) {
        return value.contains(".") ? Integer.parseInt(value.substring(0, value.indexOf(46))) : Integer.parseInt(value);
    }

    private static Comparable getMeasureValue(ResolvedCondition condition, Measure measure) {
        Metric metric = condition.metric();
        if (ConditionUtils.isADouble(metric)) {
            return ConditionUtils.getValue(condition, measure);
        }
        if (ConditionUtils.isAInteger(metric)) {
            return ConditionUtils.parseInteger(condition, measure);
        }
        if (ConditionUtils.isAWorkDuration(metric)) {
            return ConditionUtils.parseLong(condition, measure);
        }
        if (condition.period() == null) {
            return ConditionUtils.getMeasureValueForStringOrBoolean(metric, measure);
        }
        throw new NotImplementedException(metric.getType().toString());
    }

    private static Comparable getMeasureValueForStringOrBoolean(Metric metric, Measure measure) {
        if (ConditionUtils.isAString(metric)) {
            return measure.getData();
        }
        if (ConditionUtils.isABoolean(metric)) {
            return Integer.valueOf(measure.getValue().intValue());
        }
        throw new NotImplementedException(metric.getType().toString());
    }

    private static Comparable<Integer> parseInteger(ResolvedCondition condition, Measure measure) {
        Double value = ConditionUtils.getValue(condition, measure);
        return value != null ? Integer.valueOf(value.intValue()) : null;
    }

    private static Comparable<Long> parseLong(ResolvedCondition condition, Measure measure) {
        Double value = ConditionUtils.getValue(condition, measure);
        return value != null ? Long.valueOf(value.longValue()) : null;
    }

    private static boolean isADouble(Metric metric) {
        return metric.getType() == Metric.ValueType.FLOAT || metric.getType() == Metric.ValueType.PERCENT || metric.getType() == Metric.ValueType.RATING;
    }

    private static boolean isAInteger(Metric metric) {
        return metric.getType() == Metric.ValueType.INT || metric.getType() == Metric.ValueType.MILLISEC;
    }

    private static boolean isAString(Metric metric) {
        return metric.getType() == Metric.ValueType.STRING || metric.getType() == Metric.ValueType.LEVEL;
    }

    private static boolean isABoolean(Metric metric) {
        return metric.getType() == Metric.ValueType.BOOL;
    }

    private static boolean isAWorkDuration(Metric metric) {
        return metric.getType() == Metric.ValueType.WORK_DUR;
    }

    static Double getValue(ResolvedCondition condition, Measure measure) {
        Double value;
        Integer period = condition.period();
        if (period == null) {
            value = measure.getValue();
        } else {
            switch (period) {
                case 1: {
                    value = measure.getVariation1();
                    break;
                }
                case 2: {
                    value = measure.getVariation2();
                    break;
                }
                case 3: {
                    value = measure.getVariation3();
                    break;
                }
                case 4: {
                    value = measure.getVariation4();
                    break;
                }
                case 5: {
                    value = measure.getVariation5();
                    break;
                }
                default: {
                    throw new IllegalStateException("Following index period is not allowed : " + Double.toString(period.intValue()));
                }
            }
        }
        return value;
    }
}

