/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.qualitygate;

import java.util.List;
import org.sonar.api.batch.Decorator;
import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.batch.TimeMachine;
import org.sonar.api.batch.TimeMachineQuery;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.Metric;
import org.sonar.api.notifications.Notification;
import org.sonar.api.notifications.NotificationManager;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.resources.ResourceUtils;
import org.sonar.batch.qualitygate.QualityGate;

public class GenerateQualityGateEvents
implements Decorator {
    private final QualityGate qualityGate;
    private final TimeMachine timeMachine;
    private NotificationManager notificationManager;

    public GenerateQualityGateEvents(QualityGate qualityGate, TimeMachine timeMachine, NotificationManager notificationManager) {
        this.qualityGate = qualityGate;
        this.timeMachine = timeMachine;
        this.notificationManager = notificationManager;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return this.qualityGate.isEnabled();
    }

    @DependsUpon
    public Metric dependsUponAlertStatus() {
        return CoreMetrics.ALERT_STATUS;
    }

    public void decorate(Resource resource, DecoratorContext context) {
        if (!this.shouldDecorateResource(resource)) {
            return;
        }
        Measure currentStatus = context.getMeasure(CoreMetrics.ALERT_STATUS);
        if (currentStatus == null) {
            return;
        }
        TimeMachineQuery query = new TimeMachineQuery(resource).setOnlyLastAnalysis(true).setMetrics(new Metric[]{CoreMetrics.ALERT_STATUS});
        List measures = this.timeMachine.getMeasures(query);
        Measure pastStatus = measures != null && measures.size() == 1 ? (Measure)measures.get(0) : null;
        this.checkQualityGateStatusChange(resource, context, currentStatus, pastStatus);
    }

    private void checkQualityGateStatusChange(Resource resource, DecoratorContext context, Measure currentStatus, Measure pastStatus) {
        String alertText = currentStatus.getAlertText();
        Metric.Level alertLevel = currentStatus.getDataAsLevel();
        String alertName = null;
        boolean isNewAlert = true;
        if (pastStatus != null && pastStatus.getDataAsLevel() != alertLevel) {
            alertName = this.getName(pastStatus, currentStatus);
            if (pastStatus.getDataAsLevel() != Metric.Level.OK) {
                isNewAlert = false;
            }
            this.createEvent(context, alertName, alertText);
            this.notifyUsers(resource, alertName, alertText, alertLevel, isNewAlert);
        } else if (pastStatus == null && alertLevel != Metric.Level.OK) {
            alertName = this.getName(currentStatus);
            this.createEvent(context, alertName, alertText);
            this.notifyUsers(resource, alertName, alertText, alertLevel, isNewAlert);
        }
    }

    protected void notifyUsers(Resource resource, String alertName, String alertText, Metric.Level alertLevel, boolean isNewAlert) {
        Notification notification = new Notification("alerts").setDefaultMessage("Alert on " + resource.getLongName() + ": " + alertName).setFieldValue("projectName", resource.getLongName()).setFieldValue("projectKey", resource.getKey()).setFieldValue("projectId", String.valueOf(resource.getId())).setFieldValue("alertName", alertName).setFieldValue("alertText", alertText).setFieldValue("alertLevel", alertLevel.toString()).setFieldValue("isNewAlert", Boolean.toString(isNewAlert));
        this.notificationManager.scheduleForSending(notification);
    }

    private boolean shouldDecorateResource(Resource resource) {
        return ResourceUtils.isRootProject((Resource)resource);
    }

    private String getName(Measure pastStatus, Measure currentStatus) {
        return this.getName(currentStatus) + " (was " + this.getName(pastStatus) + ")";
    }

    private String getName(Measure currentStatus) {
        return currentStatus.getDataAsLevel().getColorName();
    }

    private void createEvent(DecoratorContext context, String name, String description) {
        context.createEvent(name, description, "Alert", null);
    }
}

