/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.rule;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.BatchComponent;
import org.sonar.api.config.Settings;
import org.sonar.api.utils.MessageException;
import org.sonar.batch.languages.Language;
import org.sonar.batch.languages.LanguagesReferential;
import org.sonar.batch.rule.QProfile;
import org.sonar.batch.rules.QProfilesReferential;

public class ModuleQProfiles
implements BatchComponent {
    public static final String SONAR_PROFILE_PROP = "sonar.profile";
    private final Map<String, QProfile> byLanguage;

    public ModuleQProfiles(Settings settings, LanguagesReferential languages, QProfilesReferential qProfileRef) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        String defaultName = settings.getString(SONAR_PROFILE_PROP);
        for (Language language : languages.all()) {
            QProfile profile = null;
            if (StringUtils.isNotBlank((String)defaultName)) {
                profile = this.loadDefaultQProfile(qProfileRef, defaultName, language.key());
            }
            if (profile == null) {
                profile = this.loadQProfile(qProfileRef, settings, language.key());
            }
            if (profile == null) continue;
            builder.put((Object)profile.getLanguage(), (Object)profile);
        }
        this.byLanguage = builder.build();
    }

    @CheckForNull
    private QProfile loadQProfile(QProfilesReferential qProfileRef, Settings settings, String language) {
        String profileName = settings.getString("sonar.profile." + language);
        if (profileName != null) {
            QProfile dto = qProfileRef.get(language, profileName);
            if (dto == null) {
                throw MessageException.of((String)String.format("Quality profile not found : '%s' on language '%s'", profileName, language));
            }
            return dto;
        }
        return null;
    }

    @CheckForNull
    private QProfile loadDefaultQProfile(QProfilesReferential qProfileRef, String profileName, String language) {
        return qProfileRef.get(language, profileName);
    }

    public Collection<QProfile> findAll() {
        return this.byLanguage.values();
    }

    @CheckForNull
    public QProfile findByLanguage(String language) {
        return this.byLanguage.get(language);
    }
}

