/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.rule;

import com.google.common.collect.ArrayListMultimap;
import java.util.List;
import javax.annotation.Nullable;
import org.picocontainer.injectors.ProviderAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.debt.DebtCharacteristic;
import org.sonar.api.batch.debt.DebtModel;
import org.sonar.api.batch.debt.DebtRemediationFunction;
import org.sonar.api.batch.debt.internal.DefaultDebtModel;
import org.sonar.api.batch.rule.Rules;
import org.sonar.api.batch.rule.internal.NewRule;
import org.sonar.api.batch.rule.internal.RulesBuilder;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.utils.Duration;
import org.sonar.api.utils.Durations;
import org.sonar.api.utils.TimeProfiler;
import org.sonar.core.rule.RuleDao;
import org.sonar.core.rule.RuleDto;
import org.sonar.core.rule.RuleParamDto;

public class RulesProvider
extends ProviderAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(RulesProvider.class);
    private Rules singleton = null;

    public Rules provide(RuleDao ruleDao, DebtModel debtModel, Durations durations) {
        if (this.singleton == null) {
            TimeProfiler profiler = new TimeProfiler(LOG).start("Loading rules");
            this.singleton = this.load(ruleDao, (DefaultDebtModel)debtModel, durations);
            profiler.stop();
        }
        return this.singleton;
    }

    private Rules load(RuleDao ruleDao, DefaultDebtModel debtModel, Durations durations) {
        RulesBuilder rulesBuilder = new RulesBuilder();
        List ruleParamDtos = ruleDao.selectParameters();
        ArrayListMultimap paramDtosByRuleId = ArrayListMultimap.create();
        for (RuleParamDto dto : ruleParamDtos) {
            paramDtosByRuleId.put((Object)dto.getRuleId(), (Object)dto);
        }
        for (RuleDto ruleDto : ruleDao.selectEnablesAndNonManual()) {
            RuleKey ruleKey = RuleKey.of((String)ruleDto.getRepositoryKey(), (String)ruleDto.getRuleKey());
            NewRule newRule = rulesBuilder.add(ruleKey).setId(ruleDto.getId()).setName(ruleDto.getName()).setSeverity(ruleDto.getSeverityString()).setDescription(ruleDto.getDescription()).setStatus(ruleDto.getStatus()).setInternalKey(ruleDto.getConfigKey());
            if (this.hasCharacteristic(ruleDto)) {
                newRule.setDebtSubCharacteristic(this.effectiveCharacteristic(ruleDto, ruleKey, debtModel).key());
                newRule.setDebtRemediationFunction(this.effectiveFunction(ruleDto, ruleKey, durations));
            }
            for (RuleParamDto ruleParamDto : paramDtosByRuleId.get((Object)ruleDto.getId())) {
                newRule.addParam(ruleParamDto.getName()).setDescription(ruleParamDto.getDescription());
            }
        }
        return rulesBuilder.build();
    }

    private DebtCharacteristic effectiveCharacteristic(RuleDto ruleDto, RuleKey ruleKey, DefaultDebtModel debtModel) {
        Integer subCharacteristicId = ruleDto.getSubCharacteristicId();
        Integer defaultSubCharacteristicId = ruleDto.getDefaultSubCharacteristicId();
        Integer effectiveSubCharacteristicId = subCharacteristicId != null ? subCharacteristicId : defaultSubCharacteristicId;
        DebtCharacteristic subCharacteristic = debtModel.characteristicById(effectiveSubCharacteristicId.intValue());
        if (subCharacteristic == null) {
            throw new IllegalStateException(String.format("Sub characteristic id '%s' on rule '%s' has not been found", effectiveSubCharacteristicId, ruleKey));
        }
        return subCharacteristic;
    }

    private DebtRemediationFunction effectiveFunction(RuleDto ruleDto, RuleKey ruleKey, Durations durations) {
        String function = ruleDto.getRemediationFunction();
        String defaultFunction = ruleDto.getDefaultRemediationFunction();
        if (function != null) {
            return this.createDebtRemediationFunction(function, ruleDto.getRemediationCoefficient(), ruleDto.getRemediationOffset(), durations);
        }
        if (defaultFunction != null) {
            return this.createDebtRemediationFunction(defaultFunction, ruleDto.getDefaultRemediationCoefficient(), ruleDto.getDefaultRemediationOffset(), durations);
        }
        throw new IllegalStateException(String.format("Remediation function should not be null on rule '%s'", ruleKey));
    }

    private DebtRemediationFunction createDebtRemediationFunction(String function, @Nullable String factor, @Nullable String offset, Durations durations) {
        return DebtRemediationFunction.create((DebtRemediationFunction.Type)DebtRemediationFunction.Type.valueOf((String)function), (Duration)(factor != null ? durations.decode(factor) : null), offset != null ? durations.decode(offset) : null);
    }

    private boolean hasCharacteristic(RuleDto ruleDto) {
        Integer subCharacteristicId = ruleDto.getSubCharacteristicId();
        return subCharacteristicId == null && ruleDto.getDefaultSubCharacteristicId() != null || subCharacteristicId != null && !RuleDto.DISABLED_CHARACTERISTIC_ID.equals(subCharacteristicId);
    }
}

