/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan;

import java.io.Serializable;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.batch.analyzer.AnalyzerContext;
import org.sonar.api.batch.analyzer.issue.AnalyzerIssue;
import org.sonar.api.batch.analyzer.issue.AnalyzerIssueBuilder;
import org.sonar.api.batch.analyzer.issue.internal.DefaultAnalyzerIssueBuilder;
import org.sonar.api.batch.analyzer.measure.AnalyzerMeasure;
import org.sonar.api.batch.analyzer.measure.AnalyzerMeasureBuilder;
import org.sonar.api.batch.analyzer.measure.internal.DefaultAnalyzerMeasureBuilder;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.measure.Metric;
import org.sonar.api.batch.rule.ActiveRules;
import org.sonar.api.component.ResourcePerspectives;
import org.sonar.api.config.Settings;
import org.sonar.api.issue.Issuable;
import org.sonar.api.issue.Issue;
import org.sonar.api.issue.internal.DefaultIssue;
import org.sonar.api.measures.Formula;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.MetricFinder;
import org.sonar.api.measures.PersistenceMode;
import org.sonar.api.measures.SumChildDistributionFormula;
import org.sonar.api.resources.File;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.resources.Scopes;
import org.sonar.api.rule.RuleKey;
import org.sonar.core.issue.DefaultIssueBuilder;

public class AnalyzerContextAdaptor
implements AnalyzerContext {
    private SensorContext sensorContext;
    private MetricFinder metricFinder;
    private Project project;
    private ResourcePerspectives perspectives;
    private Settings settings;
    private FileSystem fs;
    private ActiveRules activeRules;

    public AnalyzerContextAdaptor(SensorContext sensorContext, MetricFinder metricFinder, Project project, ResourcePerspectives perspectives, Settings settings, FileSystem fs, ActiveRules activeRules) {
        this.sensorContext = sensorContext;
        this.metricFinder = metricFinder;
        this.project = project;
        this.perspectives = perspectives;
        this.settings = settings;
        this.fs = fs;
        this.activeRules = activeRules;
    }

    public Settings settings() {
        return this.settings;
    }

    public FileSystem fileSystem() {
        return this.fs;
    }

    public ActiveRules activeRules() {
        return this.activeRules;
    }

    public <G extends Serializable> AnalyzerMeasureBuilder<G> measureBuilder() {
        return new DefaultAnalyzerMeasureBuilder();
    }

    public AnalyzerMeasure getMeasure(String metricKey) {
        Metric<?> m = this.findMetricOrFail(metricKey);
        return this.getMeasure(m);
    }

    public <G extends Serializable> AnalyzerMeasure<G> getMeasure(Metric<G> metric) {
        org.sonar.api.measures.Metric m = (org.sonar.api.measures.Metric)this.findMetricOrFail(metric.key());
        Measure measure = this.sensorContext.getMeasure(m);
        if (measure == null) {
            return null;
        }
        return this.measureBuilder().onProject().forMetric(metric).withValue(measure.value()).build();
    }

    public AnalyzerMeasure getMeasure(InputFile file, String metricKey) {
        Metric<?> m = this.findMetricOrFail(metricKey);
        return this.getMeasure(file, m);
    }

    private Metric<?> findMetricOrFail(String metricKey) {
        org.sonar.api.measures.Metric m = this.metricFinder.findByKey(metricKey);
        if (m == null) {
            throw new IllegalStateException("Unknow metric with key: " + metricKey);
        }
        return m;
    }

    public <G extends Serializable> AnalyzerMeasure<G> getMeasure(InputFile file, Metric<G> metric) {
        org.sonar.api.measures.Metric m;
        File fileRes = File.create((String)file.relativePath());
        Measure measure = this.sensorContext.getMeasure((Resource)fileRes, m = (org.sonar.api.measures.Metric)this.findMetricOrFail(metric.key()));
        if (measure == null) {
            return null;
        }
        return this.measureBuilder().onFile(file).forMetric(metric).withValue(measure.value()).build();
    }

    public void addMeasure(AnalyzerMeasure<?> measure) {
        org.sonar.api.measures.Metric m = this.metricFinder.findByKey(measure.metric().key());
        if (m == null) {
            throw new IllegalStateException("Unknow metric with key: " + measure.metric().key());
        }
        Measure measureToSave = new Measure(m);
        this.setValueAccordingToMetricType(measure, m, measureToSave);
        if (measure.inputFile() != null) {
            Formula formula;
            Formula formula2 = formula = measure.metric() instanceof org.sonar.api.measures.Metric ? ((org.sonar.api.measures.Metric)measure.metric()).getFormula() : null;
            if (formula instanceof SumChildDistributionFormula && !Scopes.isHigherThanOrEquals((String)"FIL", (String)((SumChildDistributionFormula)formula).getMinimumScopeToPersist())) {
                measureToSave.setPersistenceMode(PersistenceMode.MEMORY);
            }
            this.sensorContext.saveMeasure(measure.inputFile(), measureToSave);
        } else {
            this.sensorContext.saveMeasure(measureToSave);
        }
    }

    private void setValueAccordingToMetricType(AnalyzerMeasure<?> measure, org.sonar.api.measures.Metric<?> m, Measure measureToSave) {
        switch (m.getType()) {
            case BOOL: {
                measureToSave.setValue(Double.valueOf(Boolean.TRUE.equals(measure.value()) ? 1.0 : 0.0));
                break;
            }
            case INT: 
            case MILLISEC: {
                measureToSave.setValue(Double.valueOf(((Integer)measure.value()).intValue()));
                break;
            }
            case FLOAT: 
            case PERCENT: 
            case RATING: {
                measureToSave.setValue((Double)measure.value());
                break;
            }
            case STRING: 
            case LEVEL: 
            case DATA: 
            case DISTRIB: {
                measureToSave.setData((String)((Object)measure.value()));
                break;
            }
            case WORK_DUR: {
                measureToSave.setValue(Double.valueOf(((Long)measure.value()).longValue()));
                break;
            }
            default: {
                if (m.isNumericType()) {
                    measureToSave.setValue((Double)measure.value());
                    break;
                }
                if (m.isDataType()) {
                    measureToSave.setData((String)((Object)measure.value()));
                    break;
                }
                throw new UnsupportedOperationException("Unsupported type :" + m.getType());
            }
        }
    }

    public AnalyzerIssueBuilder issueBuilder() {
        return new DefaultAnalyzerIssueBuilder();
    }

    public boolean addIssue(AnalyzerIssue issue) {
        InputFile inputFile = issue.inputFile();
        Object r = inputFile != null ? File.create((String)inputFile.relativePath()) : this.project;
        Issuable issuable = (Issuable)this.perspectives.as(Issuable.class, (Resource)r);
        return issuable.addIssue((Issue)AnalyzerContextAdaptor.toDefaultIssue(this.project.getKey(), r.getKey(), issue));
    }

    public static DefaultIssue toDefaultIssue(String projectKey, String componentKey, AnalyzerIssue issue) {
        return new DefaultIssueBuilder().componentKey(componentKey).projectKey(projectKey).ruleKey(RuleKey.of((String)issue.ruleKey().repository(), (String)issue.ruleKey().rule())).effortToFix(issue.effortToFix()).line(issue.line()).message(issue.message()).build();
    }
}

