/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan;

import com.google.common.annotations.VisibleForTesting;
import org.sonar.api.BatchComponent;
import org.sonar.api.batch.bootstrap.ProjectBootstrapper;
import org.sonar.api.batch.bootstrap.ProjectReactor;
import org.sonar.api.config.Settings;
import org.sonar.api.platform.ComponentContainer;
import org.sonar.api.resources.Languages;
import org.sonar.api.resources.Project;
import org.sonar.api.scan.filesystem.PathResolver;
import org.sonar.api.utils.SonarException;
import org.sonar.batch.DefaultFileLinesContextFactory;
import org.sonar.batch.DefaultResourceCreationLock;
import org.sonar.batch.ProjectConfigurator;
import org.sonar.batch.ProjectTree;
import org.sonar.batch.bootstrap.ExtensionInstaller;
import org.sonar.batch.bootstrap.ExtensionMatcher;
import org.sonar.batch.bootstrap.ExtensionUtils;
import org.sonar.batch.bootstrap.MetricProvider;
import org.sonar.batch.components.PeriodsDefinition;
import org.sonar.batch.debt.IssueChangelogDebtCalculator;
import org.sonar.batch.index.Caches;
import org.sonar.batch.index.ComponentDataCache;
import org.sonar.batch.index.ComponentDataPersister;
import org.sonar.batch.index.DefaultIndex;
import org.sonar.batch.index.DefaultPersistenceManager;
import org.sonar.batch.index.DefaultResourcePersister;
import org.sonar.batch.index.DependencyPersister;
import org.sonar.batch.index.EventPersister;
import org.sonar.batch.index.LinkPersister;
import org.sonar.batch.index.MeasurePersister;
import org.sonar.batch.index.ResourceCache;
import org.sonar.batch.index.ResourceKeyMigration;
import org.sonar.batch.index.SnapshotCache;
import org.sonar.batch.index.SourcePersister;
import org.sonar.batch.issue.DefaultProjectIssues;
import org.sonar.batch.issue.DeprecatedViolations;
import org.sonar.batch.issue.IssueCache;
import org.sonar.batch.issue.IssuePersister;
import org.sonar.batch.issue.ScanIssueStorage;
import org.sonar.batch.languages.DeprecatedLanguagesReferential;
import org.sonar.batch.phases.GraphPersister;
import org.sonar.batch.profiling.PhasesSumUpTimeProfiler;
import org.sonar.batch.scan.LastSnapshots;
import org.sonar.batch.scan.ModuleScanContainer;
import org.sonar.batch.scan.ProjectLock;
import org.sonar.batch.scan.ProjectReactorBuilder;
import org.sonar.batch.scan.ProjectSettingsReady;
import org.sonar.batch.scan.filesystem.InputFileCache;
import org.sonar.batch.scan.maven.FakeMavenPluginExecutor;
import org.sonar.batch.scan.maven.MavenPluginExecutor;
import org.sonar.batch.scan.measure.MeasureCache;
import org.sonar.batch.source.HighlightableBuilder;
import org.sonar.batch.source.SymbolizableBuilder;
import org.sonar.core.component.ScanGraph;
import org.sonar.core.issue.IssueNotifications;
import org.sonar.core.issue.IssueUpdater;
import org.sonar.core.issue.workflow.FunctionExecutor;
import org.sonar.core.issue.workflow.IssueWorkflow;
import org.sonar.core.notification.DefaultNotificationManager;
import org.sonar.core.technicaldebt.DefaultTechnicalDebtModel;
import org.sonar.core.test.TestPlanBuilder;
import org.sonar.core.test.TestPlanPerspectiveLoader;
import org.sonar.core.test.TestableBuilder;
import org.sonar.core.test.TestablePerspectiveLoader;
import org.sonar.core.user.DefaultUserFinder;

public class ProjectScanContainer
extends ComponentContainer {
    public ProjectScanContainer(ComponentContainer taskContainer) {
        super(taskContainer);
    }

    protected void doBeforeStart() {
        this.projectBootstrap();
        this.addBatchComponents();
        this.fixMavenExecutor();
        this.addBatchExtensions();
        Settings settings = (Settings)this.getComponentByType(Settings.class);
        if (settings != null && settings.getBoolean("sonar.showProfiling")) {
            this.add(new Object[]{PhasesSumUpTimeProfiler.class});
        }
    }

    private void projectBootstrap() {
        ProjectReactor reactor = (ProjectReactor)this.getComponentByType(ProjectReactor.class);
        if (reactor == null) {
            ProjectBootstrapper bootstrapper = (ProjectBootstrapper)this.getComponentByType(ProjectBootstrapper.class);
            Settings settings = (Settings)this.getComponentByType(Settings.class);
            if (bootstrapper == null || "true".equals(settings.getString("sonar.mojoUseRunner"))) {
                ProjectReactorBuilder builder = (ProjectReactorBuilder)this.getComponentByType(ProjectReactorBuilder.class);
                reactor = builder.execute();
            } else {
                reactor = bootstrapper.bootstrap();
            }
            if (reactor == null) {
                throw new SonarException(bootstrapper + " has returned null as ProjectReactor");
            }
            this.add(new Object[]{reactor});
        }
    }

    private void addBatchComponents() {
        this.add(new Object[]{DefaultResourceCreationLock.class, DefaultPersistenceManager.class, DependencyPersister.class, EventPersister.class, LinkPersister.class, MeasurePersister.class, DefaultResourcePersister.class, SourcePersister.class, DefaultNotificationManager.class, MetricProvider.class, ProjectConfigurator.class, DefaultIndex.class, ResourceKeyMigration.class, DefaultFileLinesContextFactory.class, ProjectLock.class, LastSnapshots.class, Caches.class, SnapshotCache.class, ResourceCache.class, ComponentDataCache.class, ComponentDataPersister.class, DefaultUserFinder.class, InputFileCache.class, PathResolver.class, IssueUpdater.class, FunctionExecutor.class, IssueWorkflow.class, DeprecatedViolations.class, IssueCache.class, ScanIssueStorage.class, IssuePersister.class, IssueNotifications.class, DefaultProjectIssues.class, IssueChangelogDebtCalculator.class, TestPlanPerspectiveLoader.class, TestablePerspectiveLoader.class, TestPlanBuilder.class, TestableBuilder.class, ScanGraph.create(), GraphPersister.class, Languages.class, DeprecatedLanguagesReferential.class, HighlightableBuilder.class, SymbolizableBuilder.class, DefaultTechnicalDebtModel.class, PeriodsDefinition.class, MeasureCache.class, ProjectSettingsReady.class});
    }

    private void fixMavenExecutor() {
        if (this.getComponentByType(MavenPluginExecutor.class) == null) {
            this.add(new Object[]{FakeMavenPluginExecutor.class});
        }
    }

    private void addBatchExtensions() {
        ((ExtensionInstaller)this.getComponentByType(ExtensionInstaller.class)).install(this, new BatchExtensionFilter());
    }

    protected void doAfterStart() {
        ProjectTree tree = (ProjectTree)this.getComponentByType(ProjectTree.class);
        this.scanRecursively(tree.getRootProject());
    }

    private void scanRecursively(Project module) {
        for (Project subModules : module.getModules()) {
            this.scanRecursively(subModules);
        }
        this.scan(module);
    }

    @VisibleForTesting
    void scan(Project module) {
        new ModuleScanContainer(this, module).execute();
    }

    static class BatchExtensionFilter
    implements ExtensionMatcher {
        BatchExtensionFilter() {
        }

        @Override
        public boolean accept(Object extension) {
            return ExtensionUtils.isType(extension, BatchComponent.class) && ExtensionUtils.isInstantiationStrategy(extension, "PER_BATCH");
        }
    }
}

