/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan.filesystem;

import org.apache.commons.io.FilenameUtils;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DeprecatedDefaultInputFile;

class AdditionalFilePredicates {
    private AdditionalFilePredicates() {
    }

    static class SourceDirPredicate
    implements FilePredicate {
        private final String path;

        SourceDirPredicate(String s) {
            this.path = FilenameUtils.normalize((String)s, (boolean)true);
        }

        public boolean apply(InputFile f) {
            return this.path.equals(((DeprecatedDefaultInputFile)f).sourceDirAbsolutePath());
        }
    }

    static class SourceRelativePathPredicate
    implements FilePredicate {
        private final String path;

        SourceRelativePathPredicate(String s) {
            this.path = FilenameUtils.normalize((String)s, (boolean)true);
        }

        public boolean apply(InputFile f) {
            return this.path.equals(((DeprecatedDefaultInputFile)f).pathRelativeToSourceDir());
        }
    }

    static class DeprecatedKeyPredicate
    implements FilePredicate {
        private final String key;

        DeprecatedKeyPredicate(String key) {
            this.key = key;
        }

        public boolean apply(InputFile f) {
            return this.key.equals(((DeprecatedDefaultInputFile)f).deprecatedKey());
        }
    }

    static class KeyPredicate
    implements FilePredicate {
        private final String key;

        KeyPredicate(String key) {
            this.key = key;
        }

        public boolean apply(InputFile f) {
            return this.key.equals(((DeprecatedDefaultInputFile)f).key());
        }
    }
}

