/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan.filesystem;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DefaultFileSystem;
import org.sonar.api.config.Settings;
import org.sonar.api.resources.Project;
import org.sonar.api.scan.filesystem.FileQuery;
import org.sonar.api.scan.filesystem.ModuleFileSystem;
import org.sonar.api.utils.MessageException;
import org.sonar.batch.scan.filesystem.AdditionalFilePredicates;
import org.sonar.batch.scan.filesystem.ComponentIndexer;
import org.sonar.batch.scan.filesystem.FileIndexer;
import org.sonar.batch.scan.filesystem.ModuleFileSystemInitializer;
import org.sonar.batch.scan.filesystem.ModuleInputFileCache;

public class DefaultModuleFileSystem
extends DefaultFileSystem
implements ModuleFileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultModuleFileSystem.class);
    private final String moduleKey;
    private final FileIndexer indexer;
    private final Settings settings;
    private File buildDir;
    private List<File> sourceDirs = Lists.newArrayList();
    private List<File> testDirs = Lists.newArrayList();
    private List<File> binaryDirs = Lists.newArrayList();
    private List<File> sourceFiles = Lists.newArrayList();
    private List<File> testFiles = Lists.newArrayList();
    private ComponentIndexer componentIndexer;
    private boolean initialized;

    public DefaultModuleFileSystem(ModuleInputFileCache moduleInputFileCache, ProjectDefinition def, Settings settings, FileIndexer indexer, ModuleFileSystemInitializer initializer) {
        this(moduleInputFileCache, def.getKey(), settings, indexer, initializer, null);
    }

    public DefaultModuleFileSystem(ModuleInputFileCache moduleInputFileCache, ProjectDefinition def, Project project, Settings settings, FileIndexer indexer, ModuleFileSystemInitializer initializer, ComponentIndexer componentIndexer) {
        this(moduleInputFileCache, project.getKey(), settings, indexer, initializer, componentIndexer);
    }

    private DefaultModuleFileSystem(ModuleInputFileCache moduleInputFileCache, String moduleKey, Settings settings, FileIndexer indexer, ModuleFileSystemInitializer initializer, @Nullable ComponentIndexer componentIndexer) {
        super((DefaultFileSystem.Cache)moduleInputFileCache);
        this.componentIndexer = componentIndexer;
        this.moduleKey = moduleKey;
        this.settings = settings;
        this.indexer = indexer;
        if (initializer.baseDir() != null) {
            this.setBaseDir(initializer.baseDir());
        }
        this.setWorkDir(initializer.workingDir());
        this.buildDir = initializer.buildDir();
        this.sourceDirs = initializer.sourceDirs();
        this.testDirs = initializer.testDirs();
        this.binaryDirs = initializer.binaryDirs();
        this.sourceFiles = initializer.additionalSourceFiles();
        this.testFiles = initializer.additionalTestFiles();
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public String moduleKey() {
        return this.moduleKey;
    }

    @CheckForNull
    public File buildDir() {
        return this.buildDir;
    }

    public List<File> sourceDirs() {
        return this.sourceDirs;
    }

    public List<File> testDirs() {
        return this.testDirs;
    }

    public List<File> binaryDirs() {
        return this.binaryDirs;
    }

    List<File> sourceFiles() {
        return this.sourceFiles;
    }

    List<File> testFiles() {
        return this.testFiles;
    }

    public Charset encoding() {
        String encoding = this.settings.getString("sonar.sourceEncoding");
        Charset charset = StringUtils.isNotEmpty((String)encoding) ? Charset.forName(StringUtils.trim((String)encoding)) : Charset.defaultCharset();
        return charset;
    }

    public boolean isDefaultJvmEncoding() {
        return !this.settings.hasKey("sonar.sourceEncoding");
    }

    @Deprecated
    void addSourceDir(File dir) {
        throw this.modificationNotPermitted();
    }

    @Deprecated
    void addTestDir(File dir) {
        throw this.modificationNotPermitted();
    }

    private UnsupportedOperationException modificationNotPermitted() {
        return new UnsupportedOperationException("Modifications of the file system are not permitted");
    }

    @Deprecated
    public Charset sourceCharset() {
        return this.encoding();
    }

    @Deprecated
    public File workingDir() {
        return this.workDir();
    }

    public List<File> files(FileQuery query) {
        this.doPreloadFiles();
        ArrayList predicates = Lists.newArrayList();
        for (Map.Entry entry : query.attributes().entrySet()) {
            predicates.add(this.fromDeprecatedAttribute((String)entry.getKey(), (Collection)entry.getValue()));
        }
        return ImmutableList.copyOf((Iterable)this.files(this.predicates().and((Collection)predicates)));
    }

    protected void doPreloadFiles() {
        if (!this.initialized) {
            LOG.warn("Accessing the filesystem before the Sensor phase is deprecated and will not be supported in the future. Please update your plugin.");
            this.indexer.index(this);
        }
    }

    public void resetDirs(File basedir, File buildDir, List<File> sourceDirs, List<File> testDirs, List<File> binaryDirs) {
        if (this.initialized) {
            throw MessageException.of((String)"Module filesystem is already initialized. Modifications of filesystem are only allowed during Initializer phase.");
        }
        this.setBaseDir(basedir);
        this.buildDir = buildDir;
        this.sourceDirs = this.existingDirs(sourceDirs);
        this.testDirs = this.existingDirs(testDirs);
        this.binaryDirs = this.existingDirs(binaryDirs);
    }

    public void index() {
        if (this.initialized) {
            throw MessageException.of((String)"Module filesystem can only be indexed once");
        }
        this.initialized = true;
        this.indexer.index(this);
        if (this.componentIndexer != null) {
            this.componentIndexer.execute((FileSystem)this);
        }
    }

    private List<File> existingDirs(List<File> dirs) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (File dir : dirs) {
            if (!dir.exists() || !dir.isDirectory()) continue;
            builder.add((Object)dir);
        }
        return builder.build();
    }

    private FilePredicate fromDeprecatedAttribute(String key, Collection<String> value) {
        if ("TYPE".equals(key)) {
            return this.predicates().or(Collections2.transform(value, (Function)new Function<String, FilePredicate>(){

                public FilePredicate apply(@Nullable String s) {
                    return s == null ? DefaultModuleFileSystem.this.predicates().all() : DefaultModuleFileSystem.this.predicates().hasType(InputFile.Type.valueOf((String)s));
                }
            }));
        }
        if ("STATUS".equals(key)) {
            return this.predicates().or(Collections2.transform(value, (Function)new Function<String, FilePredicate>(){

                public FilePredicate apply(@Nullable String s) {
                    return s == null ? DefaultModuleFileSystem.this.predicates().all() : DefaultModuleFileSystem.this.predicates().hasStatus(InputFile.Status.valueOf((String)s));
                }
            }));
        }
        if ("LANG".equals(key)) {
            return this.predicates().or(Collections2.transform(value, (Function)new Function<String, FilePredicate>(){

                public FilePredicate apply(@Nullable String s) {
                    return s == null ? DefaultModuleFileSystem.this.predicates().all() : DefaultModuleFileSystem.this.predicates().hasLanguage(s);
                }
            }));
        }
        if ("CMP_KEY".equals(key)) {
            return this.predicates().or(Collections2.transform(value, (Function)new Function<String, FilePredicate>(){

                public FilePredicate apply(@Nullable String s) {
                    return s == null ? DefaultModuleFileSystem.this.predicates().all() : new AdditionalFilePredicates.KeyPredicate(s);
                }
            }));
        }
        if ("CMP_DEPRECATED_KEY".equals(key)) {
            return this.predicates().or(Collections2.transform(value, (Function)new Function<String, FilePredicate>(){

                public FilePredicate apply(@Nullable String s) {
                    return s == null ? DefaultModuleFileSystem.this.predicates().all() : new AdditionalFilePredicates.DeprecatedKeyPredicate(s);
                }
            }));
        }
        if ("SRC_REL_PATH".equals(key)) {
            return this.predicates().or(Collections2.transform(value, (Function)new Function<String, FilePredicate>(){

                public FilePredicate apply(@Nullable String s) {
                    return s == null ? DefaultModuleFileSystem.this.predicates().all() : new AdditionalFilePredicates.SourceRelativePathPredicate(s);
                }
            }));
        }
        if ("SRC_DIR_PATH".equals(key)) {
            return this.predicates().or(Collections2.transform(value, (Function)new Function<String, FilePredicate>(){

                public FilePredicate apply(@Nullable String s) {
                    return s == null ? DefaultModuleFileSystem.this.predicates().all() : new AdditionalFilePredicates.SourceDirPredicate(s);
                }
            }));
        }
        throw new IllegalArgumentException("Unsupported file attribute: " + key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DefaultModuleFileSystem that = (DefaultModuleFileSystem)((Object)o);
        return this.moduleKey.equals(that.moduleKey);
    }

    public int hashCode() {
        return this.moduleKey.hashCode();
    }
}

