/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan.filesystem;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;

class FileMetadata {
    private static final char LINE_FEED = '\n';
    private static final char CARRIAGE_RETURN = '\r';
    static final FileMetadata INSTANCE = new FileMetadata();

    private FileMetadata() {
    }

    Metadata read(File file, Charset encoding) {
        Metadata metadata;
        BufferedReader reader = null;
        int lines = 0;
        char c = '\uffff';
        try {
            MessageDigest md5Digest = DigestUtils.getMd5Digest();
            md5Digest.reset();
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), encoding));
            int i = ((Reader)reader).read();
            boolean afterCR = true;
            while (i != -1) {
                c = (char)i;
                if (afterCR) {
                    afterCR = false;
                    if (c == '\n') {
                        i = ((Reader)reader).read();
                        continue;
                    }
                }
                if (c == '\r') {
                    afterCR = true;
                    c = '\n';
                }
                if (c == '\n') {
                    ++lines;
                }
                md5Digest.update(this.charToBytesUTF(c));
                i = ((Reader)reader).read();
            }
            if (c != '\uffff') {
                ++lines;
            }
            String hash = Hex.encodeHexString((byte[])md5Digest.digest());
            metadata = new Metadata(lines, hash);
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException(String.format("Fail to read file '%s' with encoding '%s'", file.getAbsolutePath(), encoding), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        return metadata;
    }

    private byte[] charToBytesUTF(char c) {
        char[] buffer = new char[]{c};
        byte[] b = new byte[buffer.length << 1];
        for (int i = 0; i < buffer.length; ++i) {
            int bpos = i << 1;
            b[bpos] = (byte)((buffer[i] & 0xFF00) >> 8);
            b[bpos + 1] = (byte)(buffer[i] & 0xFF);
        }
        return b;
    }

    static class Metadata {
        int lines;
        String hash;

        private Metadata(int lines, String hash) {
            this.lines = lines;
            this.hash = hash;
        }
    }
}

