/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan.filesystem;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchComponent;
import org.sonar.batch.scan.filesystem.DefaultModuleFileSystem;

public class FileSystemLogger
implements BatchComponent {
    private final DefaultModuleFileSystem fs;

    public FileSystemLogger(DefaultModuleFileSystem fs) {
        this.fs = fs;
    }

    public void log() {
        this.doLog(LoggerFactory.getLogger(this.getClass()));
    }

    @VisibleForTesting
    void doLog(Logger logger) {
        this.logDir(logger, "Base dir: ", this.fs.baseDir());
        this.logDir(logger, "Working dir: ", this.fs.workingDir());
        this.logDirs(logger, "Source dirs: ", this.fs.sourceDirs());
        this.logDirs(logger, "Test dirs: ", this.fs.testDirs());
        this.logDirs(logger, "Binary dirs: ", this.fs.binaryDirs());
        this.logEncoding(logger, this.fs.sourceCharset());
    }

    private void logEncoding(Logger logger, Charset charset) {
        if (!this.fs.isDefaultJvmEncoding()) {
            logger.info("Source encoding: " + charset.displayName() + ", default locale: " + Locale.getDefault());
        } else {
            logger.warn("Source encoding is platform dependent (" + charset.displayName() + "), default locale: " + Locale.getDefault());
        }
    }

    private void logDirs(Logger logger, String label, List<File> dirs) {
        if (!dirs.isEmpty()) {
            logger.info(label + Joiner.on((String)", ").join(dirs));
        }
    }

    private void logDir(Logger logger, String label, File dir) {
        if (dir != null) {
            logger.info(label + dir.getAbsolutePath());
        }
    }
}

