/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan.filesystem;

import java.io.File;
import java.util.List;
import javax.annotation.CheckForNull;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DeprecatedDefaultInputFile;
import org.sonar.api.scan.filesystem.PathResolver;
import org.sonar.batch.bootstrap.AnalysisMode;
import org.sonar.batch.scan.filesystem.DefaultModuleFileSystem;
import org.sonar.batch.scan.filesystem.FileMetadata;
import org.sonar.batch.scan.filesystem.LanguageDetection;
import org.sonar.batch.scan.filesystem.StatusDetection;
import org.sonar.batch.util.DeprecatedKeyUtils;

class InputFileBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(InputFileBuilder.class);
    private final String moduleKey;
    private final PathResolver pathResolver;
    private final LanguageDetection langDetection;
    private final StatusDetection statusDetection;
    private final DefaultModuleFileSystem fs;
    private final AnalysisMode analysisMode;

    InputFileBuilder(String moduleKey, PathResolver pathResolver, LanguageDetection langDetection, StatusDetection statusDetection, DefaultModuleFileSystem fs, AnalysisMode analysisMode) {
        this.moduleKey = moduleKey;
        this.pathResolver = pathResolver;
        this.langDetection = langDetection;
        this.statusDetection = statusDetection;
        this.fs = fs;
        this.analysisMode = analysisMode;
    }

    String moduleKey() {
        return this.moduleKey;
    }

    PathResolver pathResolver() {
        return this.pathResolver;
    }

    LanguageDetection langDetection() {
        return this.langDetection;
    }

    StatusDetection statusDetection() {
        return this.statusDetection;
    }

    FileSystem fs() {
        return this.fs;
    }

    @CheckForNull
    DeprecatedDefaultInputFile create(File file) {
        String relativePath = this.pathResolver.relativePath(this.fs.baseDir(), file);
        if (relativePath == null) {
            LOG.warn("File '{}' is ignored. It is not located in module basedir '{}'.", (Object)file.getAbsolutePath(), (Object)this.fs.baseDir());
            return null;
        }
        DeprecatedDefaultInputFile inputFile = new DeprecatedDefaultInputFile(relativePath);
        inputFile.setBasedir(this.fs.baseDir());
        inputFile.setFile(file);
        return inputFile;
    }

    @CheckForNull
    DeprecatedDefaultInputFile complete(DeprecatedDefaultInputFile inputFile, InputFile.Type type) {
        inputFile.setType(type);
        inputFile.setKey(this.moduleKey + ":" + inputFile.relativePath());
        inputFile.setBasedir(this.fs.baseDir());
        FileMetadata.Metadata metadata = FileMetadata.INSTANCE.read(inputFile.file(), this.fs.encoding());
        inputFile.setLines(metadata.lines);
        inputFile.setHash(metadata.hash);
        inputFile.setStatus(this.statusDetection.status(inputFile.relativePath(), metadata.hash));
        if (this.analysisMode.isIncremental() && inputFile.status() == InputFile.Status.SAME) {
            return null;
        }
        String lang = this.langDetection.language((InputFile)inputFile);
        if (lang == null) {
            return null;
        }
        inputFile.setLanguage(lang);
        this.fillDeprecatedData(inputFile);
        return inputFile;
    }

    private void fillDeprecatedData(DeprecatedDefaultInputFile inputFile) {
        List<File> sourceDirs = InputFile.Type.MAIN == inputFile.type() ? this.fs.sourceDirs() : this.fs.testDirs();
        for (File sourceDir : sourceDirs) {
            String sourceRelativePath = this.pathResolver.relativePath(sourceDir, inputFile.file());
            if (sourceRelativePath == null) continue;
            inputFile.setPathRelativeToSourceDir(sourceRelativePath);
            inputFile.setSourceDirAbsolutePath(FilenameUtils.normalize((String)sourceDir.getAbsolutePath(), (boolean)true));
            if ("java".equals(inputFile.language())) {
                inputFile.setDeprecatedKey(this.moduleKey + ":" + DeprecatedKeyUtils.getJavaFileDeprecatedKey(sourceRelativePath));
                continue;
            }
            inputFile.setDeprecatedKey(this.moduleKey + ":" + sourceRelativePath);
        }
    }
}

