/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan.filesystem;

import org.sonar.api.BatchComponent;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.resources.Project;
import org.sonar.api.scan.filesystem.PathResolver;
import org.sonar.batch.bootstrap.AnalysisMode;
import org.sonar.batch.scan.filesystem.DefaultModuleFileSystem;
import org.sonar.batch.scan.filesystem.InputFileBuilder;
import org.sonar.batch.scan.filesystem.LanguageDetectionFactory;
import org.sonar.batch.scan.filesystem.StatusDetectionFactory;

public class InputFileBuilderFactory
implements BatchComponent {
    private final String moduleKey;
    private final PathResolver pathResolver;
    private final LanguageDetectionFactory langDetectionFactory;
    private final StatusDetectionFactory statusDetectionFactory;
    private final AnalysisMode analysisMode;

    public InputFileBuilderFactory(Project module, ProjectDefinition def, PathResolver pathResolver, LanguageDetectionFactory langDetectionFactory, StatusDetectionFactory statusDetectionFactory, AnalysisMode analysisMode) {
        this(module.getEffectiveKey(), pathResolver, langDetectionFactory, statusDetectionFactory, analysisMode);
    }

    public InputFileBuilderFactory(ProjectDefinition def, PathResolver pathResolver, LanguageDetectionFactory langDetectionFactory, StatusDetectionFactory statusDetectionFactory, AnalysisMode analysisMode) {
        this(def.getKey(), pathResolver, langDetectionFactory, statusDetectionFactory, analysisMode);
    }

    private InputFileBuilderFactory(String effectiveKey, PathResolver pathResolver, LanguageDetectionFactory langDetectionFactory, StatusDetectionFactory statusDetectionFactory, AnalysisMode analysisMode) {
        this.moduleKey = effectiveKey;
        this.pathResolver = pathResolver;
        this.langDetectionFactory = langDetectionFactory;
        this.statusDetectionFactory = statusDetectionFactory;
        this.analysisMode = analysisMode;
    }

    InputFileBuilder create(DefaultModuleFileSystem fs) {
        return new InputFileBuilder(this.moduleKey, this.pathResolver, this.langDetectionFactory.create(), this.statusDetectionFactory.create(), fs, this.analysisMode);
    }
}

