/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan.filesystem;

import javax.annotation.CheckForNull;
import org.sonar.api.BatchComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.batch.index.Cache;
import org.sonar.batch.index.Caches;

public class InputFileCache
implements BatchComponent {
    private final Cache<InputFile> cache;

    public InputFileCache(Caches caches) {
        this.cache = caches.createCache("inputFiles");
    }

    public Iterable<InputFile> all() {
        return this.cache.values();
    }

    public Iterable<InputFile> byModule(String moduleKey) {
        return this.cache.values(moduleKey);
    }

    public InputFileCache removeModule(String moduleKey) {
        this.cache.clear(moduleKey);
        return this;
    }

    public InputFileCache remove(String moduleKey, InputFile inputFile) {
        this.cache.remove(moduleKey, inputFile.relativePath());
        return this;
    }

    public InputFileCache put(String moduleKey, InputFile inputFile) {
        this.cache.put(moduleKey, inputFile.relativePath(), inputFile);
        return this;
    }

    @CheckForNull
    public InputFile get(String moduleKey, String relativePath) {
        return this.cache.get(moduleKey, relativePath);
    }
}

