/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan.filesystem;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.fs.InputFile;

class StatusDetection {
    private final Map<String, String> previousHashByRelativePath;

    StatusDetection(Map<String, String> previousHashByRelativePath) {
        this.previousHashByRelativePath = previousHashByRelativePath;
    }

    InputFile.Status status(String relativePath, String hash) {
        String previousHash = this.previousHashByRelativePath.get(relativePath);
        if (StringUtils.equals((String)hash, (String)previousHash)) {
            return InputFile.Status.SAME;
        }
        if (StringUtils.isEmpty((String)previousHash)) {
            return InputFile.Status.ADDED;
        }
        return InputFile.Status.CHANGED;
    }
}

