/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan.report;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.google.common.io.Closeables;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchComponent;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DeprecatedDefaultInputFile;
import org.sonar.api.config.Settings;
import org.sonar.api.issue.internal.DefaultIssue;
import org.sonar.api.platform.Server;
import org.sonar.api.resources.Project;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleFinder;
import org.sonar.api.user.User;
import org.sonar.api.user.UserFinder;
import org.sonar.api.utils.SonarException;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.batch.bootstrap.AnalysisMode;
import org.sonar.batch.events.BatchStepEvent;
import org.sonar.batch.events.EventBus;
import org.sonar.batch.issue.IssueCache;
import org.sonar.batch.scan.filesystem.InputFileCache;

public class JsonReport
implements BatchComponent {
    private static final Logger LOG = LoggerFactory.getLogger(JsonReport.class);
    private final Settings settings;
    private final FileSystem fileSystem;
    private final Server server;
    private final RuleFinder ruleFinder;
    private final IssueCache issueCache;
    private final EventBus eventBus;
    private final AnalysisMode analysisMode;
    private final UserFinder userFinder;
    private final InputFileCache fileCache;
    private final Project rootModule;

    public JsonReport(Settings settings, FileSystem fileSystem, Server server, RuleFinder ruleFinder, IssueCache issueCache, EventBus eventBus, AnalysisMode analysisMode, UserFinder userFinder, Project rootModule, InputFileCache fileCache) {
        this.settings = settings;
        this.fileSystem = fileSystem;
        this.server = server;
        this.ruleFinder = ruleFinder;
        this.issueCache = issueCache;
        this.eventBus = eventBus;
        this.analysisMode = analysisMode;
        this.userFinder = userFinder;
        this.rootModule = rootModule;
        this.fileCache = fileCache;
    }

    public void execute() {
        if (this.analysisMode.isPreview()) {
            this.eventBus.fireEvent(new BatchStepEvent("JSON report", true));
            this.exportResults();
            this.eventBus.fireEvent(new BatchStepEvent("JSON report", false));
        }
    }

    private void exportResults() {
        File exportFile = new File(this.fileSystem.workDir(), this.settings.getString("sonar.report.export.path"));
        LOG.info("Export results to " + exportFile.getAbsolutePath());
        BufferedWriter output = null;
        try {
            output = new BufferedWriter(new FileWriter(exportFile));
            this.writeJson(output);
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException("Unable to write report results in file " + exportFile.getAbsolutePath(), e);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(output);
                throw throwable;
            }
        }
        Closeables.closeQuietly((Closeable)output);
    }

    @VisibleForTesting
    void writeJson(Writer writer) {
        try {
            JsonWriter json = JsonWriter.of((Writer)writer);
            json.beginObject();
            json.prop("version", this.server.getVersion());
            HashSet ruleKeys = Sets.newHashSet();
            HashSet userLogins = Sets.newHashSet();
            this.writeJsonIssues(json, ruleKeys, userLogins);
            this.writeJsonComponents(json);
            this.writeJsonRules(json, ruleKeys);
            List users = this.userFinder.findByLogins(new ArrayList(userLogins));
            this.writeUsers(json, users);
            json.endObject().close();
        }
        catch (IOException e) {
            throw new SonarException("Unable to write JSON report", (Throwable)e);
        }
    }

    private void writeJsonIssues(JsonWriter json, Set<RuleKey> ruleKeys, Set<String> logins) throws IOException {
        json.name("issues").beginArray();
        for (DefaultIssue issue : this.getIssues()) {
            if (issue.resolution() != null) continue;
            json.beginObject().prop("key", issue.key()).prop("component", issue.componentKey()).prop("line", (Number)issue.line()).prop("message", issue.message()).prop("severity", issue.severity()).prop("rule", issue.ruleKey().toString()).prop("status", issue.status()).prop("resolution", issue.resolution()).prop("isNew", issue.isNew()).prop("reporter", issue.reporter()).prop("assignee", issue.assignee()).prop("effortToFix", (Number)issue.effortToFix()).propDateTime("creationDate", issue.creationDate()).propDateTime("updateDate", issue.updateDate()).propDateTime("closeDate", issue.closeDate());
            if (issue.reporter() != null) {
                logins.add(issue.reporter());
            }
            if (issue.assignee() != null) {
                logins.add(issue.assignee());
            }
            json.endObject();
            ruleKeys.add(issue.ruleKey());
        }
        json.endArray();
    }

    private void writeJsonComponents(JsonWriter json) throws IOException {
        json.name("components").beginArray();
        this.writeJsonModuleComponents(json, this.rootModule);
        for (InputFile inputFile : this.fileCache.all()) {
            String key = ((DeprecatedDefaultInputFile)inputFile).key();
            json.beginObject().prop("key", key).prop("path", inputFile.relativePath()).prop("moduleKey", StringUtils.substringBeforeLast((String)key, (String)":")).prop("status", inputFile.status().name()).endObject();
        }
        json.endArray();
    }

    private void writeJsonModuleComponents(JsonWriter json, Project module) {
        json.beginObject().prop("key", module.getEffectiveKey()).prop("path", module.getPath()).endObject();
        for (Project subModule : module.getModules()) {
            this.writeJsonModuleComponents(json, subModule);
        }
    }

    private void writeJsonRules(JsonWriter json, Set<RuleKey> ruleKeys) throws IOException {
        json.name("rules").beginArray();
        for (RuleKey ruleKey : ruleKeys) {
            json.beginObject().prop("key", ruleKey.toString()).prop("rule", ruleKey.rule()).prop("repository", ruleKey.repository()).prop("name", this.getRuleName(ruleKey)).endObject();
        }
        json.endArray();
    }

    private void writeUsers(JsonWriter json, List<User> users) throws IOException {
        json.name("users").beginArray();
        for (User user : users) {
            json.beginObject().prop("login", user.login()).prop("name", user.name()).endObject();
        }
        json.endArray();
    }

    private String getRuleName(RuleKey ruleKey) {
        Rule rule = this.ruleFinder.findByKey(ruleKey);
        return rule != null ? rule.getName() : null;
    }

    @VisibleForTesting
    Iterable<DefaultIssue> getIssues() {
        return this.issueCache.all();
    }
}

