/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan2;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.analyzer.issue.internal.DefaultAnalyzerIssue;
import org.sonar.api.batch.analyzer.measure.internal.DefaultAnalyzerMeasure;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.config.Settings;
import org.sonar.api.utils.ZipUtils;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.batch.scan2.AnalyzerIssueCache;
import org.sonar.batch.scan2.AnalyzerMeasureCache;

public final class AnalysisPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(AnalysisPublisher.class);
    private final Settings settings;
    private final FileSystem fs;
    private final AnalyzerMeasureCache measureCache;
    private final ProjectDefinition def;
    private AnalyzerIssueCache issueCache;

    public AnalysisPublisher(ProjectDefinition def, Settings settings, FileSystem fs, AnalyzerMeasureCache measureCache, AnalyzerIssueCache analyzerIssueCache) {
        this.def = def;
        this.settings = settings;
        this.fs = fs;
        this.measureCache = measureCache;
        this.issueCache = analyzerIssueCache;
    }

    public void execute() {
        if (this.settings.getBoolean("sonar.skipPublish")) {
            LOG.debug("Publishing of results is skipped");
            return;
        }
        File exportDir = this.prepareExportDir();
        this.exportAnalysisProperties(exportDir);
        this.exportSourceFiles(exportDir);
        this.exportMeasures(exportDir);
        this.exportIssues(exportDir);
        this.createZip(exportDir);
    }

    private void createZip(File exportDir) {
        File exportZip = new File(this.fs.workDir(), this.def.getKey() + "-export.zip");
        try {
            ZipUtils.zipDir((File)exportDir, (File)exportZip);
            FileUtils.deleteDirectory((File)exportDir);
        }
        catch (IOException e) {
            throw this.unableToExport(e);
        }
        LOG.info("Results packaged in " + exportZip);
    }

    private IllegalStateException unableToExport(IOException e) {
        return new IllegalStateException("Unable to export result of analyzis", e);
    }

    private void exportIssues(File exportDir) {
        File issuesFile = new File(exportDir, "issues.json");
        FileWriter issueWriter = null;
        try {
            issueWriter = new FileWriter(issuesFile);
            JsonWriter jsonWriter = JsonWriter.of((Writer)issueWriter);
            jsonWriter.beginObject().name("issues").beginArray();
            for (DefaultAnalyzerIssue issue : this.issueCache.byModule(this.def.getKey())) {
                jsonWriter.beginObject().prop("repository", issue.ruleKey().repository()).prop("rule", issue.ruleKey().rule());
                if (issue.inputFile() != null) {
                    jsonWriter.prop("filePath", issue.inputFile().relativePath());
                }
                jsonWriter.prop("message", issue.message()).prop("effortToFix", (Number)issue.effortToFix()).prop("line", (Number)issue.line()).endObject();
            }
            jsonWriter.endArray().endObject().close();
        }
        catch (IOException e) {
            try {
                throw this.unableToExport(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(issueWriter);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)issueWriter);
    }

    private void exportMeasures(File exportDir) {
        File measuresFile = new File(exportDir, "measures.json");
        FileWriter measureWriter = null;
        try {
            measureWriter = new FileWriter(measuresFile);
            JsonWriter jsonWriter = JsonWriter.of((Writer)measureWriter);
            jsonWriter.beginObject().name("measures").beginArray();
            for (DefaultAnalyzerMeasure measure : this.measureCache.byModule(this.def.getKey())) {
                jsonWriter.beginObject().prop("metricKey", measure.metric().key());
                if (measure.inputFile() != null) {
                    jsonWriter.prop("filePath", measure.inputFile().relativePath());
                }
                jsonWriter.prop("value", String.valueOf(measure.value())).endObject();
            }
            jsonWriter.endArray().endObject().close();
        }
        catch (IOException e) {
            try {
                throw this.unableToExport(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(measureWriter);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)measureWriter);
    }

    private void exportSourceFiles(File exportDir) {
        File sourceDir = new File(exportDir, "sources");
        for (InputFile inputFile : this.fs.inputFiles(this.fs.predicates().all())) {
            File dest = new File(sourceDir, inputFile.relativePath());
            try {
                FileUtils.copyFile((File)inputFile.file(), (File)dest);
            }
            catch (IOException e) {
                throw this.unableToExport(e);
            }
        }
    }

    private void exportAnalysisProperties(File exportDir) {
        File propsFile = new File(exportDir, "analysis.properties");
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.settings.getProperties());
        FileWriter writer = null;
        try {
            writer = new FileWriter(propsFile);
            props.store(writer, "SonarQube batch");
        }
        catch (IOException e) {
            try {
                throw this.unableToExport(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)writer);
    }

    private File prepareExportDir() {
        File exportDir = new File(this.fs.workDir(), "export");
        try {
            if (exportDir.exists()) {
                FileUtils.forceDelete((File)exportDir);
            }
            FileUtils.forceMkdir((File)exportDir);
        }
        catch (IOException e) {
            throw this.unableToExport(e);
        }
        return exportDir;
    }
}

