/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan2;

import com.google.common.base.Preconditions;
import org.sonar.api.BatchComponent;
import org.sonar.api.batch.analyzer.measure.internal.DefaultAnalyzerMeasure;
import org.sonar.batch.index.Cache;
import org.sonar.batch.index.Caches;

public class AnalyzerMeasureCache
implements BatchComponent {
    private final Cache<DefaultAnalyzerMeasure> cache;

    public AnalyzerMeasureCache(Caches caches) {
        this.cache = caches.createCache("measures");
    }

    public Iterable<Cache.Entry<DefaultAnalyzerMeasure>> entries() {
        return this.cache.entries();
    }

    public Iterable<DefaultAnalyzerMeasure> byModule(String projectKey) {
        return this.cache.values(projectKey);
    }

    public DefaultAnalyzerMeasure<?> byMetric(String projectKey, String resourceKey, String metricKey) {
        return this.cache.get(projectKey, resourceKey, metricKey);
    }

    public AnalyzerMeasureCache put(String projectKey, String resourceKey, DefaultAnalyzerMeasure<?> measure) {
        Preconditions.checkNotNull((Object)projectKey);
        Preconditions.checkNotNull((Object)resourceKey);
        Preconditions.checkNotNull(measure);
        this.cache.put(projectKey, resourceKey, measure.metric().key(), measure);
        return this;
    }

    public boolean contains(String projectKey, String resourceKey, DefaultAnalyzerMeasure<?> measure) {
        Preconditions.checkNotNull((Object)projectKey);
        Preconditions.checkNotNull((Object)resourceKey);
        Preconditions.checkNotNull(measure);
        return this.cache.containsKey(projectKey, resourceKey, measure.metric().key());
    }

    public Iterable<DefaultAnalyzerMeasure> all() {
        return this.cache.values();
    }
}

