/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.batch.scan2;

import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.BatchComponent;
import org.sonar.api.batch.analyzer.Analyzer;
import org.sonar.api.batch.analyzer.AnalyzerContext;
import org.sonar.api.batch.analyzer.AnalyzerDescriptor;
import org.sonar.api.batch.analyzer.internal.DefaultAnalyzerDescriptor;
import org.sonar.batch.bootstrap.BatchExtensionDictionnary;
import org.sonar.batch.scan2.AnalyzerOptimizer;

public class AnalyzersExecutor
implements BatchComponent {
    private static final Logger LOG = LoggerFactory.getLogger(AnalyzersExecutor.class);
    private BatchExtensionDictionnary selector;
    private AnalyzerOptimizer optimizer;

    public AnalyzersExecutor(BatchExtensionDictionnary selector, AnalyzerOptimizer optimizer) {
        this.selector = selector;
        this.optimizer = optimizer;
    }

    public void execute(AnalyzerContext context) {
        Collection<Analyzer> analyzers = this.selector.select(Analyzer.class, null, true, null);
        for (Analyzer analyzer : analyzers) {
            DefaultAnalyzerDescriptor descriptor = new DefaultAnalyzerDescriptor();
            analyzer.describe((AnalyzerDescriptor)descriptor);
            if (!this.optimizer.shouldExecute(descriptor)) {
                LOG.debug("Analyzer skipped: " + descriptor.name());
                continue;
            }
            LOG.info("Execute analyzer: " + descriptor.name());
            this.executeSensor(context, analyzer);
        }
    }

    private void executeSensor(AnalyzerContext context, Analyzer analyzer) {
        analyzer.analyse(context);
    }
}

